/*
 * Copyright (c) 2005, 2006, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package com.sun.tools.internal.ws.wscompile;

import com.sun.tools.internal.xjc.api.ErrorListener;
import org.xml.sax.SAXParseException;

/**
 * @author Vivek Pandey
 */
public class WsimportListener implements ErrorListener {
    /**
     * Called for each file generated by wsimport or wsgen.
     *
     * <p>
     * The file name includes the path portions that correspond with the package name.
     *
     * <p>
     * When generating files into a directory, file names will be relative to the
     * output directory.
     *
     * @param fileName
     *      file names like "org/acme/foo/Foo.java"
     *
     */
    public void generatedFile(String fileName) {}

    /**
     * Other miscellenous messages that do not have structures
     * will be reported through this method.
     *
     * This method is used like {@link java.io.PrintStream#println(String)}.
     * The callee is expected to add '\n'.
     */
    public void message(String msg) {}
      
    public void error(SAXParseException exception) {

    }

    public void fatalError(SAXParseException exception) {

    }

    public void warning(SAXParseException exception) {

    }

    public void info(SAXParseException exception) {

    }

    public void debug(SAXParseException exception){}

    /**
     * wsimport will periodically invoke this method to see if it should cancel a compilation.
     * 
     * @return
     *      true if the {@link com.sun.tools.internal.ws.wscompile.WsimportListener} wants to abort the processing.
     * @since 2.1
     */
    public boolean isCanceled() {
        return false;
    }

}
