/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.util.gui.WidgetFactory;

public class SizeDialog
extends DrawDialog
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WIDTH = 1024;
    private static final int MAX_HEIGHT = 768;
    private Dimension dim = Tool.getPictureDimension();
    private final JTextField widthField;
    private final JTextField heightField;

    public SizeDialog() {
        super("Please enter image size:");
        this.widthField = new JTextField(String.valueOf(this.dim.width), 4);
        this.heightField = new JTextField(String.valueOf(this.dim.height), 4);
        WidgetFactory.addFocusAdapter(this.widthField);
        WidgetFactory.addFocusAdapter(this.heightField);
        this.setDefaultBorder();
        this.setModal(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.widthField.getDocument().addDocumentListener(this);
        this.heightField.getDocument().addDocumentListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.gridwidth = 2;
        JLabel jLabel = new JLabel("<html><b>Please enter image size:</b></html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = new JLabel("Width: ");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.widthField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel2 = new JLabel("Height: ");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.heightField, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setFirstFocusComponent(this.widthField);
    }

    public Dimension getInput() {
        return this.dim;
    }

    private void checkInput() {
        boolean bl = true;
        try {
            this.dim.width = Integer.parseInt(this.widthField.getText().trim());
            this.dim.height = Integer.parseInt(this.heightField.getText().trim());
            bl = this.dim.width > 0 && this.dim.height > 0 && this.dim.width < 1024 && this.dim.height < 768;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        this.getApproveButton().setEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }
}

