/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.undo;

import java.util.ArrayList;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.undo.Undoable;
import jdomain.util.Assert;

public final class UndoManager {
    private static final int MAX_UNDOS = 20;
    public static final UndoManager INSTANCE = new UndoManager();
    private final ArrayList buffer = new ArrayList();
    private int pos;
    private boolean hasChanges;
    static /* synthetic */ Class class$jdomain$jdraw$action$UndoAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RedoAction;

    private UndoManager() {
        this.reset();
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setHasChanges(boolean bl) {
        this.hasChanges = bl;
        if (MainFrame.INSTANCE != null) {
            MainFrame.INSTANCE.updateTitle();
        }
    }

    public void addUndoable(Undoable undoable) {
        Assert.isTrue(undoable.isValid(), "undo: invalid undoable " + undoable.getClass().getName());
        this.buffer.add(undoable);
        if (this.buffer.size() > 20) {
            this.buffer.remove(0);
        }
        this.pos = this.buffer.size();
        this.setHasChanges(true);
        this.updateActions();
    }

    private void updateActions() {
        DrawAction.getAction(class$jdomain$jdraw$action$UndoAction == null ? (class$jdomain$jdraw$action$UndoAction = UndoManager.class$("jdomain.jdraw.action.UndoAction")) : class$jdomain$jdraw$action$UndoAction).setEnabled(this.canUndo());
        DrawAction.getAction(class$jdomain$jdraw$action$RedoAction == null ? (class$jdomain$jdraw$action$RedoAction = UndoManager.class$("jdomain.jdraw.action.RedoAction")) : class$jdomain$jdraw$action$RedoAction).setEnabled(this.canRedo());
    }

    public void reset() {
        this.buffer.clear();
        this.pos = 0;
        this.setHasChanges(false);
        this.updateActions();
    }

    public void undo() {
        --this.pos;
        Undoable undoable = this.get(this.pos);
        undoable.undo();
        this.updateActions();
    }

    public void redo() {
        Undoable undoable = this.get(this.pos);
        undoable.redo();
        ++this.pos;
        this.updateActions();
    }

    private Undoable get(int n) {
        return (Undoable)this.buffer.get(n);
    }

    public boolean canUndo() {
        return this.pos != 0;
    }

    public boolean canRedo() {
        return !this.buffer.isEmpty() && this.pos < this.buffer.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

