/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jdomain.util.Log;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;
import jdomain.util.gui.StandardDialog;
import jdomain.util.gui.StandardMainFrame;
import jdomain.util.gui.TextCalculator;

public class FontDialog
extends StandardDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN_SIZE = 6;
    private static final int MAX_SIZE = 72;
    private static final int DEFAULT_SIZE = 12;
    private Font createdFont = GUIUtil.DEFAULT_FONT;
    private boolean antialiased = false;
    private JLabel info;
    private IApplyCallback callback;
    private JButton applyButton;
    private JPanel fontPanel;
    private JList fontList;
    private JList styleList;
    private JComboBox sizeDropDown;
    private final JCheckBox[] checkBoxes;
    private JCheckBox antialiasBox = new JCheckBox("Antialiased");
    private JTextArea textArea = new JTextArea(){
        private static final long serialVersionUID = 1L;

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, FontDialog.this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            super.paint(graphics2D);
        }
    };

    public FontDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, bl, null);
    }

    public FontDialog(JFrame jFrame, String string, boolean bl, JCheckBox[] jCheckBoxArray) {
        super(jFrame, string, bl);
        this.checkBoxes = jCheckBoxArray;
        this.createGui();
        this.update();
    }

    public FontDialog(StandardMainFrame standardMainFrame, String string) {
        this(standardMainFrame, string, null);
    }

    public FontDialog(StandardMainFrame standardMainFrame, String string, JCheckBox[] jCheckBoxArray) {
        super(standardMainFrame, string);
        this.checkBoxes = jCheckBoxArray;
        this.createGui();
        this.update();
    }

    public FontDialog(StandardMainFrame standardMainFrame) {
        this(standardMainFrame, "Font Selection", null);
    }

    public final void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
            this.antialiasBox.setSelected(bl);
            this.invalidate();
        }
    }

    public final void setApplyCallback(IApplyCallback iApplyCallback) {
        this.callback = iApplyCallback;
        if (this.callback == null) {
            this.getLeftButtonPanel().remove(this.applyButton);
            this.applyButton = null;
        } else {
            this.applyButton = new JButton("Apply");
            this.addLeftButton(this.applyButton);
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontDialog.this.callback.apply();
                }
            });
        }
    }

    public final boolean isAntialiased() {
        return this.antialiased;
    }

    public final Font getFont() {
        if (this.getResult() == 1) {
            return this.createdFont;
        }
        return null;
    }

    public String getText() {
        if (this.getResult() == 1) {
            return this.textArea.getText().trim();
        }
        return null;
    }

    private void createGui() {
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setUndecorated(false);
        this.setResizable(true);
        this.setDefaultBorder();
        this.setModal(true);
        this.fontPanel = this.createFontPanel();
        this.main.add((Component)this.fontPanel, "Center");
        this.antialiasBox.setSelected(this.antialiased);
        this.antialiasBox.addActionListener(this);
        this.fontList.setSelectedIndex(0);
        this.fontList.addListSelectionListener(this);
        this.sizeDropDown.setSelectedIndex(6);
        this.sizeDropDown.addActionListener(this);
        this.styleList.setSelectedIndex(0);
        this.styleList.addListSelectionListener(this);
        this.textArea.setText("Enter your text here...");
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(GUIUtil.BOLD_FONT);
        jLabel.setHorizontalAlignment(2);
        jLabel.setVerticalAlignment(1);
        jLabel.setBorder(new EmptyBorder(n, n2, 0, 10));
        return jLabel;
    }

    private JPanel createFontPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.createFontList(), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = this.createLabel("Size:", 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.createSizeComp(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = this.createLabel("Style:", 0, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.createStyleList(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        gridBagConstraints.gridx = 2;
        ++gridBagConstraints.gridy;
        jPanel2.add(this.antialiasBox);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.checkBoxes != null) {
            int n = this.checkBoxes.length;
            for (int i = 0; i < n; ++i) {
                jPanel2.add(this.checkBoxes[i]);
            }
        }
        ++gridBagConstraints.gridy;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JLabel jLabel3 = this.createLabel("Text:", 10, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.createTextComp(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.info = this.createLabel(" ", 10, 0);
        this.info.setBorder(null);
        this.info.setFont(GUIUtil.DEFAULT_FONT);
        jPanel.add((Component)this.info, gridBagConstraints);
        return jPanel;
    }

    private JComponent createSizeComp() {
        ArrayList<SizeEntry> arrayList = new ArrayList<SizeEntry>();
        for (int i = 6; i < 72; ++i) {
            arrayList.add(new SizeEntry(new Integer(i)));
        }
        SizeEntry[] sizeEntryArray = new SizeEntry[arrayList.size()];
        arrayList.toArray(sizeEntryArray);
        this.sizeDropDown = new JComboBox<SizeEntry>(sizeEntryArray);
        this.sizeDropDown.setEditable(true);
        Rectangle rectangle = TextCalculator.getStringWidth("7777", GUIUtil.DEFAULT_FONT, true);
        Dimension dimension = this.sizeDropDown.getPreferredSize();
        dimension.width = rectangle.width;
        this.sizeDropDown.setPreferredSize(dimension);
        return this.sizeDropDown;
    }

    private JComponent createTextComp() {
        this.textArea.setFont(GUIUtil.DEFAULT_FONT);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(160, 80));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JComponent createFontList() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray.length;
        FontEntry[] fontEntryArray = new FontEntry[n];
        for (int i = 0; i < n; ++i) {
            fontEntryArray[i] = new FontEntry(stringArray[i]);
        }
        this.fontList = new JList<FontEntry>(fontEntryArray);
        JScrollPane jScrollPane = new JScrollPane(this.fontList);
        return jScrollPane;
    }

    private JComponent createStyleList() {
        ArrayList<StyleEntry> arrayList = new ArrayList<StyleEntry>();
        arrayList.add(new StyleEntry("Plain", 0));
        arrayList.add(new StyleEntry("Bold", 1));
        arrayList.add(new StyleEntry("Italic", 2));
        arrayList.add(new StyleEntry("Bold+Italic", 3));
        StyleEntry[] styleEntryArray = new StyleEntry[arrayList.size()];
        arrayList.toArray(styleEntryArray);
        this.styleList = new JList<StyleEntry>(styleEntryArray);
        this.styleList.setBorder(new SoftBevelBorder(1));
        return this.styleList;
    }

    private String getFontString(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append(", ");
        stringBuffer.append(font.getSize());
        stringBuffer.append(", ");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(font.isPlain() ? "plain " : "");
        if (font.isBold() && font.isItalic()) {
            stringBuffer2.append("bold+italic");
        } else {
            stringBuffer2.append(font.isBold() ? "bold " : "");
            stringBuffer2.append(font.isItalic() ? "italic " : "");
        }
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    protected void update() {
        Font font;
        block6: {
            Object object;
            font = GUIUtil.DEFAULT_FONT;
            this.antialiased = this.antialiasBox.isSelected();
            FontEntry fontEntry = (FontEntry)this.fontList.getSelectedValue();
            SizeEntry sizeEntry = null;
            Object object2 = this.sizeDropDown.getSelectedItem();
            if (object2 instanceof SizeEntry) {
                sizeEntry = (SizeEntry)object2;
            } else if (object2 instanceof String && Util.isNumber((String)(object = (String)object2), 1, 300)) {
                sizeEntry = new SizeEntry(new Integer(Util.asInt((String)object)));
            }
            object = (StyleEntry)this.styleList.getSelectedValue();
            if (fontEntry != null && sizeEntry != null && object != null) {
                try {
                    font = new Font(fontEntry.toString(), ((StyleEntry)object).style, sizeEntry.size);
                }
                catch (ArithmeticException arithmeticException) {
                    if (!Log.DEBUG) break block6;
                    Log.debug("font not available: " + fontEntry.toString());
                }
            }
        }
        this.createdFont = font;
        this.textArea.setFont(font);
        this.info.setText(this.getFontString(font));
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    public final void setFontBackground(Color color) {
        this.textArea.setOpaque(color.getAlpha() == 255);
        this.textArea.setBackground(color);
    }

    public final void setFontForeground(Color color) {
        this.textArea.setForeground(color);
    }

    public static interface IApplyCallback {
        public void apply();
    }

    private final class StyleEntry {
        public final int style;
        public final String name;

        public StyleEntry(String string, int n) {
            this.name = string;
            this.style = n;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SizeEntry {
        public final Integer size;

        public SizeEntry(Integer n) {
            this.size = n;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }

    private final class FontEntry {
        public final String fontName;

        public FontEntry(String string) {
            this.fontName = string;
        }

        public String toString() {
            return this.fontName;
        }
    }
}

