/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;
import jdomain.util.Util;
import jdomain.util.gui.StandardDialog;
import jdomain.util.gui.StandardMainFrame;
import jdomain.util.gui.TextCalculator;

public final class GUIUtil {
    public static final String IMAGE_PATH = "jdomain/util/images/";
    public static final String GEOMETRY_PARAM = "geometry";
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Font BOLD_FONT = new Font("SansSerif", 1, 12);
    private static final int DIALOG_ICON_SIZE = 48;
    private static final int DIALOG_TEXT_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width / 4;
    private static final Rectangle GEOMETRY = GUIUtil.parseGeometry();
    static /* synthetic */ Class class$jdomain$util$gui$GUIUtil;

    private GUIUtil() {
    }

    private static LookAndFeel createLF(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof LookAndFeel) {
                Log.info("Look&Feel '" + string + "' created.");
                return (LookAndFeel)obj;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.warning("Class '" + string + "' not found.");
        }
        catch (Throwable throwable) {
            Log.warning("Could not create Look&Feel '" + string + "'.");
        }
        return null;
    }

    public static LookAndFeel findLF(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith("-lf=")) continue;
            String string = stringArray[i].substring(4);
            System.setProperty("lf", string);
            stringArray[i] = null;
        }
        return GUIUtil.findLF();
    }

    public static LookAndFeel findLF() {
        LookAndFeel lookAndFeel = null;
        String string = System.getProperty("lf");
        if (string != null) {
            lookAndFeel = GUIUtil.createLF(string);
        }
        if (lookAndFeel == null) {
            block4: {
                string = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
                try {
                    (class$jdomain$util$gui$GUIUtil == null ? (class$jdomain$util$gui$GUIUtil = GUIUtil.class$("jdomain.util.gui.GUIUtil")) : class$jdomain$util$gui$GUIUtil).getClassLoader().loadClass(string);
                }
                catch (Throwable throwable) {
                    string = UIManager.getSystemLookAndFeelClassName();
                    if (string.indexOf("MotifLookAndFeel") == -1) break block4;
                    string = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
            }
            lookAndFeel = GUIUtil.createLF(string);
        }
        return lookAndFeel;
    }

    public static Action createSaveLookFeelPropertiesAction(final String string) {
        AbstractAction abstractAction = new AbstractAction("Print Look&Feel properties"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(string);
                GUIUtil.saveLookFeelProperties(file);
            }
        };
        return abstractAction;
    }

    public static void waitForImage(ImageIcon imageIcon) {
        while (imageIcon.getIconWidth() == -1 || imageIcon.getIconHeight() == -1) {
            Util.delay(100L);
        }
    }

    public static Graphics2D createGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return graphics2D;
    }

    public static int print(String string, Hashtable hashtable, PrintStream printStream) {
        Iterator iterator = hashtable.keySet().iterator();
        int n = 0;
        printStream.println();
        printStream.println("Hashtable : " + string);
        printStream.println();
        while (iterator.hasNext()) {
            ++n;
            Object k = iterator.next();
            Object v = hashtable.get(k);
            printStream.println("Key:   " + k + " (" + Util.shortClassName(k.getClass()) + ")");
            printStream.println("Value: " + hashtable.get(k) + " (" + Util.shortClassName(v) + ")");
            printStream.println();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLookFeelProperties(File file) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("Properties of Look&Feel '" + UIManager.getLookAndFeel().getName() + "'");
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(UIManager.getDefaults());
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>(UIManager.getLookAndFeelDefaults());
            int n = GUIUtil.print("UIDefaults", hashtable, printStream);
            n += GUIUtil.print("Look&Feel Defaults", hashtable2, printStream);
            if (Log.DEBUG) {
                Log.debug(">> " + n + " properties written to " + file.getAbsolutePath());
            }
            printStream.flush();
            Util.close(printStream);
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
        finally {
            Util.close(printStream);
        }
    }

    public static boolean yesNo(StandardMainFrame standardMainFrame, String string) {
        return GUIUtil.question(standardMainFrame, "Question", string, "Yes", "No");
    }

    public static boolean yesNo(StandardMainFrame standardMainFrame, String string, String string2) {
        return GUIUtil.question(standardMainFrame, string, string2, "Yes", "No");
    }

    public static boolean question(StandardMainFrame standardMainFrame, String string) {
        return GUIUtil.question(standardMainFrame, "Question", string, "OK", "Cancel");
    }

    public static void invokeLater(Object object, String string) {
        try {
            Method method = object.getClass().getMethod(string, null);
            GUIUtil.invokeLater(object, method, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.error("Can't find method " + string + " on " + object.getClass() + "\n" + noSuchMethodException.toString());
        }
    }

    public static void invokeLater(final Object object, final Method method, final Object[] objectArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    method.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    Log.exception(exception);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static Component findParentComponentOfClass(Component component, Class clazz) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!clazz.isAssignableFrom(container.getClass())) continue;
            return container;
        }
        return null;
    }

    public static boolean question(StandardMainFrame standardMainFrame, String string, String string2, String string3, String string4) {
        int n = GUIUtil.dialog(standardMainFrame, string, string2, ResourceLoader.getImage("jdomain/util/images/question.png", 48), string3, string4, null);
        return n == 1;
    }

    public static int question(StandardMainFrame standardMainFrame, String string, String string2, String string3, String string4, String string5) {
        int n = GUIUtil.dialog(standardMainFrame, string, string2, ResourceLoader.getImage("jdomain/util/images/question.png", 48), string3, string4, string5);
        return n;
    }

    public static void info(StandardMainFrame standardMainFrame, String string) {
        GUIUtil.info(standardMainFrame, string, "OK");
    }

    public static void info(StandardMainFrame standardMainFrame, String string, String string2) {
        GUIUtil.info(standardMainFrame, "Info", string, string2);
    }

    public static void info(StandardMainFrame standardMainFrame, String string, String string2, String string3) {
        GUIUtil.dialog(standardMainFrame, string, string2, ResourceLoader.getImage("jdomain/util/images/info.png", 48), string3, null, null);
    }

    public static void warning(StandardMainFrame standardMainFrame, String string) {
        GUIUtil.warning(standardMainFrame, "Warning", string, "OK");
    }

    public static void warning(StandardMainFrame standardMainFrame, String string, String string2) {
        GUIUtil.warning(standardMainFrame, "Warning", string, string2);
    }

    public static void warning(StandardMainFrame standardMainFrame, String string, String string2, String string3) {
        GUIUtil.dialog(standardMainFrame, string, string2, ResourceLoader.getImage("jdomain/util/images/warning.png", 48), string3, null, null);
    }

    public static void error(StandardMainFrame standardMainFrame, String string) {
        GUIUtil.error(standardMainFrame, string, "OK");
    }

    public static void error(StandardMainFrame standardMainFrame, String string, String string2) {
        GUIUtil.error(standardMainFrame, "Error", string, string2);
    }

    public static void error(StandardMainFrame standardMainFrame, String string, String string2, String string3) {
        GUIUtil.dialog(standardMainFrame, string, string2, ResourceLoader.getImage("jdomain/util/images/error.png", 48), string3, null, null);
    }

    private static int dialog(StandardMainFrame standardMainFrame, String string, String string2, ImageIcon imageIcon, String string3, String string4, String string5) {
        if (string2 == null || string2.length() == 0) {
            string2 = "<no text given>";
        }
        StandardDialog standardDialog = new StandardDialog(standardMainFrame, string);
        standardDialog.addRightButton(standardDialog.getApproveButton());
        standardDialog.getApproveButton().setText(string3);
        standardDialog.getRootPane().setDefaultButton(standardDialog.getApproveButton());
        if (string4 != null) {
            standardDialog.addRightButton(standardDialog.getCancelButton());
            standardDialog.getCancelButton().setText(string4);
        }
        if (string5 != null) {
            standardDialog.addRightButton(standardDialog.getAbortButton());
            standardDialog.getAbortButton().setText(string5);
        }
        standardDialog.addButtonPanel();
        standardDialog.setUndecorated(false);
        standardDialog.setDefaultBorder();
        standardDialog.setModal(true);
        JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, "West");
        jLabel.setVerticalAlignment(1);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 4));
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setFont(BOLD_FONT);
        jPanel2.add((Component)jLabel2, "North");
        TextCalculator textCalculator = new TextCalculator(DIALOG_TEXT_WIDTH, string2, DEFAULT_FONT, true);
        JLabel jLabel3 = textCalculator.createLabel();
        jLabel3.setFont(DEFAULT_FONT);
        jPanel2.add((Component)jLabel3, "Center");
        jPanel.add((Component)jPanel2, "Center");
        standardDialog.main.add((Component)jPanel, "Center");
        standardDialog.open();
        return standardDialog.getResult();
    }

    public static Rectangle getGeometry() {
        return GEOMETRY;
    }

    private static Rectangle parseGeometry() {
        Object object;
        Rectangle rectangle = null;
        String string = System.getProperty(GEOMETRY_PARAM);
        if (string != null) {
            object = new StringTokenizer(string, "x+-", true);
            if (((StringTokenizer)object).countTokens() != 7) {
                Log.error("Invalid geometry expression \"" + string + "\"");
            }
            String[] stringArray = new String[7];
            for (int i = 0; i < 7; ++i) {
                stringArray[i] = ((StringTokenizer)object).nextToken();
            }
            if (!(stringArray[1].equals("x") && stringArray[3].equals("+") && stringArray[5].equals("+"))) {
                Log.error("Invalid geometry separators in \"" + string + "\"");
            }
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    nArray[i] = Integer.parseInt(stringArray[i * 2]);
                    if (nArray[i] >= 0) continue;
                    throw new RuntimeException("Geometry value \"" + nArray[i] + "\" out of range");
                }
                catch (Exception exception) {
                    Log.error("Invalid geometry dimension \"" + stringArray[i] + "\"");
                }
            }
            rectangle = new Rectangle(nArray[2], nArray[3], nArray[0], nArray[1]);
        }
        if (rectangle == null) {
            object = Toolkit.getDefaultToolkit().getScreenSize();
            ((Dimension)object).width -= 100;
            ((Dimension)object).height -= 100;
            rectangle = new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        }
        return rectangle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

