/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.ConsoleInstall;
import installer.NonInteractiveInstall;
import installer.OperatingSystem;
import installer.Progress;
import installer.SwingInstall;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Install {
    private Properties props = new Properties();
    private byte[] buf;

    public static void main(String[] stringArray) {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.3") < 0) {
            System.err.println("You are running Java version " + string + ".");
            System.err.println("This installer requires Java 1.3 or later.");
            System.exit(1);
        }
        if (stringArray.length == 0) {
            new SwingInstall();
        } else if (stringArray.length == 1 && stringArray[0].equals("text")) {
            new ConsoleInstall();
        } else if (stringArray.length >= 2 && stringArray[0].equals("auto")) {
            new NonInteractiveInstall(stringArray);
        } else {
            System.err.println("Usage:");
            System.err.println("java -jar <installer JAR>");
            System.err.println("java -jar <installer JAR> text");
            System.err.println("java -jar <installer JAR> auto <install dir> [unix-script=<dir>] [unix-man=<dir>]");
            System.err.println("text parameter starts installer in text-only mode.");
            System.err.println("auto parameter starts installer in non-interactive mode.");
        }
    }

    public Install() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/installer/install.props");
            this.props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error loading 'install.props':");
            iOException.printStackTrace();
        }
        this.buf = new byte[32768];
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public int getIntegerProperty(String string) {
        try {
            return Integer.parseInt(this.props.getProperty(string));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void copy(InputStream inputStream, String string, Progress progress) throws IOException {
        int n;
        File file = new File(string);
        OperatingSystem.getOperatingSystem().mkdirs(file.getParent());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = inputStream.read(this.buf, 0, Math.min(inputStream.available(), this.buf.length))) != -1 && n != 0) {
            bufferedOutputStream.write(this.buf, 0, n);
            if (progress == null) continue;
            progress.advance(n);
        }
        bufferedOutputStream.close();
    }
}

