/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.BZip2Constants;
import installer.CRC;
import java.io.IOException;
import java.io.OutputStream;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int UPPER_BYTE_MASK = -256;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int QSORT_STACK_SIZE = 1000;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_mtfFreq = new int[258];
    private int m_currentChar = -1;
    private int m_runLength;
    private boolean m_closed;
    private int[] m_incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private int m_last;
    private int m_origPtr;
    private int m_allowableBlockSize;
    private char[] m_block;
    private int m_blockCRC;
    private int m_combinedCRC;
    private OutputStream m_bsStream;
    private boolean m_firstAttempt;
    private int[] m_ftab;
    private int m_nInUse;
    private int m_nMTF;
    private int[] m_quadrant;
    private short[] m_szptr;
    private int m_workDone;
    private int m_workFactor;
    private int m_workLimit;
    private int[] m_zptr;

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        this.bsSetStream(outputStream);
        this.m_workFactor = 50;
        int n2 = n;
        if (n2 > 9) {
            n2 = 9;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.m_blockSize100k = n2;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private static void hbMakeCodeLengths(char[] cArray, int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n3 = 1; n3 <= n; ++n3) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n8 >= 260) {
                CBZip2OutputStream.panic();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = ++n7;
                nArray4[n11] = n7;
                n6 = nArray3[n9];
                n5 = nArray3[n11];
                nArray3[n7] = n10 = CBZip2OutputStream.calculateWeight(n6, n5);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                int n12 = 0;
                int n13 = 0;
                n12 = n8;
                n13 = nArray2[n12];
                while (nArray3[n13] < nArray3[nArray2[n12 >> 1]]) {
                    nArray2[n12] = nArray2[n12 >> 1];
                    n12 >>= 1;
                }
                nArray2[n12] = n13;
            }
            if (n7 >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean bl = false;
            for (n3 = 1; n3 <= n; ++n3) {
                n4 = 0;
                int n14 = n3;
                while (nArray4[n14] >= 0) {
                    n14 = nArray4[n14];
                    ++n4;
                }
                cArray[n3 - 1] = (char)n4;
                if (n4 <= n2) continue;
                bl = true;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    private static int calculateWeight(int n, int n2) {
        int n3 = (n & 0xFFFFFF00) + (n2 & 0xFFFFFF00);
        int n4 = n & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = n4 > n5 ? n4 : n5;
        return n3 | 1 + n6;
    }

    private static void panic() {
        System.out.println("panic");
    }

    public void close() throws IOException {
        if (this.m_closed) {
            return;
        }
        if (this.m_runLength > 0) {
            this.writeRun();
        }
        this.m_currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.m_closed = true;
        super.close();
        this.m_bsStream.close();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.m_bsStream.flush();
    }

    public void write(int n) throws IOException {
        int n2 = (256 + n) % 256;
        if (this.m_currentChar != -1) {
            if (this.m_currentChar == n2) {
                ++this.m_runLength;
                if (this.m_runLength > 254) {
                    this.writeRun();
                    this.m_currentChar = -1;
                    this.m_runLength = 0;
                }
            } else {
                this.writeRun();
                this.m_runLength = 1;
                this.m_currentChar = n2;
            }
        } else {
            this.m_currentChar = n2;
            ++this.m_runLength;
        }
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.m_blockSize100k;
        this.m_block = new char[n + 1 + 20];
        this.m_quadrant = new int[n + 20];
        this.m_zptr = new int[n];
        this.m_ftab = new int[65537];
        if (this.m_block == null || this.m_quadrant == null || this.m_zptr == null || this.m_ftab == null) {
            // empty if block
        }
        this.m_szptr = new short[2 * n];
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.m_bsLive > 0) {
            int n = this.m_bsBuff >> 24;
            this.m_bsStream.write(n);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsSetStream(OutputStream outputStream) {
        this.m_bsStream = outputStream;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.m_bsLive >= 8) {
            int n3 = this.m_bsBuff >> 24;
            this.m_bsStream.write(n3);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
        this.m_bsBuff |= n2 << 32 - this.m_bsLive - n;
        this.m_bsLive += n;
    }

    private void doReversibleTransformation() {
        this.m_workLimit = this.m_workFactor * this.m_last;
        this.m_workDone = 0;
        this.m_blockRandomised = false;
        this.m_firstAttempt = true;
        this.mainSort();
        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
            this.randomiseBlock();
            this.m_workLimit = 0;
            this.m_workDone = 0;
            this.m_blockRandomised = true;
            this.m_firstAttempt = false;
            this.mainSort();
        }
        this.m_origPtr = -1;
        for (int i = 0; i <= this.m_last; ++i) {
            if (this.m_zptr[i] != 0) continue;
            this.m_origPtr = i;
            break;
        }
        if (this.m_origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.m_blockCRC = this.m_crc.getFinalCRC();
        this.m_combinedCRC = this.m_combinedCRC << 1 | this.m_combinedCRC >>> 31;
        this.m_combinedCRC ^= this.m_blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.m_blockCRC);
        if (this.m_blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.m_combinedCRC);
        this.bsFinishedWithStream();
    }

    private boolean fullGtU(int n, int n2) {
        char c = this.m_block[n + 1];
        char c2 = this.m_block[n2 + 1];
        if (c != c2) {
            return c > c2;
        }
        if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
            return c > c2;
        }
        ++n;
        ++n2;
        int n3 = this.m_last + 1;
        do {
            if ((c = this.m_block[n + 1]) != (c2 = this.m_block[n2 + 1])) {
                return c > c2;
            }
            int n4 = this.m_quadrant[n];
            int n5 = this.m_quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.m_quadrant[n];
            n5 = this.m_quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.m_quadrant[n];
            n5 = this.m_quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.m_block[++n + 1]) != (c2 = this.m_block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.m_quadrant[n];
            n5 = this.m_quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            ++n2;
            if (++n > this.m_last) {
                n -= this.m_last;
                --n;
            }
            if (n2 > this.m_last) {
                n2 -= this.m_last;
                --n2;
            }
            ++this.m_workDone;
        } while ((n3 -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        int n;
        char[] cArray = new char[256];
        this.makeMaps();
        int n2 = this.m_nInUse + 1;
        for (n = 0; n <= n2; ++n) {
            this.m_mtfFreq[n] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.m_nInUse; ++n) {
            cArray[n] = (char)n;
        }
        for (n = 0; n <= this.m_last; ++n) {
            char c = this.m_unseqToSeq[this.m_block[this.m_zptr[n]]];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                while (true) {
                    switch (n4 % 2) {
                        case 0: {
                            this.m_szptr[n3] = 0;
                            ++n3;
                            this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.m_szptr[n3] = 1;
                            ++n3;
                            this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                        }
                    }
                    if (n4 < 2) break;
                    n4 = (n4 - 2) / 2;
                }
                n4 = 0;
            }
            this.m_szptr[n3] = (short)(n5 + 1);
            ++n3;
            int n6 = n5 + 1;
            this.m_mtfFreq[n6] = this.m_mtfFreq[n6] + 1;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                switch (n4 % 2) {
                    case 0: {
                        this.m_szptr[n3] = 0;
                        ++n3;
                        this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.m_szptr[n3] = 1;
                        ++n3;
                        this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                    }
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.m_szptr[n3] = (short)n2;
        int n7 = n2;
        this.m_mtfFreq[n7] = this.m_mtfFreq[n7] + 1;
        this.m_nMTF = ++n3;
    }

    private void hbAssignCodes(int[] nArray, char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] != i) continue;
                nArray[j] = n4++;
            }
            n4 <<= 1;
        }
    }

    private void initBlock() {
        this.m_crc.initialiseCRC();
        this.m_last = -1;
        for (int i = 0; i < 256; ++i) {
            this.m_inUse[i] = false;
        }
        this.m_allowableBlockSize = 100000 * this.m_blockSize100k - 20;
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.m_blockSize100k);
        this.m_combinedCRC = 0;
    }

    private void mainSort() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        for (n = 0; n < 20; ++n) {
            this.m_block[this.m_last + n + 2] = this.m_block[n % (this.m_last + 1) + 1];
        }
        for (n = 0; n <= this.m_last + 20; ++n) {
            this.m_quadrant[n] = 0;
        }
        this.m_block[0] = this.m_block[this.m_last + 1];
        if (this.m_last < 4000) {
            for (n = 0; n <= this.m_last; ++n) {
                this.m_zptr[n] = n;
            }
            this.m_firstAttempt = false;
            this.m_workDone = 0;
            this.m_workLimit = 0;
            this.simpleSort(0, this.m_last, 0);
        } else {
            int n2;
            int n3;
            char c;
            for (n = 0; n <= 255; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n <= 65536; ++n) {
                this.m_ftab[n] = 0;
            }
            char c2 = this.m_block[0];
            for (n = 0; n <= this.m_last; ++n) {
                c = this.m_block[n + 1];
                int n4 = (c2 << 8) + c;
                this.m_ftab[n4] = this.m_ftab[n4] + 1;
                c2 = c;
            }
            for (n = 1; n <= 65536; ++n) {
                int n5 = n;
                this.m_ftab[n5] = this.m_ftab[n5] + this.m_ftab[n - 1];
            }
            c2 = this.m_block[1];
            n = 0;
            while (n < this.m_last) {
                c = this.m_block[n + 2];
                n3 = (c2 << 8) + c;
                c2 = c;
                int n6 = n3;
                this.m_ftab[n6] = this.m_ftab[n6] - 1;
                this.m_zptr[this.m_ftab[n3]] = n++;
            }
            int n7 = n3 = (this.m_block[this.m_last + 1] << 8) + this.m_block[1];
            this.m_ftab[n7] = this.m_ftab[n7] - 1;
            this.m_zptr[this.m_ftab[n3]] = this.m_last;
            for (n = 0; n <= 255; ++n) {
                nArray[n] = n;
            }
            int n8 = 1;
            while ((n8 = 3 * n8 + 1) <= 256) {
            }
            do {
                for (n = n8 /= 3; n <= 255; ++n) {
                    n2 = nArray[n];
                    n3 = n;
                    while (this.m_ftab[nArray[n3 - n8] + 1 << 8] - this.m_ftab[nArray[n3 - n8] << 8] > this.m_ftab[n2 + 1 << 8] - this.m_ftab[n2 << 8]) {
                        nArray[n3] = nArray[n3 - n8];
                        if ((n3 -= n8) > n8 - 1) continue;
                    }
                    nArray[n3] = n2;
                }
            } while (n8 != 1);
            for (n = 0; n <= 255; ++n) {
                int n9 = nArray[n];
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n10 = (n9 << 8) + n3;
                    if ((this.m_ftab[n10] & 0x200000) == 0x200000) continue;
                    n8 = (this.m_ftab[n10 + 1] & 0xFFDFFFFF) - 1;
                    n2 = this.m_ftab[n10] & 0xFFDFFFFF;
                    if (n8 > n2) {
                        this.qSort3(n2, n8, 2);
                        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
                            return;
                        }
                    }
                    int n11 = n10;
                    this.m_ftab[n11] = this.m_ftab[n11] | 0x200000;
                }
                blArray[n9] = true;
                if (n < 255) {
                    n2 = this.m_ftab[n9 << 8] & 0xFFDFFFFF;
                    n8 = (this.m_ftab[n9 + 1 << 8] & 0xFFDFFFFF) - n2;
                    int n12 = 0;
                    while (n8 >> n12 > 65534) {
                        ++n12;
                    }
                    for (n3 = 0; n3 < n8; ++n3) {
                        int n13;
                        int n14 = this.m_zptr[n2 + n3];
                        this.m_quadrant[n14] = n13 = n3 >> n12;
                        if (n14 >= 20) continue;
                        this.m_quadrant[n14 + this.m_last + 1] = n13;
                    }
                    if (n8 - 1 >> n12 > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    nArray2[n3] = this.m_ftab[(n3 << 8) + n9] & 0xFFDFFFFF;
                }
                for (n3 = this.m_ftab[n9 << 8] & 0xFFDFFFFF; n3 < (this.m_ftab[n9 + 1 << 8] & 0xFFDFFFFF); ++n3) {
                    c2 = this.m_block[this.m_zptr[n3]];
                    if (blArray[c2]) continue;
                    this.m_zptr[nArray2[c2]] = this.m_zptr[n3] == 0 ? this.m_last : this.m_zptr[n3] - 1;
                    char c3 = c2;
                    nArray2[c3] = nArray2[c3] + 1;
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n15 = (n3 << 8) + n9;
                    this.m_ftab[n15] = this.m_ftab[n15] | 0x200000;
                }
            }
        }
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.m_inUse[i]) continue;
            this.m_seqToUnseq[this.m_nInUse] = (char)i;
            this.m_unseqToSeq[i] = (char)this.m_nInUse;
            ++this.m_nInUse;
        }
    }

    private char med3(char c, char c2, char c3) {
        char c4;
        if (c > c2) {
            c4 = c;
            c = c2;
            c2 = c4;
        }
        if (c2 > c3) {
            c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        if (c > c2) {
            c2 = c;
        }
        return c2;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.m_origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void qSort3(int n, int n2, int n3) {
        int n4;
        StackElem[] stackElemArray = new StackElem[1000];
        for (n4 = 0; n4 < 1000; ++n4) {
            stackElemArray[n4] = new StackElem();
        }
        int n5 = 0;
        stackElemArray[n5].m_ll = n;
        stackElemArray[n5].m_hh = n2;
        stackElemArray[n5].m_dd = n3;
        ++n5;
        while (n5 > 0) {
            int n6;
            if (n5 >= 1000) {
                CBZip2OutputStream.panic();
            }
            int n7 = stackElemArray[--n5].m_ll;
            int n8 = stackElemArray[n5].m_hh;
            int n9 = stackElemArray[n5].m_dd;
            if (n8 - n7 < 20 || n9 > 10) {
                this.simpleSort(n7, n8, n9);
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            char c = this.med3(this.m_block[this.m_zptr[n7] + n9 + 1], this.m_block[this.m_zptr[n8] + n9 + 1], this.m_block[this.m_zptr[n7 + n8 >> 1] + n9 + 1]);
            int n10 = n7;
            int n11 = n7;
            int n12 = n8;
            int n13 = n8;
            while (true) {
                if (n10 <= n12) {
                    n6 = this.m_block[this.m_zptr[n10] + n9 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.m_zptr[n10];
                        this.m_zptr[n10] = this.m_zptr[n11];
                        this.m_zptr[n11] = n4;
                        ++n11;
                        ++n10;
                        continue;
                    }
                    if (n6 <= 0) {
                        ++n10;
                        continue;
                    }
                }
                while (n10 <= n12) {
                    n6 = this.m_block[this.m_zptr[n12] + n9 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.m_zptr[n12];
                        this.m_zptr[n12] = this.m_zptr[n13];
                        this.m_zptr[n13] = n4;
                        --n13;
                        --n12;
                        continue;
                    }
                    if (n6 < 0) break;
                    --n12;
                }
                if (n10 > n12) break;
                n4 = 0;
                n4 = this.m_zptr[n10];
                this.m_zptr[n10] = this.m_zptr[n12];
                this.m_zptr[n12] = n4;
                ++n10;
                --n12;
            }
            if (n13 < n11) {
                stackElemArray[n5].m_ll = n7;
                stackElemArray[n5].m_hh = n8;
                stackElemArray[n5].m_dd = n9 + 1;
                ++n5;
                continue;
            }
            n6 = n11 - n7 < n10 - n11 ? n11 - n7 : n10 - n11;
            this.vswap(n7, n10 - n6, n6);
            int n14 = n8 - n13 < n13 - n12 ? n8 - n13 : n13 - n12;
            this.vswap(n10, n8 - n14 + 1, n14);
            n6 = n7 + n10 - n11 - 1;
            n14 = n8 - (n13 - n12) + 1;
            stackElemArray[n5].m_ll = n7;
            stackElemArray[n5].m_hh = n6;
            stackElemArray[n5].m_dd = n9;
            stackElemArray[++n5].m_ll = n6 + 1;
            stackElemArray[n5].m_hh = n14 - 1;
            stackElemArray[n5].m_dd = n9 + 1;
            stackElemArray[++n5].m_ll = n14;
            stackElemArray[n5].m_hh = n8;
            stackElemArray[n5].m_dd = n9;
            ++n5;
        }
    }

    private void randomiseBlock() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            this.m_inUse[n] = false;
        }
        for (n = 0; n <= this.m_last; ++n) {
            if (n2 == 0) {
                n2 = (char)RAND_NUMS[n3];
                if (++n3 == 512) {
                    n3 = 0;
                }
            }
            int n4 = n + 1;
            this.m_block[n4] = (char)(this.m_block[n4] ^ (--n2 == 1 ? (char)'\u0001' : '\u0000'));
            int n5 = n + 1;
            this.m_block[n5] = (char)(this.m_block[n5] & 0xFF);
            this.m_inUse[this.m_block[n + 1]] = true;
        }
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        short s;
        short s2;
        short s3;
        int n3;
        int n4;
        int n5;
        int n6;
        char[][] cArray = new char[6][258];
        int n7 = 0;
        int n8 = this.m_nInUse + 2;
        for (n6 = 0; n6 < 6; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                cArray[n6][n5] = 15;
            }
        }
        if (this.m_nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int n9 = this.m_nMTF < 200 ? 2 : (this.m_nMTF < 600 ? 3 : (this.m_nMTF < 1200 ? 4 : (this.m_nMTF < 2400 ? 5 : 6)));
        int n10 = n9;
        int n11 = this.m_nMTF;
        int n12 = 0;
        while (n10 > 0) {
            int n13 = n11 / n10;
            n4 = n12 - 1;
            for (n3 = 0; n3 < n13 && n4 < n8 - 1; n3 += this.m_mtfFreq[++n4]) {
            }
            if (n4 > n12 && n10 != n9 && n10 != 1 && (n9 - n10) % 2 == 1) {
                n3 -= this.m_mtfFreq[n4];
                --n4;
            }
            for (n5 = 0; n5 < n8; ++n5) {
                cArray[n10 - 1][n5] = n5 >= n12 && n5 <= n4 ? 0 : 15;
            }
            --n10;
            n12 = n4 + 1;
            n11 -= n3;
        }
        int[][] nArray = new int[6][258];
        int[] nArray2 = new int[6];
        short[] sArray = new short[6];
        for (int i = 0; i < 4; ++i) {
            for (n6 = 0; n6 < n9; ++n6) {
                nArray2[n6] = 0;
            }
            for (n6 = 0; n6 < n9; ++n6) {
                for (n5 = 0; n5 < n8; ++n5) {
                    nArray[n6][n5] = 0;
                }
            }
            n7 = 0;
            n12 = 0;
            while (n12 < this.m_nMTF) {
                n4 = n12 + 50 - 1;
                if (n4 >= this.m_nMTF) {
                    n4 = this.m_nMTF - 1;
                }
                for (n6 = 0; n6 < n9; ++n6) {
                    sArray[n6] = 0;
                }
                if (n9 == 6) {
                    n3 = 0;
                    s3 = 0;
                    s2 = 0;
                    s = 0;
                    short s4 = 0;
                    short s5 = 0;
                    for (n2 = n12; n2 <= n4; ++n2) {
                        short s6 = this.m_szptr[n2];
                        n3 = (short)(n3 + cArray[0][s6]);
                        s3 = (short)(s3 + cArray[1][s6]);
                        s2 = (short)(s2 + cArray[2][s6]);
                        s = (short)(s + cArray[3][s6]);
                        s4 = (short)(s4 + cArray[4][s6]);
                        s5 = (short)(s5 + cArray[5][s6]);
                    }
                    sArray[0] = n3;
                    sArray[1] = s3;
                    sArray[2] = s2;
                    sArray[3] = s;
                    sArray[4] = s4;
                    sArray[5] = s5;
                } else {
                    for (n2 = n12; n2 <= n4; ++n2) {
                        n3 = this.m_szptr[n2];
                        for (n6 = 0; n6 < n9; ++n6) {
                            int n13 = n6;
                            sArray[n13] = (short)(sArray[n13] + cArray[n6][n3]);
                        }
                    }
                }
                short s7 = 999999999;
                int n15 = -1;
                for (n6 = 0; n6 < n9; ++n6) {
                    if (sArray[n6] >= s7) continue;
                    s7 = sArray[n6];
                    n15 = n6;
                }
                int n14 = n15;
                nArray2[n14] = nArray2[n14] + 1;
                this.m_selector[n7] = (char)n15;
                ++n7;
                for (n2 = n12; n2 <= n4; ++n2) {
                    int[] nArray3 = nArray[n15];
                    short s4 = this.m_szptr[n2];
                    nArray3[s4] = nArray3[s4] + 1;
                }
                n12 = n4 + 1;
            }
            for (n6 = 0; n6 < n9; ++n6) {
                CBZip2OutputStream.hbMakeCodeLengths(cArray[n6], nArray[n6], n8, 20);
            }
        }
        nArray = null;
        nArray2 = null;
        sArray = null;
        if (n9 >= 8) {
            CBZip2OutputStream.panic();
        }
        if (n7 >= 32768 || n7 > 18002) {
            CBZip2OutputStream.panic();
        }
        Object object = new char[6];
        for (n2 = 0; n2 < n9; ++n2) {
            object[n2] = (char)n2;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            s3 = this.m_selector[n2];
            n = 0;
            s = object[n];
            while (s3 != s) {
                s2 = s;
                s = object[++n];
                object[n] = s2;
            }
            object[0] = s;
            this.m_selectorMtf[n2] = (char)n;
        }
        object = new int[6][258];
        for (n6 = 0; n6 < n9; ++n6) {
            char c = ' ';
            char c2 = '\u0000';
            for (n2 = 0; n2 < n8; ++n2) {
                if (cArray[n6][n2] > c2) {
                    c2 = cArray[n6][n2];
                }
                if (cArray[n6][n2] >= c) continue;
                c = cArray[n6][n2];
            }
            if (c2 > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (c < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes((int[])object[n6], cArray[n6], c, c2, n8);
        }
        boolean[] blArray = new boolean[16];
        for (n2 = 0; n2 < 16; ++n2) {
            blArray[n2] = false;
            for (n = 0; n < 16; ++n) {
                if (!this.m_inUse[n2 * 16 + n]) continue;
                blArray[n2] = true;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (blArray[n2]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 16; ++n) {
                if (this.m_inUse[n2 * 16 + n]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        this.bsW(3, n9);
        this.bsW(15, n7);
        for (n2 = 0; n2 < n7; ++n2) {
            for (n = 0; n < this.m_selectorMtf[n2]; ++n) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        for (n6 = 0; n6 < n9; ++n6) {
            int n17 = cArray[n6][0];
            this.bsW(5, n17);
            for (n2 = 0; n2 < n8; ++n2) {
                while (n17 < cArray[n6][n2]) {
                    this.bsW(2, 2);
                    ++n17;
                }
                while (n17 > cArray[n6][n2]) {
                    this.bsW(2, 3);
                    --n17;
                }
                this.bsW(1, 0);
            }
        }
        int n18 = 0;
        n12 = 0;
        while (n12 < this.m_nMTF) {
            n4 = n12 + 50 - 1;
            if (n4 >= this.m_nMTF) {
                n4 = this.m_nMTF - 1;
            }
            for (n2 = n12; n2 <= n4; ++n2) {
                this.bsW(cArray[this.m_selector[n18]][this.m_szptr[n2]], (int)object[this.m_selector[n18]][this.m_szptr[n2]]);
            }
            n12 = n4 + 1;
            ++n18;
        }
        if (n18 != n7) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (this.m_incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.m_incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.m_zptr[i];
                int n8 = i;
                while (this.fullGtU(this.m_zptr[n8 - n6] + n3, n7 + n3)) {
                    this.m_zptr[n8] = this.m_zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.m_zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.m_zptr[i];
                n8 = i;
                while (this.fullGtU(this.m_zptr[n8 - n6] + n3, n7 + n3)) {
                    this.m_zptr[n8] = this.m_zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.m_zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.m_zptr[i];
                n8 = i;
                while (this.fullGtU(this.m_zptr[n8 - n6] + n3, n7 + n3)) {
                    this.m_zptr[n8] = this.m_zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.m_zptr[n8] = n7;
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            n4 = this.m_zptr[n];
            this.m_zptr[n] = this.m_zptr[n2];
            this.m_zptr[n2] = n4;
            ++n;
            ++n2;
            --n3;
        }
    }

    private void writeRun() throws IOException {
        if (this.m_last < this.m_allowableBlockSize) {
            this.m_inUse[this.m_currentChar] = true;
            for (int i = 0; i < this.m_runLength; ++i) {
                this.m_crc.updateCRC((char)this.m_currentChar);
            }
            switch (this.m_runLength) {
                case 1: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 2: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 3: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                default: {
                    this.m_inUse[this.m_runLength - 4] = true;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)(this.m_runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    private static class StackElem {
        int m_dd;
        int m_hh;
        int m_ll;

        private StackElem() {
        }
    }
}

