/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.InvalidHeaderException;
import installer.TarBuffer;
import installer.TarEntry;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarInputStream
extends FilterInputStream {
    protected boolean debug;
    protected boolean hasHitEOF;
    protected int entrySize;
    protected int entryOffset;
    protected byte[] oneBuf;
    protected byte[] readBuf;
    protected TarBuffer buffer;
    protected TarEntry currEntry;
    protected EntryFactory eFactory;

    public TarInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.buffer = new TarBuffer(inputStream, n, n2);
        this.readBuf = null;
        this.oneBuf = new byte[1];
        this.debug = false;
        this.hasHitEOF = false;
        this.eFactory = null;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setEntryFactory(EntryFactory entryFactory) {
        this.eFactory = entryFactory;
    }

    public void setBufferDebug(boolean bl) {
        this.buffer.setDebug(bl);
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        return this.entrySize - this.entryOffset;
    }

    public void skip(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0 && (n2 = this.read(byArray, 0, i > byArray.length ? byArray.length : i)) != -1; i -= n2) {
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() {
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] byArray;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            int n = this.entrySize - this.entryOffset;
            if (this.debug) {
                System.err.println("TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + n + " bytes");
            }
            if (n > 0) {
                this.skip(n);
            }
            this.readBuf = null;
        }
        if ((byArray = this.buffer.readRecord()) == null) {
            if (this.debug) {
                System.err.println("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(byArray)) {
            if (this.debug) {
                System.err.println("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = this.eFactory == null ? new TarEntry(byArray) : this.eFactory.createEntry(byArray);
                if (byArray[257] != 117 || byArray[258] != 115 || byArray[259] != 116 || byArray[260] != 97 || byArray[261] != 114) {
                    throw new InvalidHeaderException("header magic is not 'ustar', but '" + byArray[257] + byArray[258] + byArray[259] + byArray[260] + byArray[261] + "', or (dec) " + byArray[257] + ", " + byArray[258] + ", " + byArray[259] + ", " + byArray[260] + ", " + byArray[261]);
                }
                if (this.debug) {
                    System.err.println("TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
                }
                this.entryOffset = 0;
                this.entrySize = (int)this.currEntry.getSize();
            }
            catch (InvalidHeaderException invalidHeaderException) {
                this.entrySize = 0;
                this.entryOffset = 0;
                this.currEntry = null;
                throw new InvalidHeaderException("bad header in block " + this.buffer.getCurrentBlockNum() + " record " + this.buffer.getCurrentRecordNum() + ", " + invalidHeaderException.getMessage());
            }
        }
        return this.currEntry;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.oneBuf, 0, 1);
        if (n == -1) {
            return n;
        }
        return this.oneBuf[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (n2 + this.entryOffset > this.entrySize) {
            n2 = this.entrySize - this.entryOffset;
        }
        if (this.readBuf != null) {
            int n5 = n2 > this.readBuf.length ? this.readBuf.length : n2;
            System.arraycopy(this.readBuf, 0, byArray, n, n5);
            if (n5 >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                n3 = this.readBuf.length - n5;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.readBuf, n5, byArray2, 0, n3);
                this.readBuf = byArray2;
            }
            n4 += n5;
            n2 -= n5;
            n += n5;
        }
        while (n2 > 0) {
            byte[] byArray3 = this.buffer.readRecord();
            if (byArray3 == null) {
                throw new IOException("unexpected EOF with " + n2 + " bytes unread");
            }
            int n6 = byArray3.length;
            n3 = n2;
            if (n6 > n3) {
                System.arraycopy(byArray3, 0, byArray, n, n3);
                this.readBuf = new byte[n6 - n3];
                System.arraycopy(byArray3, n3, this.readBuf, 0, n6 - n3);
            } else {
                n3 = n6;
                System.arraycopy(byArray3, 0, byArray, n, n6);
            }
            n4 += n3;
            n2 -= n3;
            n += n3;
        }
        this.entryOffset += n4;
        return n4;
    }

    public void copyEntryContents(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = this.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public class EntryAdapter
    implements EntryFactory {
        @Override
        public TarEntry createEntry(String string) {
            return new TarEntry(string);
        }

        @Override
        public TarEntry createEntry(File file) throws InvalidHeaderException {
            return new TarEntry(file);
        }

        @Override
        public TarEntry createEntry(byte[] byArray) throws InvalidHeaderException {
            return new TarEntry(byArray);
        }
    }

    public static interface EntryFactory {
        public TarEntry createEntry(String var1);

        public TarEntry createEntry(File var1) throws InvalidHeaderException;

        public TarEntry createEntry(byte[] var1) throws InvalidHeaderException;
    }
}

