/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SourceFormatter
implements CharStreamSource {
    private final Segment segment;
    private String indentString = "\t";
    private boolean tidyTags = false;
    private boolean collapseWhiteSpace = false;
    private boolean indentAllElements = false;
    private String newLine = null;

    public SourceFormatter(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        new Processor(this.segment, this.getIndentString(), this.getTidyTags(), this.getCollapseWhiteSpace(), this.getIndentAllElements(), this.getIndentAllElements(), this.getNewLine()).writeTo(writer);
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length() * 2;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public SourceFormatter setIndentString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("indentString property must not be null");
        }
        this.indentString = string;
        return this;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public SourceFormatter setTidyTags(boolean bl) {
        this.tidyTags = bl;
        return this;
    }

    public boolean getTidyTags() {
        return this.tidyTags;
    }

    public SourceFormatter setCollapseWhiteSpace(boolean bl) {
        this.collapseWhiteSpace = bl;
        return this;
    }

    public boolean getCollapseWhiteSpace() {
        return this.collapseWhiteSpace;
    }

    public SourceFormatter setIndentAllElements(boolean bl) {
        this.indentAllElements = bl;
        return this;
    }

    public boolean getIndentAllElements() {
        return this.indentAllElements;
    }

    public SourceFormatter setNewLine(String string) {
        this.newLine = string;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.segment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    private static final class Processor {
        private final Segment segment;
        private final CharSequence sourceText;
        private final String indentString;
        private final boolean tidyTags;
        private final boolean collapseWhiteSpace;
        private final boolean indentAllElements;
        private final boolean indentScriptElements;
        private final String newLine;
        private Writer writer;
        private Tag nextTag;
        private int index;

        public Processor(Segment segment, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
            this.segment = segment;
            this.sourceText = segment.source.toString();
            this.indentString = string;
            this.tidyTags = bl;
            this.collapseWhiteSpace = bl2;
            this.indentAllElements = bl3;
            this.indentScriptElements = bl4;
            this.newLine = string2;
        }

        public void writeTo(Writer writer) throws IOException {
            this.writer = writer;
            this.nextTag = this.segment.source.findNextTag(this.segment.begin);
            this.index = this.segment.begin;
            this.writeContent(this.segment.end, this.segment.getChildElements(), 0);
            writer.flush();
        }

        private void writeContent(int n, List list, int n2) throws IOException {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                int n3 = element.begin;
                if (n3 >= n) break;
                if (this.indentAllElements) {
                    this.writeText(n3, n2, false, false, false, this.collapseWhiteSpace);
                    this.writeElement(element, n2, n, false, false);
                    continue;
                }
                String string = element.getName();
                if (!this.indent(element)) continue;
                this.writeText(n3, n2, false, false, false, this.collapseWhiteSpace);
                if (string == "pre" || string == "textarea") {
                    this.writeElement(element, n2, n, true, true);
                    continue;
                }
                if (string == "script") {
                    this.writeElement(element, n2, n, true, false);
                    continue;
                }
                this.writeElement(element, n2, n, false, !this.containsNonInlineLevelChildElements(element));
            }
            this.writeText(n, n2, false, false, false, this.collapseWhiteSpace);
        }

        private boolean indent(Element element) {
            StartTagType startTagType = element.getStartTag().getStartTagType();
            if (startTagType == StartTagType.DOCTYPE_DECLARATION) {
                return true;
            }
            if (startTagType != StartTagType.NORMAL) {
                return false;
            }
            String string = element.getName();
            if (string == "script") {
                return this.indentScriptElements;
            }
            if (!HTMLElements.getInlineLevelElementNames().contains(string)) {
                return true;
            }
            return this.containsNonInlineLevelChildElements(element);
        }

        private void writeText(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            if (this.index == n) {
                return;
            }
            while (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                if (++this.index != n) continue;
                return;
            }
            if (!bl) {
                this.writeIndent(n2);
            }
            this.writeTextInline(n, n2, bl3, bl4);
            if (!bl2) {
                this.writer.write(this.newLine);
            }
        }

        private void writeElement(Element element, int n, int n2, boolean bl, boolean bl2) throws IOException {
            int n3;
            StartTag startTag = element.getStartTag();
            EndTag endTag = element.getEndTag();
            this.writeIndent(n);
            this.writeTag(startTag, n, n2);
            if (this.index == n2) {
                this.writer.write(this.newLine);
                return;
            }
            if (!bl2) {
                this.writer.write(this.newLine);
            }
            if (n2 < (n3 = element.getContentEnd())) {
                n3 = n2;
            }
            if (this.index < n3) {
                if (bl) {
                    if (bl2) {
                        this.writeContentPreformatted(n3, n);
                    } else {
                        this.writeIndentedScriptContent(n3, n + 1);
                    }
                } else if (bl2) {
                    if (this.collapseWhiteSpace) {
                        this.writeTextCollapseWhiteSpace(n3, n);
                    } else if (!this.writeTextInline(n3, n, true, false)) {
                        this.writer.write(this.newLine);
                        bl2 = false;
                    }
                } else {
                    this.writeContent(n3, element.getChildElements(), n + 1);
                }
            }
            if (endTag != null && n2 > endTag.begin) {
                if (!bl2) {
                    this.writeIndent(n);
                }
                this.writeTag(endTag, n, n2);
                this.writer.write(this.newLine);
            } else if (bl2) {
                this.writer.write(this.newLine);
            }
        }

        private void updateNextTag() {
            while (this.nextTag != null) {
                if (this.nextTag.begin >= this.index) {
                    return;
                }
                this.nextTag = this.nextTag.findNextTag();
            }
        }

        private void writeIndentedScriptContent(int n, int n2) throws IOException {
            int n3 = this.getStartOfLinePos(n, false);
            if (this.index == n) {
                return;
            }
            if (n3 == -1) {
                this.writeIndent(n2);
                this.writeLineKeepWhiteSpace(n, n2);
                this.writer.write(this.newLine);
                if (this.index == n) {
                    return;
                }
                n3 = this.getStartOfLinePos(n, true);
                if (this.index == n) {
                    return;
                }
            }
            this.writeTextPreserveIndentation(n, n2, this.index - n3);
            this.writer.write(this.newLine);
        }

        private boolean writeTextPreserveIndentation(int n, int n2) throws IOException {
            this.writeLineKeepWhiteSpace(n, n2);
            if (this.index == n) {
                return true;
            }
            int n3 = this.getStartOfLinePos(n, true);
            if (this.index == n) {
                return true;
            }
            this.writer.write(this.newLine);
            this.writeTextPreserveIndentation(n, n2 + 1, this.index - n3);
            return false;
        }

        private void writeTextPreserveIndentation(int n, int n2, int n3) throws IOException {
            this.writeIndent(n2);
            this.writeLineKeepWhiteSpace(n, n2);
            while (this.index != n) {
                char c;
                for (int i = 0; i < n3 && ((c = this.sourceText.charAt(this.index)) == ' ' || c == '\t'); ++i) {
                    if (++this.index != n) continue;
                    return;
                }
                this.writer.write(this.newLine);
                this.writeIndent(n2);
                this.writeLineKeepWhiteSpace(n, n2);
            }
        }

        private int getStartOfLinePos(int n, boolean bl) {
            int n2;
            int n3 = n2 = bl ? this.index : -1;
            do {
                char c;
                if ((c = this.sourceText.charAt(this.index)) == '\n' || c == '\r') {
                    n2 = this.index + 1;
                    continue;
                }
                if (c != ' ' && c != '\t') break;
            } while (++this.index != n);
            return n2;
        }

        private void writeSpecifiedTextInline(CharSequence charSequence, int n) throws IOException {
            int n2 = charSequence.length();
            int n3 = this.writeSpecifiedLine(charSequence, 0);
            if (n3 < n2) {
                int n4 = n + 1;
                while (true) {
                    if (Segment.isWhiteSpace(charSequence.charAt(n3))) {
                        if (++n3 < n2) continue;
                        return;
                    }
                    this.writer.write(this.newLine);
                    this.writeIndent(n4);
                    if ((n3 = this.writeSpecifiedLine(charSequence, n3)) >= n2) break;
                }
            }
        }

        private int writeSpecifiedLine(CharSequence charSequence, int n) throws IOException {
            int n2 = charSequence.length();
            do {
                int n3;
                char c;
                if ((c = charSequence.charAt(n)) == '\r' && (n3 = n + 1) < n2 && charSequence.charAt(n3) == '\n') {
                    return n + 2;
                }
                if (c == '\n') {
                    return n + 1;
                }
                this.writer.write(c);
            } while (++n < n2);
            return n;
        }

        private boolean writeTextInline(int n, int n2, boolean bl, boolean bl2) throws IOException {
            int n3;
            this.writeLine(n, n2, bl2);
            if (this.index == n) {
                return true;
            }
            int n4 = n3 = bl ? n2 + 1 : n2;
            while (true) {
                if (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                    if (++this.index != n) continue;
                    return false;
                }
                this.writer.write(this.newLine);
                this.writeIndent(n3);
                this.writeLine(n, n3, bl2);
                if (this.index >= n) break;
            }
            return false;
        }

        private void writeLine(int n, int n2, boolean bl) throws IOException {
            if (bl) {
                this.writeTextCollapseWhiteSpace(n, n2);
            } else {
                this.writeLineKeepWhiteSpace(n, n2);
            }
        }

        private void writeLineKeepWhiteSpace(int n, int n2) throws IOException {
            this.updateNextTag();
            while (true) {
                int n3;
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.writeTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                char c = this.sourceText.charAt(this.index);
                if (c == '\r' && (n3 = this.index + 1) < n && this.sourceText.charAt(n3) == '\n') {
                    this.index += 2;
                    return;
                }
                if (c == '\n') {
                    ++this.index;
                    return;
                }
                this.writer.write(c);
                if (++this.index == n) break;
            }
        }

        private void writeTextCollapseWhiteSpace(int n, int n2) throws IOException {
            boolean bl = false;
            this.updateNextTag();
            while (this.index < n) {
                char c;
                while (this.nextTag != null && this.index == this.nextTag.begin) {
                    if (bl) {
                        this.writer.write(32);
                        bl = false;
                    }
                    this.writeTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                if (Segment.isWhiteSpace(c = this.sourceText.charAt(this.index++))) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    this.writer.write(32);
                    bl = false;
                }
                this.writer.write(c);
            }
            if (bl) {
                this.writer.write(32);
            }
        }

        private void writeContentPreformatted(int n, int n2) throws IOException {
            this.updateNextTag();
            while (true) {
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.writeTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                this.writer.write(this.sourceText.charAt(this.index));
                if (++this.index >= n) break;
            }
        }

        private void writeTag(Tag tag, int n, int n2) throws IOException {
            CharSequence charSequence;
            int n3;
            this.nextTag = tag.findNextTag();
            int n4 = n3 = n2 > tag.end ? tag.end : n2;
            if (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.CDATA_SECTION) {
                this.writeTextPreserveIndentation(n3, n);
            } else if (this.tidyTags) {
                charSequence = tag.tidy();
                if (tag instanceof StartTag && ((StartTag)tag).getAttributes() != null) {
                    this.writer.write((String)charSequence);
                } else {
                    this.writeSpecifiedTextInline(charSequence, n);
                }
                this.index = n3;
            } else {
                this.writeTextInline(n3, n, true, false);
            }
            if (n2 <= tag.end || !(tag instanceof StartTag)) {
                return;
            }
            if (tag.name == "script" && !this.indentScriptElements || tag.getTagType().isServerTag()) {
                boolean bl;
                charSequence = tag.getElement();
                EndTag endTag = ((Element)charSequence).getEndTag();
                if (endTag == null) {
                    return;
                }
                int n5 = n2 < endTag.begin ? n2 : endTag.begin;
                boolean bl2 = bl = this.index == n5 ? true : this.writeTextPreserveIndentation(n5, n);
                if (endTag.begin >= n2) {
                    return;
                }
                if (!bl) {
                    this.writer.write(this.newLine);
                    this.writeIndent(n);
                }
                this.writeTag(endTag, n, n2);
            }
        }

        private void writeIndent(int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                this.writer.write(this.indentString);
            }
        }

        private boolean containsNonInlineLevelChildElements(Element element) {
            List list = element.getChildElements();
            if (list == Collections.EMPTY_LIST) {
                return false;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string = element2.getName();
                if (string == "script" || !HTMLElements.getInlineLevelElementNames().contains(string)) {
                    return true;
                }
                if (!this.containsNonInlineLevelChildElements(element2)) continue;
                return true;
            }
            return false;
        }
    }
}

