/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.w3c.dom.Node;

public final class MathRenderer {
    private static final int COLOR_ENTRIES = 3;
    private static final int BITS_PER_PIXEL = 24;
    private static final PaletteData PALETTE_BGR = new PaletteData(255, 65280, 0xFF0000);
    private static final Log LOGGER = LogFactory.getLog(MathRenderer.class);
    private final Converter converter = Converter.getInstance();

    private MathRenderer() {
    }

    public static MathRenderer getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ImageData render(Node node, LayoutContext layoutContext) {
        ImageData imageData;
        if (node == null) {
            imageData = null;
        } else {
            try {
                BufferedImage bufferedImage = this.converter.render(node, layoutContext, 5);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray = dataBufferByte.getData();
                int n = bufferedImage.getWidth();
                imageData = new ImageData(n, bufferedImage.getHeight(), 24, PALETTE_BGR, 3 * n, byArray);
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)iOException.getMessage(), (Throwable)iOException);
                imageData = null;
            }
        }
        return imageData;
    }

    private static final class SingletonHolder {
        private static final MathRenderer INSTANCE = new MathRenderer();

        private SingletonHolder() {
        }
    }
}

