/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swt;

import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.swt.MathRenderer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Node;

public final class MathView
extends Canvas {
    private final MathRenderer mathRenderer = MathRenderer.getInstance();
    private Node document;
    private ImageData renderedFormula;
    private MutableLayoutContext layoutContext = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());

    public MathView(Composite composite, int n) {
        super(composite, n);
        this.setDocument((Node)new DocumentElement());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MathView.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                MathView.this.paintControl(paintEvent);
            }
        });
    }

    private void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Device device = gC.getDevice();
        Color color = new Color(device, 255, 255, 255);
        gC.setBackground(color);
        gC.fillRectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        color.dispose();
        if (this.renderedFormula != null) {
            Image image = new Image(device, this.renderedFormula);
            gC.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    private void widgetDisposed(DisposeEvent disposeEvent) {
        this.document = null;
        this.renderedFormula = null;
    }

    private void recreate() {
        this.renderedFormula = this.mathRenderer.render(this.document, (LayoutContext)this.layoutContext);
    }

    public void setDocument(Node node) {
        Node node2 = this.document;
        this.document = node;
        if (node != node2) {
            this.recreate();
            this.redraw();
        }
    }

    public Node getDocument() {
        return this.document;
    }
}

