/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jeuclid.app.mathviewer.Messages;
import net.sourceforge.jeuclid.font.FontFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSelectionDialog
extends JDialog {
    private static final int SAMPLE_FONTSIZE = 14;
    private static final long serialVersionUID = 1L;
    private static final String PREVIEW_TEXT = "The quick brown fox jumps over the lazy dog. 123456790";
    private final List<String> fontNames = new ArrayList<String>();
    private JList list;

    public FontSelectionDialog(Dialog dialog, List<String> list) {
        super(dialog);
        this.init(list);
    }

    public FontSelectionDialog(Frame frame, List<String> list) {
        super(frame);
        this.init(list);
    }

    private void init(List<String> list) {
        this.setTitle(Messages.getString("MathViewer.FontSelectionDialog.title"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)new JLabel(Messages.getString("MathViewer.FontSelectionDialog.topLabel")), "North");
        this.setupFontsList(list);
        this.setupButtons();
        this.pack();
        this.setLocationByPlatform(true);
        this.setModal(true);
    }

    public List<String> getFontNames() {
        return this.fontNames;
    }

    private void setupFontsList(List<String> list) {
        Object object;
        Vector<String> vector = new Vector<String>(FontFactory.getInstance().listFontNames());
        Collections.sort(vector);
        this.list = new JList<String>(vector);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                int n = Collections.binarySearch(vector, string);
                if (n <= -1) continue;
                arrayList.add(n);
            }
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        this.list.setSelectedIndices((int[])object);
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 31);
        final JTextArea jTextArea = new JTextArea(PREVIEW_TEXT);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jTextArea.setFont(FontFactory.getInstance().getFont((String)FontSelectionDialog.this.list.getSelectedValue(), 0, 14.0f));
                jTextArea.revalidate();
            }
        });
        this.getContentPane().add((Component)jScrollPane, "West");
        this.getContentPane().add((Component)jTextArea, "Center");
    }

    private void setupButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        final JButton jButton = new JButton(Messages.getString("MathViewer.ok"));
        jButton.setMnemonic('O');
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    for (Object object : FontSelectionDialog.this.list.getSelectedValues()) {
                        FontSelectionDialog.this.fontNames.add((String)object);
                    }
                }
                FontSelectionDialog.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("MathViewer.cancel"));
        jButton2.setMnemonic('C');
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
    }
}

