/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.foprep;

import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.converter.Processor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Main {
    private static final String STD_INOUT = "-";
    private static final String OPTION_OUT = "out";
    private static final String OPTION_IN = "in";

    private Main() {
    }

    public static void main(String[] stringArray) {
        Options options = new Options();
        Option option = new Option(OPTION_IN, true, "input (fo) file");
        option.setRequired(true);
        options.addOption(option);
        Option option2 = new Option(OPTION_OUT, true, "output (fo) file");
        option2.setRequired(true);
        options.addOption(option2);
        GnuParser gnuParser = new GnuParser();
        try {
            CommandLine commandLine = gnuParser.parse(options, stringArray);
            String string = commandLine.getOptionValue(OPTION_IN);
            String string2 = commandLine.getOptionValue(OPTION_OUT);
            StreamResult streamResult = STD_INOUT.equals(string2) ? new StreamResult(new PrintWriter(System.out)) : new StreamResult(string2);
            StreamSource streamSource = STD_INOUT.equals(string) ? new StreamSource(System.in) : new StreamSource(string);
            Processor.getInstance().process(streamSource, streamResult);
        }
        catch (ParseException parseException) {
            System.out.println("Invalid command line:" + parseException.getMessage());
            new HelpFormatter().printHelp("foprep -in input.fo -out output.fo", options);
        }
        catch (TransformerException transformerException) {
            System.out.println("An error occurred during processing: " + transformerException.getMessage());
            transformerException.printStackTrace();
        }
    }
}

