/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.app.mathviewer.Messages;

public final class AboutDialog
extends JDialog {
    private static final int LARGE_FONT = 14;
    private static final int SMALL_FONT = 12;
    private static final String ABOUT_FONT = "SansSerif";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane;
    private JLabel iconLabel;
    private JLabel jeuclidLabel;
    private JLabel wwwLabel;

    public AboutDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("MathViewer.aboutWindowTitle"));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 86 && keyEvent.isAltDown()) {
                    JOptionPane.showMessageDialog(AboutDialog.this, "Version: " + LayoutContext.class.getPackage().getImplementationVersion());
                }
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.wwwLabel = new JLabel();
            this.wwwLabel.setText(" http://jeuclid.sourceforge.net ");
            this.wwwLabel.setFont(new Font(ABOUT_FONT, 0, 12));
            this.wwwLabel.setHorizontalAlignment(0);
            this.jeuclidLabel = new JLabel();
            this.jeuclidLabel.setText("JEuclid MathViewer");
            this.jeuclidLabel.setHorizontalAlignment(0);
            this.jeuclidLabel.setFont(new Font(ABOUT_FONT, 1, 14));
            this.iconLabel = new JLabel();
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/jeuclid_128x128.png")));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.iconLabel, "North");
            this.jContentPane.add((Component)this.jeuclidLabel, "Center");
            this.jContentPane.add((Component)this.wwwLabel, "South");
        }
        return this.jContentPane;
    }
}

