/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.app.mathviewer.MathViewer;
import net.sourceforge.jeuclid.app.mathviewer.Messages;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class FileIO {
    private static final Log LOGGER = LogFactory.getLog(FileIO.class);
    private static final String EXPORT_ERROR = "MathViewer.exportError";
    private File lastPath;

    private FileIO() {
    }

    public static FileIO getInstance() {
        return SingletonHolder.instance;
    }

    private static String getExtension(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public File selectFileToOpen(Frame frame) {
        File file;
        if (MathViewer.OSX) {
            FileDialog fileDialog = new FileDialog(frame, "Please select a MathML file");
            if (this.lastPath != null) {
                fileDialog.setDirectory(this.lastPath.toString());
            }
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            file = string != null ? new File(fileDialog.getDirectory(), string) : null;
        } else {
            JFileChooser jFileChooser = new JFileChooser(this.lastPath);
            int n = jFileChooser.showOpenDialog(frame);
            file = n == 0 ? jFileChooser.getSelectedFile() : null;
        }
        if (file != null) {
            this.lastPath = file.getParentFile();
        }
        return file;
    }

    public Document loadFile(Frame frame, File file) {
        Document document;
        if (file == null) {
            document = null;
        } else {
            try {
                document = MathMLParserSupport.parseFile(file);
            }
            catch (SAXException sAXException) {
                document = null;
                LOGGER.warn(sAXException.getMessage(), sAXException);
                JOptionPane.showMessageDialog(frame, sAXException.getMessage(), Messages.getString("MathViewer.errorParsing"), 0);
            }
            catch (IOException iOException) {
                document = null;
                LOGGER.warn(iOException.getMessage(), iOException);
                JOptionPane.showMessageDialog(frame, iOException.getMessage(), Messages.getString("MathViewer.errorAccessing"), 0);
            }
        }
        return document;
    }

    public void saveDocument(Frame frame, Node node, MutableLayoutContext mutableLayoutContext) {
        File file;
        Container container;
        if (MathViewer.OSX) {
            container = new FileDialog(frame, "Export to...", 1);
            if (this.lastPath != null) {
                ((FileDialog)container).setDirectory(this.lastPath.toString());
            }
            ((FileDialog)container).setFilenameFilter(new SaveExportFilter());
            ((Dialog)container).setVisible(true);
            String string = ((FileDialog)container).getFile();
            file = string != null ? new File(((FileDialog)container).getDirectory(), string) : null;
        } else {
            container = new JFileChooser(this.lastPath);
            int n = ((JFileChooser)container).showSaveDialog(frame);
            file = n == 0 ? ((JFileChooser)container).getSelectedFile() : null;
        }
        if (file != null) {
            this.lastPath = file.getParentFile();
            LOGGER.info(file);
            int n = 0;
            if (file.exists()) {
                n = JOptionPane.showConfirmDialog(frame, "File " + file.getName() + " already exists. Overwrite?", "Confirm Overwrite", 0);
            }
            if (n == 0) {
                this.exportAs(frame, file, node, mutableLayoutContext);
            }
        }
    }

    private void exportAs(Frame frame, File file, Node node, MutableLayoutContext mutableLayoutContext) {
        String string = file.getName();
        String string2 = FileIO.getExtension(string);
        String string3 = ConverterRegistry.getInstance().getMimeTypeForSuffix(string2);
        if (string3 != null) {
            try {
                if (Converter.getInstance().convert(node, file, string3, (LayoutContext)mutableLayoutContext) == null) {
                    JOptionPane.showMessageDialog(frame, "Failed to write to " + string, Messages.getString(EXPORT_ERROR), 0);
                }
            }
            catch (IOException iOException) {
                LOGGER.warn(iOException);
                JOptionPane.showMessageDialog(frame, iOException.getMessage(), Messages.getString(EXPORT_ERROR), 0);
            }
        } else {
            JOptionPane.showMessageDialog(frame, "Unsupported file extension " + string2, Messages.getString(EXPORT_ERROR), 0);
        }
    }

    private static class SaveExportFilter
    implements FilenameFilter {
        private final Set<String> extensions = ConverterRegistry.getInstance().getAvailableExtensions();

        protected SaveExportFilter() {
        }

        public boolean accept(File file, String string) {
            return this.extensions.contains(FileIO.getExtension(string));
        }
    }

    private static final class SingletonHolder {
        private static FileIO instance = new FileIO();

        private SingletonHolder() {
        }
    }
}

