/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.codegen;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.Graph;
import EDU.purdue.cs.bloat.util.GraphNode;
import EDU.purdue.cs.bloat.util.ImmutableIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Liveness {
    public static boolean DEBUG = false;
    public static boolean UNIQUE = false;
    public static final boolean BEFORE = false;
    public static final boolean AFTER = true;
    FlowGraph cfg;
    Graph ig;

    public Liveness(FlowGraph cfg) {
        this.cfg = cfg;
        this.computeIntersections();
    }

    public void removeVar(LocalExpr expr) {
        this.ig.removeNode(expr);
    }

    public boolean liveAtUse(VarExpr isLive, VarExpr at, boolean after) {
        throw new RuntimeException();
    }

    public boolean liveAtStartOfBlock(VarExpr isLive, Block block) {
        throw new RuntimeException();
    }

    public boolean liveAtEndOfBlock(VarExpr isLive, Block block) {
        throw new RuntimeException();
    }

    public Collection defs() {
        return this.ig.keySet();
    }

    public Iterator intersections(VarExpr a) {
        Assert.isTrue(a != null, "Cannot get intersections for null def");
        Assert.isTrue(a.isDef(), "Cannot get intersections for variable uses");
        GraphNode node = this.ig.getNode(a);
        Assert.isTrue(node != null, "Cannot find IG node for " + a);
        return new Iterator(node){
            Iterator succs;
            {
                this.succs = Liveness.this.ig.succs(graphNode).iterator();
            }

            public boolean hasNext() {
                return this.succs.hasNext();
            }

            public Object next() {
                IGNode next = (IGNode)this.succs.next();
                return next.def;
            }

            public void remove() {
                throw new RuntimeException();
            }
        };
    }

    public boolean liveRangesIntersect(VarExpr a, VarExpr b) {
        Assert.isTrue(a != null && b != null, "Cannot get intersections for null def");
        Assert.isTrue(a.isDef() && b.isDef(), "Cannot get intersections for variable uses");
        if (a == b) {
            return false;
        }
        if (UNIQUE) {
            return true;
        }
        IGNode na = (IGNode)this.ig.getNode(a);
        IGNode nb = (IGNode)this.ig.getNode(b);
        Assert.isTrue(na != null && nb != null);
        return this.ig.hasEdge(na, nb);
    }

    private void computeIntersections() {
        int blockIndex;
        Block block;
        this.ig = new Graph();
        if (DEBUG) {
            System.out.println("-----------Computing live ranges-----------");
        }
        final ArrayList defNodes = new ArrayList();
        final ArrayList phiCatchNodes = new ArrayList();
        final List[] nodes = new ArrayList[this.cfg.size()];
        final Map[] nodeIndices = new HashMap[this.cfg.size()];
        Iterator iter = this.cfg.nodes().iterator();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            blockIndex = this.cfg.preOrderIndex(block);
            nodes[blockIndex] = new ArrayList();
            nodeIndices[blockIndex] = new HashMap();
        }
        iter = this.cfg.trace().iterator();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            block.visit(new TreeVisitor(1){

                public void visitPhiJoinStmt(PhiJoinStmt stmt) {
                    if (!(stmt.target() instanceof LocalExpr)) {
                        return;
                    }
                    LocalExpr target = (LocalExpr)stmt.target();
                    Iterator preds = Liveness.this.cfg.preds(block).iterator();
                    while (preds.hasNext()) {
                        Block pred = (Block)preds.next();
                        int predIndex = Liveness.this.cfg.preOrderIndex(pred);
                        List n = nodes[predIndex];
                        Map indices = nodeIndices[predIndex];
                        indices.put(stmt, new Integer(n.size()));
                        NodeInfo info = new NodeInfo(stmt);
                        n.add(info);
                        IGNode node = (IGNode)Liveness.this.ig.getNode(target);
                        if (node == null) {
                            node = new IGNode(target);
                            Liveness.this.ig.addNode(target, node);
                            defNodes.add(node);
                        }
                        info.defNodes.add(node);
                    }
                }

                public void visitPhiCatchStmt(PhiCatchStmt stmt) {
                }

                public void visitStmt(Stmt stmt) {
                }
            });
        }
        iter = this.cfg.trace().iterator();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            blockIndex = this.cfg.preOrderIndex(block);
            block.visit(new TreeVisitor(1){
                Node parent = null;

                public void visitNode(Node node) {
                    Node p = this.parent;
                    this.parent = node;
                    node.visitChildren(this);
                    this.parent = p;
                }

                public void visitLocalExpr(LocalExpr expr) {
                    NodeInfo info;
                    Assert.isTrue(this.parent != null);
                    List n = nodes[blockIndex];
                    Map indices = nodeIndices[blockIndex];
                    Integer i = (Integer)indices.get(this.parent);
                    if (i == null) {
                        if (DEBUG) {
                            System.out.println("adding " + this.parent + " at " + n.size());
                        }
                        indices.put(this.parent, new Integer(n.size()));
                        info = new NodeInfo(this.parent);
                        n.add(info);
                    } else {
                        if (DEBUG) {
                            System.out.println("found " + this.parent + " at " + i);
                        }
                        Assert.isTrue((info = (NodeInfo)n.get(i)) != null);
                    }
                    if (expr.isDef()) {
                        IGNode node = (IGNode)Liveness.this.ig.getNode(expr);
                        if (node == null) {
                            node = new IGNode(expr);
                            Liveness.this.ig.addNode(expr, node);
                            defNodes.add(node);
                        }
                        info.defNodes.add(node);
                    }
                }

                public void visitPhiCatchStmt(PhiCatchStmt stmt) {
                    NodeInfo info;
                    List n = nodes[blockIndex];
                    Map indices = nodeIndices[blockIndex];
                    Integer i = (Integer)indices.get(stmt);
                    if (i == null) {
                        if (DEBUG) {
                            System.out.println("adding " + stmt + " at " + n.size());
                        }
                        indices.put(stmt, new Integer(n.size()));
                        info = new NodeInfo(stmt);
                        n.add(info);
                    } else {
                        if (DEBUG) {
                            System.out.println("found " + this.parent + " at " + i);
                        }
                        Assert.isTrue((info = (NodeInfo)n.get(i)) != null);
                    }
                    LocalExpr target = (LocalExpr)stmt.target();
                    IGNode node = (IGNode)Liveness.this.ig.getNode(target);
                    if (node == null) {
                        node = new IGNode(target);
                        Liveness.this.ig.addNode(target, node);
                        defNodes.add(node);
                        phiCatchNodes.add(node);
                    }
                    info.defNodes.add(node);
                }

                public void visitPhiJoinStmt(PhiJoinStmt stmt) {
                }
            });
        }
        int numDefs = defNodes.size();
        int i = 0;
        while (i < numDefs) {
            IGNode node = (IGNode)defNodes.get(i);
            LocalExpr def = node.def;
            BitSet m = new BitSet(this.cfg.size());
            Iterator uses = def.uses().iterator();
            block4: while (uses.hasNext()) {
                LocalExpr use = (LocalExpr)uses.next();
                Node parent = use.parent();
                if (parent instanceof MemRefExpr && ((MemRefExpr)parent).isDef()) {
                    parent = parent.parent();
                }
                if (parent instanceof PhiCatchStmt) continue;
                if (DEBUG) {
                    System.out.println("searching for " + def + " from " + parent);
                }
                Block block2 = parent.block();
                if (parent instanceof PhiJoinStmt) {
                    PhiJoinStmt phi = (PhiJoinStmt)parent;
                    Iterator preds = this.cfg.preds(block2).iterator();
                    while (preds.hasNext()) {
                        Block pred = (Block)preds.next();
                        if (phi.operandAt(pred) != use) continue;
                        Map indices = nodeIndices[this.cfg.preOrderIndex(pred)];
                        Integer index = (Integer)indices.get(parent);
                        Assert.isTrue(index != null, "No index for " + parent);
                        this.liveOut(m, nodes, pred, index, node, phiCatchNodes);
                        continue block4;
                    }
                    continue;
                }
                Map indices = nodeIndices[this.cfg.preOrderIndex(block2)];
                Integer index = (Integer)indices.get(parent);
                Assert.isTrue(index != null, "No index for " + parent);
                this.liveOut(m, nodes, block2, index, node, phiCatchNodes);
            }
            ++i;
        }
        int numPhiCatches = phiCatchNodes.size();
        int i2 = 0;
        while (i2 < numPhiCatches) {
            IGNode node = (IGNode)phiCatchNodes.get(i2);
            PhiCatchStmt phi = (PhiCatchStmt)node.def.parent();
            Iterator operands = phi.operands().iterator();
            while (operands.hasNext()) {
                LocalExpr operand = (LocalExpr)operands.next();
                LocalExpr def = (LocalExpr)operand.def();
                if (def == null) continue;
                IGNode opNode = (IGNode)this.ig.getNode(def);
                ImmutableIterator edges = new ImmutableIterator(this.ig.succs(opNode));
                while (edges.hasNext()) {
                    IGNode otherNode = (IGNode)edges.next();
                    if (otherNode == node) continue;
                    if (DEBUG) {
                        System.out.println(otherNode.def + " conflicts with " + opNode.def + " and thus with " + node.def);
                    }
                    this.ig.addEdge(otherNode, node);
                    this.ig.addEdge(node, otherNode);
                }
            }
            ++i2;
        }
        if (DEBUG) {
            System.out.println("Interference graph =");
            System.out.println(this.ig);
        }
    }

    void liveOut(BitSet m, List[] nodes, Block block, int nodeIndex, IGNode defNode, Collection phiCatchNodes) {
        boolean firstNode = true;
        int blockIndex = this.cfg.preOrderIndex(block);
        ArrayList<Pos> stack = new ArrayList<Pos>();
        Pos pos = new Pos();
        pos.block = block;
        pos.blockIndex = blockIndex;
        pos.nodeIndex = nodeIndex;
        stack.add(pos);
        while (!stack.isEmpty()) {
            pos = (Pos)stack.remove(stack.size() - 1);
            block = pos.block;
            blockIndex = pos.blockIndex;
            nodeIndex = pos.nodeIndex;
            if (DEBUG) {
                System.out.println(defNode.def + " is live at position " + nodeIndex + " of " + block);
            }
            boolean stop = false;
            ListIterator iter = nodes[blockIndex].listIterator(nodeIndex);
            while (!stop && iter.hasNext()) {
                NodeInfo info = (NodeInfo)iter.next();
                if (DEBUG) {
                    System.out.println(defNode.def + " is live at " + info.node);
                }
                if (firstNode) {
                    firstNode = false;
                    continue;
                }
                Iterator e = info.defNodes.iterator();
                while (e.hasNext()) {
                    IGNode node = (IGNode)e.next();
                    Iterator catchPhis = phiCatchNodes.iterator();
                    block3: while (catchPhis.hasNext()) {
                        IGNode catchNode = (IGNode)catchPhis.next();
                        PhiCatchStmt phi = (PhiCatchStmt)catchNode.def.parent();
                        Handler handler = (Handler)this.cfg.handlersMap().get(phi.block());
                        Assert.isTrue(handler != null, "Null handler for " + phi.block());
                        if (!handler.protectedBlocks().contains(block)) continue;
                        Iterator operands = phi.operands().iterator();
                        while (operands.hasNext()) {
                            LocalExpr expr = (LocalExpr)operands.next();
                            if (expr.def() == node.def) continue block3;
                        }
                        if (DEBUG) {
                            System.out.println(defNode.def + " conflicts with " + node.def);
                        }
                        this.ig.addEdge(node, catchNode);
                        this.ig.addEdge(catchNode, node);
                    }
                    if (node != defNode) {
                        if (DEBUG) {
                            System.out.println(defNode.def + " conflicts with " + node.def);
                        }
                        this.ig.addEdge(node, defNode);
                        this.ig.addEdge(defNode, node);
                        continue;
                    }
                    if (DEBUG) {
                        System.out.println("def found stopping search");
                    }
                    stop = true;
                }
            }
            if (stop) continue;
            Iterator preds = this.cfg.preds(block).iterator();
            while (preds.hasNext()) {
                Block pred = (Block)preds.next();
                int predIndex = this.cfg.preOrderIndex(pred);
                if (DEBUG) {
                    System.out.println(defNode.def + " is live at end of " + pred);
                }
                if (m.get(predIndex)) continue;
                pos = new Pos();
                pos.block = pred;
                pos.blockIndex = predIndex;
                pos.nodeIndex = 0;
                m.set(predIndex);
                stack.add(pos);
            }
        }
    }

    class IGNode
    extends GraphNode {
        LocalExpr def;

        public IGNode(LocalExpr def) {
            this.def = def;
        }

        public String toString() {
            return this.def.toString();
        }
    }

    class Key {
        int blockIndex;
        Node node;

        public Key(Node node, int blockIndex) {
            this.blockIndex = blockIndex;
            this.node = node;
        }

        public int hashCode() {
            return this.node.hashCode() ^ this.blockIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return key.node == this.node && key.blockIndex == this.blockIndex;
            }
            return false;
        }
    }

    class NodeInfo {
        Node node;
        List defNodes;

        public NodeInfo(Node node) {
            this.node = node;
            this.defNodes = new ArrayList();
        }
    }

    class Pos {
        Block block;
        int blockIndex;
        int nodeIndex;

        Pos() {
        }
    }
}

