/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.util.Assert;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class Type {
    public static final char ARRAY_CHAR = '[';
    public static final char BOOLEAN_CHAR = 'Z';
    public static final char BYTE_CHAR = 'B';
    public static final char CHARACTER_CHAR = 'C';
    public static final char CLASS_CHAR = 'L';
    public static final char DOUBLE_CHAR = 'D';
    public static final char FLOAT_CHAR = 'F';
    public static final char INTEGER_CHAR = 'I';
    public static final char LONG_CHAR = 'J';
    public static final char SHORT_CHAR = 'S';
    public static final char VOID_CHAR = 'V';
    public static final char ADDRESS_CHAR = 'A';
    public static final int BOOLEAN_CODE = 4;
    public static final int CHARACTER_CODE = 5;
    public static final int FLOAT_CODE = 6;
    public static final int DOUBLE_CODE = 7;
    public static final int BYTE_CODE = 8;
    public static final int SHORT_CODE = 9;
    public static final int INTEGER_CODE = 10;
    public static final int LONG_CODE = 11;
    public static final Type OBJECT;
    public static final Type STRING;
    public static final Type CLASS;
    public static final Type THROWABLE;
    public static final Type CLONEABLE;
    public static final Type SERIALIZABLE;
    public static final Type NULL;
    public static final Type BOOLEAN;
    public static final Type CHARACTER;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type INTEGER;
    public static final Type LONG;
    public static final Type VOID;
    public static final Type ADDRESS;
    public static boolean PRINT_TRUNCATED;
    private static Map types;
    String desc;
    Type[] paramTypes;
    Type returnType;
    private static Comparator comparator;
    private static final Comparator printComparator;

    static {
        PRINT_TRUNCATED = false;
        types = new TreeMap();
        OBJECT = Type.getType("Ljava/lang/Object;");
        STRING = Type.getType("Ljava/lang/String;");
        CLASS = Type.getType("Ljava/lang/Class;");
        THROWABLE = Type.getType("Ljava/lang/Throwable;");
        CLONEABLE = Type.getType("Ljava/lang/Cloneable;");
        SERIALIZABLE = Type.getType("Ljava/lang/Serializable;");
        NULL = Type.getType("Lnull!;");
        BOOLEAN = Type.getType('Z');
        CHARACTER = Type.getType('C');
        FLOAT = Type.getType('F');
        DOUBLE = Type.getType('D');
        BYTE = Type.getType('B');
        SHORT = Type.getType('S');
        INTEGER = Type.getType('I');
        LONG = Type.getType('J');
        VOID = Type.getType('V');
        ADDRESS = Type.getType('A');
        comparator = null;
        printComparator = null;
    }

    public static Type getType(String desc) {
        Type type = (Type)types.get(desc);
        if (type == null) {
            type = new Type(desc);
            types.put(desc, type);
        }
        return type;
    }

    public static Type getType(Class c) {
        if (c.equals(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (c.equals(Character.TYPE)) {
            return CHARACTER;
        }
        if (c.equals(Float.TYPE)) {
            return FLOAT;
        }
        if (c.equals(Double.TYPE)) {
            return DOUBLE;
        }
        if (c.equals(Byte.TYPE)) {
            return BYTE;
        }
        if (c.equals(Short.TYPE)) {
            return SHORT;
        }
        if (c.equals(Integer.TYPE)) {
            return INTEGER;
        }
        if (c.equals(Long.TYPE)) {
            return LONG;
        }
        if (c.equals(Void.TYPE)) {
            return VOID;
        }
        String name = c.getName().replace('.', '/');
        if (!c.isArray()) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }

    public static Type getType(Type[] paramTypes, Type returnType) {
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            sb.append(paramTypes[i].descriptor());
            ++i;
        }
        sb.append(")");
        sb.append(returnType.descriptor());
        return Type.getType(sb.toString());
    }

    private Type(String desc) {
        ArrayList<String> types = new ArrayList<String>();
        String t = "";
        boolean method = false;
        this.desc = desc.intern();
        int state = 0;
        int i = 0;
        if (desc.charAt(i) == '(') {
            method = true;
            ++i;
        }
        while (i < desc.length()) {
            block0 : switch (state) {
                case 0: {
                    switch (desc.charAt(i)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'V': 
                        case 'Z': {
                            types.add(String.valueOf(t) + desc.charAt(i));
                            t = "";
                            break block0;
                        }
                        case 'L': {
                            t = String.valueOf(t) + desc.charAt(i);
                            state = 1;
                            break block0;
                        }
                        case '[': {
                            t = String.valueOf(t) + desc.charAt(i);
                            break block0;
                        }
                        case ')': {
                            if (method) break block0;
                            String s = "Invalid char in type descriptor: )\nDescriptor was: " + desc;
                            throw new IllegalArgumentException(s);
                        }
                    }
                    throw new IllegalArgumentException("Invalid char in type descriptor (" + desc + "): " + desc.charAt(i));
                }
                case 1: {
                    t = String.valueOf(t) + desc.charAt(i);
                    if (desc.charAt(i) != ';') break;
                    types.add(t);
                    t = "";
                    state = 0;
                }
            }
            ++i;
        }
        if (method) {
            int sizeM1 = types.size() - 1;
            this.returnType = Type.getType((String)types.get(sizeM1));
            this.paramTypes = new Type[sizeM1];
            i = 0;
            while (i < sizeM1) {
                String s = (String)types.get(i);
                if (s != null) {
                    this.paramTypes[i] = Type.getType(s);
                }
                ++i;
            }
        } else if (types.size() != 1) {
            throw new IllegalArgumentException("More than one type in the type descriptor: " + desc);
        }
    }

    public static Type getType(int typeCode) {
        String desc = null;
        switch (typeCode) {
            case 4: {
                desc = "Z";
                break;
            }
            case 5: {
                desc = "C";
                break;
            }
            case 6: {
                desc = "F";
                break;
            }
            case 7: {
                desc = "D";
                break;
            }
            case 8: {
                desc = "B";
                break;
            }
            case 9: {
                desc = "S";
                break;
            }
            case 10: {
                desc = "I";
                break;
            }
            case 11: {
                desc = "J";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type code: " + typeCode);
            }
        }
        Type type = (Type)types.get(desc);
        if (type == null) {
            type = new Type();
            type.setDesc(desc);
            types.put(desc, type);
        }
        return type;
    }

    private Type() {
        this.desc = null;
    }

    private void setDesc(String desc) {
        this.desc = desc;
    }

    public static Type getType(char typeChar) {
        String desc = null;
        switch (typeChar) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                desc = "" + typeChar;
                desc = desc.intern();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type descriptor: " + typeChar);
            }
        }
        Type type = (Type)types.get(desc);
        if (type == null) {
            type = new Type();
            type.setDesc(desc);
            types.put(desc, type);
        }
        return type;
    }

    public int typeCode() {
        if (this.desc.length() == 1) {
            switch (this.desc.charAt(0)) {
                case 'Z': {
                    return 4;
                }
                case 'C': {
                    return 5;
                }
                case 'F': {
                    return 6;
                }
                case 'D': {
                    return 7;
                }
                case 'B': {
                    return 8;
                }
                case 'S': {
                    return 9;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
            }
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + this.desc);
    }

    public String shortName() {
        if (this.isIntegral()) {
            return "I";
        }
        if (this.isReference()) {
            return "R";
        }
        Assert.isTrue(this.desc.length() == 1, "Short name too long: " + this.desc);
        return this.desc;
    }

    public Type simple() {
        if (this.isIntegral()) {
            return INTEGER;
        }
        if (this.isReference()) {
            return OBJECT;
        }
        return this;
    }

    public String descriptor() {
        return this.desc;
    }

    public boolean isMethod() {
        return this.returnType != null;
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public boolean isVoid() {
        return this.equals(VOID);
    }

    public boolean isPrimitive() {
        return !this.isReference() && !this.isMethod() && !this.isVoid();
    }

    public boolean isIntegral() {
        return this.desc.charAt(0) == 'B' || this.desc.charAt(0) == 'S' || this.desc.charAt(0) == 'I' || this.desc.charAt(0) == 'C' || this.desc.charAt(0) == 'Z';
    }

    public boolean isArray() {
        return this.desc.charAt(0) == '[';
    }

    public boolean isObject() {
        return this.desc.charAt(0) == 'L';
    }

    public boolean isWide() {
        return this.desc.charAt(0) == 'J' || this.desc.charAt(0) == 'D';
    }

    public boolean isAddress() {
        return this.desc.charAt(0) == 'A';
    }

    public boolean isReference() {
        return this.desc.charAt(0) == '[' || this.desc.charAt(0) == 'L';
    }

    public static String classDescriptor(String name) {
        if (name.endsWith(".class")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if ((name = name.replace('.', '/')).charAt(0) == '[') {
            return name;
        }
        return String.valueOf('L') + name + ";";
    }

    public String className() {
        if (this.desc.charAt(0) == '[' || this.isPrimitive()) {
            return this.desc;
        }
        return this.desc.substring(1, this.desc.lastIndexOf(59));
    }

    public String qualifier() {
        Assert.isTrue(this.desc.charAt(0) == 'L', "No qualifier for " + this.desc);
        int index = this.desc.lastIndexOf(47);
        if (index >= 0) {
            return this.desc.substring(1, index);
        }
        return this.desc.substring(1, this.desc.lastIndexOf(59));
    }

    public int dimensions() {
        int i = 0;
        while (i < this.desc.length()) {
            if (this.desc.charAt(i) != '[') {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(this.desc) + " does not have an element type.");
    }

    public Type arrayType() {
        return Type.getType("[" + this.desc);
    }

    public Type arrayType(int dimensions) {
        String d = "";
        while (dimensions-- > 0) {
            d = String.valueOf(d) + '[';
        }
        return Type.getType(String.valueOf(d) + this.desc);
    }

    public Type elementType(int dimensions) {
        int i = 0;
        while (i < dimensions) {
            if (this.desc.charAt(i) != '[') {
                throw new IllegalArgumentException(String.valueOf(this.desc) + " is not an array");
            }
            ++i;
        }
        return Type.getType(this.desc.substring(dimensions));
    }

    public Type elementType() {
        return this.elementType(1);
    }

    public Type returnType() {
        return this.returnType;
    }

    public Type[] indexedParamTypes() {
        if (this.paramTypes == null) {
            return null;
        }
        ArrayList<Type> p = new ArrayList<Type>(this.paramTypes.length * 2);
        int i = 0;
        while (i < this.paramTypes.length) {
            p.add(this.paramTypes[i]);
            if (this.paramTypes[i].isWide()) {
                p.add(null);
            }
            ++i;
        }
        Object[] a = p.toArray();
        Type[] types = new Type[a.length];
        System.arraycopy(a, 0, types, 0, a.length);
        return types;
    }

    public Type[] paramTypes() {
        return this.paramTypes;
    }

    public int stackHeight() {
        if (this.isVoid()) {
            return 0;
        }
        if (this.isWide()) {
            return 2;
        }
        if (this.paramTypes != null) {
            int numParams = 0;
            int i = 0;
            while (i < this.paramTypes.length) {
                if (this.paramTypes[i].isWide()) {
                    ++numParams;
                }
                ++numParams;
                ++i;
            }
            return numParams;
        }
        return 1;
    }

    public int hashCode() {
        return this.desc.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Type && ((Type)obj).desc.equals(this.desc);
    }

    public static Comparator comparator() {
        if (comparator != null) {
            return comparator;
        }
        comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof Type)) {
                    throw new IllegalArgumentException(o1 + " not a Type");
                }
                if (!(o2 instanceof Type)) {
                    throw new IllegalArgumentException(o2 + " not a Type");
                }
                Type t1 = (Type)o1;
                Type t2 = (Type)o2;
                String d1 = t1.descriptor();
                String d2 = t2.descriptor();
                return d1.compareToIgnoreCase(d2);
            }

            public boolean equals(Object o) {
                return o == this;
            }
        };
        return comparator;
    }

    public static Comparator printComparator() {
        if (printComparator != null) {
            return printComparator;
        }
        comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof Type)) {
                    throw new IllegalArgumentException(o1 + " not a Type");
                }
                if (!(o2 instanceof Type)) {
                    throw new IllegalArgumentException(o2 + " not a Type");
                }
                Type t1 = (Type)o1;
                Type t2 = (Type)o2;
                String d1 = t1.toString();
                String d2 = t2.toString();
                return d1.compareToIgnoreCase(d2);
            }

            public boolean equals(Object o) {
                return o == this;
            }
        };
        return comparator;
    }

    public static String truncatedName(Type type) {
        String className;
        if (type == null) {
            return "";
        }
        if (type.isPrimitive() || type.isVoid() || type.isNull()) {
            return type.desc;
        }
        if (type.isArray()) {
            return "[" + Type.truncatedName(type.elementType());
        }
        if (type.isMethod()) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            Type[] params = type.indexedParamTypes();
            int i = 0;
            while (i < params.length) {
                sb.append(Type.truncatedName(params[i]));
                if (i < params.length - 1) {
                    sb.append(',');
                }
                ++i;
            }
            sb.append(')');
            sb.append(Type.truncatedName(type.returnType()));
            return sb.toString();
        }
        String longName = type.className();
        int lastSlash = longName.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = longName.lastIndexOf(46);
        }
        if ((className = longName.substring(lastSlash + 1)).length() > 8) {
            StringBuffer caps = new StringBuffer();
            int nameLength = className.length();
            int i = 0;
            while (i < nameLength) {
                char c = className.charAt(i);
                if (Character.isUpperCase(c)) {
                    caps.append(c);
                }
                ++i;
            }
            if (caps.length() > 8) {
                int capsLength = caps.length();
                int i2 = 4;
                while (i2 < capsLength - 4) {
                    caps.deleteCharAt(i2);
                    ++i2;
                }
                return caps.toString();
            }
            if (caps.length() <= 0) {
                return className.substring(0, 8);
            }
            char lastCap = caps.charAt(caps.length() - 1);
            int indexLastCap = className.lastIndexOf(lastCap);
            int capsLength = caps.length();
            int end = capsLength + (nameLength - indexLastCap) > 8 ? indexLastCap + 1 + (8 - capsLength) : nameLength;
            String endOfName = className.substring(indexLastCap + 1, end);
            caps.append(endOfName);
            return caps.toString();
        }
        return className;
    }

    public String toString() {
        if (PRINT_TRUNCATED) {
            return Type.truncatedName(this);
        }
        return this.desc;
    }

    public static void main(String[] args) {
        Type.truncatedName(Type.getType("(D)V"));
        int i = 0;
        while (i < args.length) {
            System.out.println("Truncated name of " + args[i] + ": " + Type.truncatedName(Type.getType(args[i])));
            ++i;
        }
    }
}

