/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRBasePrintText
extends JRBasePrintElement
implements JRPrintText {
    private static final long serialVersionUID = 10200L;
    protected String text = "";
    protected Integer textTruncateIndex;
    protected short[] lineBreakOffsets;
    protected String textTruncateSuffix;
    protected transient String truncatedText;
    protected float lineSpacingFactor = 0.0f;
    protected float leadingOffset = 0.0f;
    protected Byte horizontalAlignment = null;
    protected Byte verticalAlignment = null;
    protected Byte rotation = null;
    protected byte runDirection = 0;
    protected float textHeight = 0.0f;
    protected Byte lineSpacing = null;
    protected String markup = null;
    protected String anchorName = null;
    protected String linkType;
    protected String linkTarget;
    protected String hyperlinkReference = null;
    protected String hyperlinkAnchor = null;
    protected Integer hyperlinkPage = null;
    protected String hyperlinkTooltip;
    protected JRPrintHyperlinkParameters hyperlinkParameters;
    protected int bookmarkLevel = 0;
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    protected String valueClassName;
    protected String pattern;
    protected String formatFactoryClass;
    protected String localeCode;
    protected String timeZoneId;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private Boolean isStyledText = null;
    private byte hyperlinkType = 0;
    private byte hyperlinkTarget = 1;

    public JRBasePrintText(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public String getText() {
        if (this.truncatedText == null && this.text != null) {
            this.truncatedText = this.getTextTruncateIndex() == null ? this.text : (!"none".equals(this.getMarkup()) ? JRStyledTextParser.getInstance().write(this.getFullStyledText(JRStyledTextAttributeSelector.ALL), 0, this.getTextTruncateIndex()) : this.text.substring(0, this.getTextTruncateIndex()));
            if (this.textTruncateSuffix != null) {
                this.truncatedText = this.truncatedText + this.textTruncateSuffix;
            }
        }
        return this.truncatedText;
    }

    public void setText(String text) {
        this.text = text;
        this.truncatedText = null;
    }

    public Integer getTextTruncateIndex() {
        return this.textTruncateIndex;
    }

    public void setTextTruncateIndex(Integer textTruncateIndex) {
        this.textTruncateIndex = textTruncateIndex;
        this.truncatedText = null;
    }

    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    public void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
        this.truncatedText = null;
    }

    public short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    public void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    public String getFullText() {
        String fullText = this.text;
        if (this.textTruncateIndex == null && this.textTruncateSuffix != null) {
            fullText = fullText + this.textTruncateSuffix;
        }
        return fullText;
    }

    public String getOriginalText() {
        return this.text;
    }

    public JRStyledText getStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    public JRStyledText getFullStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getFullText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getFullText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    public void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    public void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    public void setTextAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.horizontalAlignment = new Byte(horizontalAlignment);
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(byte verticalAlignment) {
        this.verticalAlignment = new Byte(verticalAlignment);
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(byte rotation) {
        this.rotation = new Byte(rotation);
    }

    public void setRotation(Byte rotation) {
        this.rotation = rotation;
    }

    public byte getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(byte runDirection) {
        this.runDirection = runDirection;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(byte lineSpacing) {
        this.lineSpacing = new Byte(lineSpacing);
    }

    public void setLineSpacing(Byte lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    public void setStyledText(boolean isStyledText) {
        this.setStyledText(isStyledText ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean isStyledText) {
        if (isStyledText == null) {
            this.setMarkup(null);
        } else {
            this.setMarkup(isStyledText != false ? "styled" : "none");
        }
    }

    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    public String getOwnMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox box) {
        JRBoxUtil.setBoxToLineBox(box, this.lineBox);
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    public JRFont getFont() {
        return this;
    }

    public void setFont(JRFont font) {
        this.reportFont = font.getReportFont();
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.fontSize = font.getOwnSize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this.getLinkType());
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this.getLinkTarget());
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    public void setHyperlinkReference(String hyperlinkReference) {
        this.hyperlinkReference = hyperlinkReference;
    }

    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    public void setHyperlinkAnchor(String hyperlinkAnchor) {
        this.hyperlinkAnchor = hyperlinkAnchor;
    }

    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    public void setHyperlinkPage(Integer hyperlinkPage) {
        this.hyperlinkPage = hyperlinkPage;
    }

    public void setHyperlinkPage(String hyperlinkPage) {
        this.hyperlinkPage = new Integer(hyperlinkPage);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
        this.setFontSize(size);
    }

    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public void setHyperlinkParameters(JRPrintHyperlinkParameters hyperlinkParameters) {
        this.hyperlinkParameters = hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRPrintHyperlinkParameter parameter) {
        if (this.hyperlinkParameters == null) {
            this.hyperlinkParameters = new JRPrintHyperlinkParameters();
        }
        this.hyperlinkParameters.addParameter(parameter);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    protected void normalizeLinkTarget() {
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(this.hyperlinkTarget);
        }
        this.hyperlinkTarget = 1;
    }

    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public void setHyperlinkTooltip(String hyperlinkTooltip) {
        this.hyperlinkTooltip = hyperlinkTooltip;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        this.normalizeLinkType();
        this.normalizeLinkTarget();
    }
}

