/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;

public class DocxParagraphHelper
extends BaseHelper {
    private static final String HORIZONTAL_ALIGN_LEFT = "left";
    private static final String HORIZONTAL_ALIGN_RIGHT = "right";
    private static final String HORIZONTAL_ALIGN_CENTER = "center";
    private static final String HORIZONTAL_ALIGN_BOTH = "both";
    private boolean pageBreak = false;

    public DocxParagraphHelper(Writer writer, boolean pageBreak) {
        super(writer);
        this.pageBreak = pageBreak;
    }

    public void exportProps(JRStyle style) {
        this.exportPropsHeader(null);
        this.exportAlignment(DocxParagraphHelper.getHorizontalAlignment(style.getOwnHorizontalAlignment()));
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintText text) {
        this.exportPropsHeader(text.getStyle() == null ? null : text.getStyle().getName());
        this.exportAlignment(DocxParagraphHelper.getHorizontalAlignment(text.getOwnHorizontalAlignment()));
        this.exportPropsFooter();
    }

    private void exportPropsHeader(String styleNameReference) {
        this.write("      <w:pPr>\n");
        if (styleNameReference != null) {
            this.write("        <w:pStyle w:val=\"" + styleNameReference + "\"/>\n");
        }
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
    }

    private void exportAlignment(String horizontalAlignment) {
        if (horizontalAlignment != null) {
            this.write("   <w:jc w:val=\"" + horizontalAlignment + "\" />\n");
        }
    }

    private void exportPropsFooter() {
        this.write("      </w:pPr>\n");
    }

    public void exportEmptyParagraph() {
        this.write("     <w:p><w:pPr><w:pStyle w:val=\"EMPTY_CELL_STYLE\"/>\n");
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
        this.write("     </w:pPr></w:p>\n");
    }

    public static String getHorizontalAlignment(Byte horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case 3: {
                    return HORIZONTAL_ALIGN_RIGHT;
                }
                case 2: {
                    return HORIZONTAL_ALIGN_CENTER;
                }
                case 4: {
                    return HORIZONTAL_ALIGN_BOTH;
                }
            }
            return HORIZONTAL_ALIGN_LEFT;
        }
        return null;
    }
}

