/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.Db4oIOException;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.No4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Comparable4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.FirstClassHandler;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.Indexable4;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReflectException;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.btree.FieldIndexKeyHandler;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectMarshaller;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.slots.Slot;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;

public class FieldMetadata
implements StoredField {
    private ClassMetadata _containingClass;
    private int _arrayPosition;
    private String _name;
    private boolean _isArray;
    private boolean _isNArray;
    private boolean _isPrimitive;
    private ReflectField _javaField;
    TypeHandler4 _handler;
    protected int _handlerID;
    private int _state;
    private static final int NOT_LOADED = 0;
    private static final int UNAVAILABLE = -1;
    private static final int AVAILABLE = 1;
    private Config4Field _config;
    private Db4oTypeImpl _db4oType;
    private int _linkLength;
    private BTree _index;
    static final FieldMetadata[] EMPTY_ARRAY = new FieldMetadata[0];
    private boolean _initialized = false;

    public FieldMetadata(ClassMetadata classMetadata) {
        this._containingClass = classMetadata;
    }

    FieldMetadata(ClassMetadata classMetadata, ObjectTranslator objectTranslator) {
        this(classMetadata);
        this.init(classMetadata, objectTranslator.getClass().getName());
        this._state = 1;
        ObjectContainerBase objectContainerBase = this.container();
        this._handler = objectContainerBase._handlers.handlerForClass(objectContainerBase, objectContainerBase.reflector().forClass(this.translatorStoredClass(objectTranslator)));
    }

    protected final Class translatorStoredClass(ObjectTranslator objectTranslator) {
        try {
            return objectTranslator.storedClass();
        }
        catch (RuntimeException runtimeException) {
            throw new ReflectException(runtimeException);
        }
    }

    FieldMetadata(ClassMetadata classMetadata, ObjectMarshaller objectMarshaller) {
        this(classMetadata);
        this.init(classMetadata, objectMarshaller.getClass().getName());
        this._state = 1;
        this._handler = this.container()._handlers.untypedHandler();
    }

    FieldMetadata(ClassMetadata classMetadata, ReflectField reflectField, TypeHandler4 typeHandler4, int n) {
        this(classMetadata);
        this.init(classMetadata, reflectField.getName());
        this._javaField = reflectField;
        this._javaField.setAccessible();
        this._handler = typeHandler4;
        this._handlerID = n;
        boolean bl = false;
        if (reflectField instanceof GenericField) {
            bl = ((GenericField)reflectField).isPrimitive();
        }
        this.configure(reflectField.getFieldType(), bl);
        this.checkDb4oType();
        this._state = 1;
    }

    protected FieldMetadata(int n, TypeHandler4 typeHandler4) {
        this._handlerID = n;
        this._handler = typeHandler4;
    }

    public void addFieldIndex(MarshallerFamily marshallerFamily, ClassMetadata classMetadata, StatefulBuffer statefulBuffer, Slot slot) throws FieldIndexException {
        if (!this.hasIndex()) {
            this.incrementOffset(statefulBuffer);
            return;
        }
        try {
            this.addIndexEntry(statefulBuffer, this.readIndexEntry(marshallerFamily, statefulBuffer));
        }
        catch (CorruptionException corruptionException) {
            throw new FieldIndexException(corruptionException, this);
        }
    }

    protected void addIndexEntry(StatefulBuffer statefulBuffer, Object object) {
        this.addIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), object);
    }

    public void addIndexEntry(Transaction transaction, int n, Object object) {
        if (!this.hasIndex()) {
            return;
        }
        BTree bTree = this.getIndex(transaction);
        if (bTree == null) {
            return;
        }
        bTree.add(transaction, this.createFieldIndexKey(n, object));
    }

    private FieldIndexKey createFieldIndexKey(int n, Object object) {
        Object object2 = this.indexEntryFor(object);
        return new FieldIndexKey(n, object2);
    }

    protected Object indexEntryFor(Object object) {
        return this._javaField.indexEntry(object);
    }

    public boolean canUseNullBitmap() {
        return true;
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException, Db4oIOException {
        return ((IndexableTypeHandler)this._handler).readIndexEntry(marshallerFamily, statefulBuffer);
    }

    public void removeIndexEntry(Transaction transaction, int n, Object object) {
        if (!this.hasIndex()) {
            return;
        }
        if (this._index == null) {
            return;
        }
        this._index.remove(transaction, this.createFieldIndexKey(n, object));
    }

    public boolean alive() {
        if (this._state == 1) {
            return true;
        }
        if (this._state == 0) {
            if (this._handler == null) {
                this._handler = this.loadJavaField1();
                this.checkHandlerID();
            }
            this.loadJavaField();
            if (this._handler != null) {
                this._handler = this.wrapHandlerToArrays(this.container(), this._handler);
            }
            if (this._handler == null || this._javaField == null) {
                this._state = -1;
                this._javaField = null;
            } else {
                this._state = 1;
                this.checkDb4oType();
            }
        }
        return this._state == 1;
    }

    private void checkHandlerID() {
        if (!(this._handler instanceof ClassMetadata)) {
            return;
        }
        ClassMetadata classMetadata = (ClassMetadata)this._handler;
        int n = classMetadata.getID();
        if (this._handlerID == 0) {
            this._handlerID = n;
            return;
        }
        if (n > 0 && n != this._handlerID) {
            this._handler = null;
        }
    }

    boolean canAddToQuery(String string) {
        if (!this.alive()) {
            return false;
        }
        return string.equals(this.getName()) && this.containingClass() != null && !this.containingClass().isInternal();
    }

    public boolean canHold(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return !this._isPrimitive;
        }
        return Handlers4.handlerCanHold(this._handler, reflectClass);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        if (reflectClass == null || object == null) {
            return this._isPrimitive ? No4.INSTANCE : object;
        }
        if (this._handler instanceof PrimitiveHandler) {
            return ((PrimitiveHandler)this._handler).coerce(reflectClass, object);
        }
        if (!this.canHold(reflectClass)) {
            return No4.INSTANCE;
        }
        return object;
    }

    public final boolean canLoadByIndex() {
        ClassMetadata classMetadata;
        return !(this._handler instanceof ClassMetadata) || !(classMetadata = (ClassMetadata)this._handler).isArray();
    }

    void cascadeActivation(Transaction transaction, Object object, int n, boolean bl) {
        if (!this.alive()) {
            return;
        }
        if (!(this._handler instanceof FirstClassHandler)) {
            return;
        }
        FirstClassHandler firstClassHandler = (FirstClassHandler)((Object)this._handler);
        try {
            Object object2 = this.getOrCreate(transaction, object);
            if (object2 == null) {
                return;
            }
            firstClassHandler.cascadeActivation(transaction, object2, n, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkDb4oType() {
        if (this._javaField != null && this.container()._handlers.ICLASS_DB4OTYPE.isAssignableFrom(this._javaField.getFieldType())) {
            this._db4oType = HandlerRegistry.getDb4oType(this._javaField.getFieldType());
        }
    }

    void collectConstraints(Transaction transaction, QConObject qConObject, Object object, Visitor4 visitor4) {
        Object object2 = this.getOn(transaction, object);
        if (object2 != null) {
            Collection4 collection4 = Platform4.flattenCollection(transaction.container(), object2);
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                object2 = iterator4.current();
                if (object2 == null) continue;
                if (this._isPrimitive && this._handler instanceof PrimitiveHandler && object2.equals(((PrimitiveHandler)this._handler).primitiveNull())) {
                    return;
                }
                if (qConObject.hasObjectInParentPath(object2)) continue;
                visitor4.visit(new QConObject(transaction, qConObject, this.qField(transaction), object2));
            }
        }
    }

    public final TreeInt collectIDs(MarshallerFamily marshallerFamily, TreeInt treeInt, StatefulBuffer statefulBuffer) throws FieldIndexException {
        if (!this.alive()) {
            return treeInt;
        }
        if (this._handler instanceof ClassMetadata) {
            return (TreeInt)Tree.add(treeInt, new TreeInt(statefulBuffer.readInt()));
        }
        if (this._handler instanceof ArrayHandler) {
            return ((ArrayHandler)this._handler).collectIDs(marshallerFamily, treeInt, statefulBuffer);
        }
        return treeInt;
    }

    void configure(ReflectClass reflectClass, boolean bl) {
        this._isArray = reflectClass.isArray();
        if (this._isArray) {
            ReflectArray reflectArray = this.container().reflector().array();
            this._isNArray = reflectArray.isNDimensional(reflectClass);
            this._isPrimitive = reflectArray.getComponentType(reflectClass).isPrimitive();
            this._handler = this.wrapHandlerToArrays(this.container(), this._handler);
        } else {
            this._isPrimitive = bl | reflectClass.isPrimitive();
        }
    }

    private final TypeHandler4 wrapHandlerToArrays(ObjectContainerBase objectContainerBase, TypeHandler4 typeHandler4) {
        if (this._isNArray) {
            return new MultidimensionalArrayHandler(objectContainerBase, typeHandler4, this.arraysUsePrimitiveClassReflector());
        }
        if (this._isArray) {
            return new ArrayHandler(objectContainerBase, typeHandler4, this.arraysUsePrimitiveClassReflector());
        }
        return typeHandler4;
    }

    private boolean arraysUsePrimitiveClassReflector() {
        return this._isPrimitive;
    }

    void deactivate(Transaction transaction, Object object, int n) {
        if (!this.alive()) {
            return;
        }
        boolean bl = this._containingClass.isEnum();
        if (this._isPrimitive && !this._isArray) {
            if (!bl) {
                this._javaField.set(object, ((PrimitiveHandler)this._handler).primitiveNull());
            }
            return;
        }
        if (n > 0) {
            this.cascadeActivation(transaction, object, n, false);
        }
        if (!bl) {
            this._javaField.set(object, null);
        }
    }

    public void delete(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws FieldIndexException {
        if (!this.checkAlive(statefulBuffer)) {
            return;
        }
        try {
            this.removeIndexEntry(marshallerFamily, statefulBuffer);
            boolean bl2 = false;
            if (this._config != null && this._config.cascadeOnDelete().definiteYes() || bl2) {
                int n = statefulBuffer.cascadeDeletes();
                statefulBuffer.setCascadeDeletes(1);
                this._handler.deleteEmbedded(marshallerFamily, statefulBuffer);
                statefulBuffer.setCascadeDeletes(n);
            } else if (this._config != null && this._config.cascadeOnDelete().definiteNo()) {
                int n = statefulBuffer.cascadeDeletes();
                statefulBuffer.setCascadeDeletes(0);
                this._handler.deleteEmbedded(marshallerFamily, statefulBuffer);
                statefulBuffer.setCascadeDeletes(n);
            } else {
                this._handler.deleteEmbedded(marshallerFamily, statefulBuffer);
            }
        }
        catch (CorruptionException corruptionException) {
            throw new FieldIndexException(corruptionException, this);
        }
    }

    private final void removeIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException, Db4oIOException {
        if (!this.hasIndex()) {
            return;
        }
        int n = statefulBuffer._offset;
        Object object = this.readIndexEntry(marshallerFamily, statefulBuffer);
        this.removeIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), object);
        statefulBuffer._offset = n;
    }

    public boolean equals(Object object) {
        if (object instanceof FieldMetadata) {
            FieldMetadata fieldMetadata = (FieldMetadata)object;
            fieldMetadata.alive();
            this.alive();
            return fieldMetadata._isPrimitive == this._isPrimitive && fieldMetadata._handler.equals(this._handler) && fieldMetadata._name.equals(this._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public final Object get(Object object) {
        return this.get(null, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Transaction transaction, Object object) {
        if (this._containingClass == null) {
            return null;
        }
        ObjectContainerBase objectContainerBase = this.container();
        if (objectContainerBase == null) {
            return null;
        }
        Object object2 = objectContainerBase._lock;
        synchronized (object2) {
            if (transaction == null) {
                transaction = objectContainerBase.transaction();
            }
            objectContainerBase.checkClosed();
            ObjectReference objectReference = transaction.referenceForObject(object);
            if (objectReference == null) {
                return null;
            }
            int n = objectReference.getID();
            if (n <= 0) {
                return null;
            }
            UnmarshallingContext unmarshallingContext = new UnmarshallingContext(transaction, objectReference, 1, false);
            return unmarshallingContext.readFieldValue(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public final ClassMetadata handlerClassMetadata(ObjectContainerBase objectContainerBase) {
        TypeHandler4 typeHandler4 = this.baseTypeHandler();
        if (Handlers4.handlesSimple(typeHandler4)) {
            return objectContainerBase._handlers.classMetadataForId(this.handlerID());
        }
        return (ClassMetadata)typeHandler4;
    }

    private TypeHandler4 baseTypeHandler() {
        return Handlers4.baseTypeHandler(this._handler);
    }

    public TypeHandler4 getHandler() {
        return this._handler;
    }

    public int handlerID() {
        return this._handlerID;
    }

    public Object getOn(Transaction transaction, Object object) {
        if (this.alive()) {
            return this._javaField.get(object);
        }
        return null;
    }

    public Object getOrCreate(Transaction transaction, Object object) {
        if (!this.alive()) {
            return null;
        }
        Object object2 = this._javaField.get(object);
        if (this._db4oType != null && object2 == null) {
            object2 = this._db4oType.createDefault(transaction);
            this._javaField.set(object, object2);
        }
        return object2;
    }

    public final ClassMetadata containingClass() {
        return this._containingClass;
    }

    public ReflectClass getStoredType() {
        if (this._javaField == null) {
            return null;
        }
        return Handlers4.baseType(this._javaField.getFieldType());
    }

    public ObjectContainerBase container() {
        if (this._containingClass == null) {
            return null;
        }
        return this._containingClass.container();
    }

    public boolean hasConfig() {
        return this._config != null;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public final void incrementOffset(Buffer buffer) {
        buffer.incrementOffset(this.linkLength());
    }

    public final void init(ClassMetadata classMetadata, String string) {
        this._containingClass = classMetadata;
        this._name = string;
        this.initIndex(classMetadata, string);
    }

    final void initIndex(ClassMetadata classMetadata, String string) {
        if (classMetadata.config() == null) {
            return;
        }
        this._config = classMetadata.config().configField(string);
    }

    public void init(int n, boolean bl, boolean bl2, boolean bl3) {
        this._handlerID = n;
        this._isPrimitive = bl;
        this._isArray = bl2;
        this._isNArray = bl3;
    }

    final void initConfigOnUp(Transaction transaction) {
        if (this._config != null && !this._initialized) {
            this._initialized = true;
            this._config.initOnUp(transaction, this);
        }
    }

    public void instantiate(UnmarshallingContext unmarshallingContext) {
        if (!this.checkAlive(unmarshallingContext.buffer())) {
            return;
        }
        Object object = this.read(unmarshallingContext);
        this.informAboutTransaction(object, unmarshallingContext.transaction());
        this.set(unmarshallingContext.persistentObject(), object);
    }

    private boolean checkAlive(Buffer buffer) {
        boolean bl = this.alive();
        if (!bl) {
            this.incrementOffset(buffer);
        }
        return bl;
    }

    private void informAboutTransaction(Object object, Transaction transaction) {
        if (this._db4oType != null && object != null) {
            ((Db4oTypeImpl)object).setTrans(transaction);
        }
    }

    public boolean isArray() {
        return this._isArray;
    }

    protected int linkLength() {
        this.alive();
        if (this._linkLength == 0) {
            this._linkLength = this.calculateLinkLength();
        }
        return this._linkLength;
    }

    private int calculateLinkLength() {
        if (this._handler == null) {
            return 4;
        }
        if (this._handler instanceof PersistentBase) {
            return ((PersistentBase)((Object)this._handler)).linkLength();
        }
        if (this._handler instanceof PrimitiveHandler) {
            return ((PrimitiveHandler)this._handler).linkLength();
        }
        if (this._handler instanceof VariableLengthTypeHandler) {
            return ((VariableLengthTypeHandler)this._handler).linkLength();
        }
        throw new NotImplementedException();
    }

    public void loadHandler(ObjectContainerBase objectContainerBase) {
        this._handler = objectContainerBase.handlerByID(this._handlerID);
    }

    private void loadJavaField() {
        TypeHandler4 typeHandler4 = this.loadJavaField1();
        if (typeHandler4 == null || !typeHandler4.equals(this._handler)) {
            this._javaField = null;
            this._state = -1;
        }
    }

    private TypeHandler4 loadJavaField1() {
        ReflectClass reflectClass = this._containingClass.classReflector();
        if (reflectClass == null) {
            return null;
        }
        this._javaField = reflectClass.getDeclaredField(this._name);
        if (this._javaField == null) {
            return null;
        }
        this._javaField.setAccessible();
        ObjectContainerBase objectContainerBase = this.container();
        objectContainerBase.showInternalClasses(true);
        TypeHandler4 typeHandler4 = objectContainerBase._handlers.handlerForClass(objectContainerBase, this._javaField.getFieldType());
        objectContainerBase.showInternalClasses(false);
        return typeHandler4;
    }

    private int adjustUpdateDepth(Object object, int n) {
        int n2 = 1;
        if (this._containingClass.isCollection(object)) {
            GenericReflector genericReflector = this._containingClass.reflector();
            n2 = genericReflector.collectionUpdateDepth(genericReflector.forObject(object));
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    private boolean cascadeOnUpdate(Config4Class config4Class) {
        return config4Class != null && config4Class.cascadeOnUpdate().definiteYes() || this._config != null && this._config.cascadeOnUpdate().definiteYes();
    }

    public void marshall(MarshallingContext marshallingContext, Object object) {
        int n = marshallingContext.updateDepth();
        if (object != null && this.cascadeOnUpdate(marshallingContext.classConfiguration())) {
            marshallingContext.updateDepth(this.adjustUpdateDepth(object, n));
        }
        marshallingContext.createIndirection(this._handler);
        this._handler.write(marshallingContext, object);
        marshallingContext.updateDepth(n);
        if (this.hasIndex()) {
            marshallingContext.addIndexEntry(this, object);
        }
    }

    public boolean needsArrayAndPrimitiveInfo() {
        return true;
    }

    public boolean needsHandlerId() {
        return true;
    }

    public Comparable4 prepareComparison(Object object) {
        if (this.alive()) {
            this._handler.prepareComparison(object);
            return this._handler;
        }
        return null;
    }

    public QField qField(Transaction transaction) {
        int n = 0;
        if (this._containingClass != null) {
            n = this._containingClass.getID();
        }
        return new QField(transaction, this._name, this, n, this._arrayPosition);
    }

    public Object read(InternalReadContext internalReadContext) {
        if (!this.checkAlive(internalReadContext.buffer())) {
            return null;
        }
        return internalReadContext.read(this._handler);
    }

    public void readVirtualAttribute(Transaction transaction, Buffer buffer, ObjectReference objectReference) {
        this.incrementOffset(buffer);
    }

    public void refreshActivated() {
        this._state = 1;
        this.refresh();
    }

    void refresh() {
        TypeHandler4 typeHandler4 = this.loadJavaField1();
        if (typeHandler4 != null && (typeHandler4 = this.wrapHandlerToArrays(this.container(), typeHandler4)).equals(this._handler)) {
            this._state = 1;
            return;
        }
        this._javaField = null;
        this._state = -1;
    }

    public void rename(String string) {
        ObjectContainerBase objectContainerBase = this.container();
        if (!objectContainerBase.isClient()) {
            this._name = string;
            this._containingClass.setStateDirty();
            this._containingClass.write(objectContainerBase.systemTransaction());
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    public void setArrayPosition(int n) {
        this._arrayPosition = n;
    }

    public void set(Object object, Object object2) {
        if (null == this._javaField) {
            return;
        }
        this._javaField.set(object, object2);
    }

    void setName(String string) {
        this._name = string;
    }

    boolean supportsIndex() {
        return this.alive() && this._handler instanceof Indexable4 && !(this._handler instanceof UntypedFieldHandler);
    }

    public final void traverseValues(Visitor4 visitor4) {
        if (!this.alive()) {
            return;
        }
        this.traverseValues(this.container().transaction(), visitor4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverseValues(final Transaction transaction, final Visitor4 visitor4) {
        if (!this.alive()) {
            return;
        }
        this.assertHasIndex();
        ObjectContainerBase objectContainerBase = transaction.container();
        if (objectContainerBase.isClient()) {
            Exceptions4.throwRuntimeException(67);
        }
        Object object = objectContainerBase.lock();
        synchronized (object) {
            this._index.traverseKeys(transaction, new Visitor4(){

                public void visit(Object object) {
                    FieldIndexKey fieldIndexKey = (FieldIndexKey)object;
                    visitor4.visit(((IndexableTypeHandler)FieldMetadata.this._handler).indexEntryToObject(transaction, fieldIndexKey.value()));
                }
            });
        }
    }

    private void assertHasIndex() {
        if (!this.hasIndex()) {
            Exceptions4.throwRuntimeException(66);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._containingClass != null) {
            stringBuffer.append(this._containingClass.getName());
            stringBuffer.append(".");
            stringBuffer.append(this.getName());
        }
        return stringBuffer.toString();
    }

    private void initIndex(Transaction transaction) {
        this.initIndex(transaction, 0);
    }

    public void initIndex(Transaction transaction, int n) {
        if (this._index != null) {
            throw new IllegalStateException();
        }
        if (transaction.container().isClient()) {
            return;
        }
        this._index = this.newBTree(transaction, n);
    }

    protected final BTree newBTree(Transaction transaction, int n) {
        ObjectContainerBase objectContainerBase = transaction.container();
        Indexable4 indexable4 = this.indexHandler(objectContainerBase);
        if (indexable4 == null) {
            return null;
        }
        return new BTree(transaction, n, new FieldIndexKeyHandler(objectContainerBase, indexable4));
    }

    protected Indexable4 indexHandler(ObjectContainerBase objectContainerBase) {
        if (this._javaField == null) {
            return null;
        }
        ReflectClass reflectClass = this._javaField.indexType();
        TypeHandler4 typeHandler4 = objectContainerBase._handlers.handlerForClass(objectContainerBase, reflectClass);
        if (!(typeHandler4 instanceof Indexable4)) {
            return null;
        }
        return (Indexable4)((Object)typeHandler4);
    }

    public BTree getIndex(Transaction transaction) {
        return this._index;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public BTreeRange search(Transaction transaction, Object object) {
        this.assertHasIndex();
        Object object2 = this.wrapWithTransactionContext(transaction, object);
        BTreeNodeSearchResult bTreeNodeSearchResult = this.searchLowerBound(transaction, object2);
        BTreeNodeSearchResult bTreeNodeSearchResult2 = this.searchUpperBound(transaction, object2);
        return bTreeNodeSearchResult.createIncludingRange(bTreeNodeSearchResult2);
    }

    private Object wrapWithTransactionContext(Transaction transaction, Object object) {
        if (this._handler instanceof ClassMetadata) {
            object = ((ClassMetadata)this._handler).wrapWithTransactionContext(transaction, object);
        }
        return object;
    }

    private BTreeNodeSearchResult searchUpperBound(Transaction transaction, Object object) {
        return this.searchBound(transaction, Integer.MAX_VALUE, object);
    }

    private BTreeNodeSearchResult searchLowerBound(Transaction transaction, Object object) {
        return this.searchBound(transaction, 0, object);
    }

    private BTreeNodeSearchResult searchBound(Transaction transaction, int n, Object object) {
        return this.getIndex(transaction).searchLeaf(transaction, this.createFieldIndexKey(n, object), SearchTarget.LOWEST);
    }

    public boolean rebuildIndexForClass(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata) {
        long[] lArray = classMetadata.getIDs();
        for (int i = 0; i < lArray.length; ++i) {
            this.rebuildIndexForObject(localObjectContainer, classMetadata, (int)lArray[i]);
        }
        return lArray.length > 0;
    }

    protected void rebuildIndexForObject(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata, int n) throws FieldIndexException {
        StatefulBuffer statefulBuffer = localObjectContainer.readWriterByID(localObjectContainer.systemTransaction(), n);
        if (statefulBuffer != null) {
            this.rebuildIndexForWriter(localObjectContainer, statefulBuffer, n);
        }
    }

    protected void rebuildIndexForWriter(LocalObjectContainer localObjectContainer, StatefulBuffer statefulBuffer, int n) {
        ObjectHeader objectHeader = new ObjectHeader(localObjectContainer, (Buffer)statefulBuffer);
        Object object = this.readIndexEntryForRebuild(statefulBuffer, objectHeader);
        this.addIndexEntry(localObjectContainer.systemTransaction(), n, object);
    }

    private Object readIndexEntryForRebuild(StatefulBuffer statefulBuffer, ObjectHeader objectHeader) {
        return objectHeader.objectMarshaller().readIndexEntry(objectHeader.classMetadata(), objectHeader._headerAttributes, this, statefulBuffer);
    }

    public void dropIndex(Transaction transaction) {
        if (this._index == null) {
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.container();
        if (objectContainerBase.configImpl().messageLevel() > 0) {
            objectContainerBase.message("dropping index " + this.toString());
        }
        this._index.free(transaction);
        objectContainerBase.setDirtyInSystemTransaction(this.containingClass());
        this._index = null;
    }

    public void defragField(MarshallerFamily marshallerFamily, BufferPair bufferPair) {
        this.getHandler().defrag(marshallerFamily, bufferPair, true);
    }

    public void createIndex() {
        if (this.hasIndex()) {
            return;
        }
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)this.container();
        if (localObjectContainer.configImpl().messageLevel() > 0) {
            localObjectContainer.message("creating index " + this.toString());
        }
        this.initIndex(localObjectContainer.systemTransaction());
        localObjectContainer.setDirtyInSystemTransaction(this.containingClass());
        this.reindex(localObjectContainer);
    }

    private void reindex(LocalObjectContainer localObjectContainer) {
        ClassMetadata classMetadata = this.containingClass();
        if (this.rebuildIndexForClass(localObjectContainer, classMetadata)) {
            localObjectContainer.systemTransaction().commit();
        }
    }
}

