/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cluster;

import com.db4o.ObjectSet;
import com.db4o.cluster.Cluster;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;

public class ClusterQueryResult
implements QueryResult {
    private final Cluster _cluster;
    private final ObjectSet[] _objectSets;
    private final int[] _sizes;
    private final int _size;

    public ClusterQueryResult(Cluster cluster, Query[] queryArray) {
        this._cluster = cluster;
        this._objectSets = new ObjectSet[queryArray.length];
        this._sizes = new int[queryArray.length];
        int n = 0;
        for (int i = 0; i < queryArray.length; ++i) {
            this._objectSets[i] = queryArray[i].execute();
            this._sizes[i] = this._objectSets[i].size();
            n += this._sizes[i];
        }
        this._size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntIterator4 iterateIDs() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            Iterator4[] iterator4Array = new Iterator4[this._objectSets.length];
            for (int i = 0; i < this._objectSets.length; ++i) {
                iterator4Array[i] = ((ObjectSetFacade)this._objectSets[i])._delegate.iterateIDs();
            }
            return new ClusterQueryResultIntIterator(iterator4Array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator4 iterator() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            Iterator4[] iterator4Array = new Iterator4[this._objectSets.length];
            for (int i = 0; i < this._objectSets.length; ++i) {
                iterator4Array[i] = ((ObjectSetFacade)this._objectSets[i])._delegate.iterator();
            }
            return new CompositeIterator4(iterator4Array);
        }
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = 0;
            while (n >= this._sizes[n2]) {
                n -= this._sizes[n2];
                ++n2;
            }
            return ((ObjectSetFacade)this._objectSets[n2]).get(n);
        }
    }

    public Object lock() {
        return this._cluster;
    }

    public ExtObjectContainer objectContainer() {
        throw new NotSupportedException();
    }

    public int indexOf(int n) {
        throw new NotSupportedException();
    }

    public void sort(QueryComparator queryComparator) {
        throw new NotSupportedException();
    }

    public void loadFromClassIndex(ClassMetadata classMetadata) {
        throw new NotSupportedException();
    }

    public void loadFromQuery(QQuery qQuery) {
        throw new NotSupportedException();
    }

    public void loadFromClassIndexes(ClassMetadataIterator classMetadataIterator) {
        throw new NotSupportedException();
    }

    public void loadFromIdReader(Buffer buffer) {
        throw new NotSupportedException();
    }

    private static final class ClusterQueryResultIntIterator
    implements IntIterator4 {
        private final CompositeIterator4 _delegate;

        public ClusterQueryResultIntIterator(Iterator4[] iterator4Array) {
            this._delegate = new CompositeIterator4(iterator4Array);
        }

        public boolean moveNext() {
            return this._delegate.moveNext();
        }

        public Object current() {
            return this._delegate.current();
        }

        public void reset() {
            this._delegate.reset();
        }

        public int currentInt() {
            return ((IntIterator4)this._delegate.currentIterator()).currentInt();
        }
    }
}

