/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.convert;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.SystemData;
import com.db4o.internal.convert.Conversion;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.conversions.CommonConversions;

public class Converter {
    public static final int VERSION = 6;
    private static Converter _converter;
    private Hashtable4 _conversions = new Hashtable4();

    private Converter() {
        CommonConversions.register(this);
    }

    public static boolean convert(ConversionStage conversionStage) {
        if (!Converter.needsConversion(conversionStage.systemData())) {
            return false;
        }
        if (_converter == null) {
            _converter = new Converter();
        }
        return _converter.runConversions(conversionStage);
    }

    private static boolean needsConversion(SystemData systemData) {
        return systemData.converterVersion() < 6;
    }

    public void register(int n, Conversion conversion) {
        if (this._conversions.get(n) != null) {
            throw new IllegalStateException();
        }
        this._conversions.put(n, (Object)conversion);
    }

    public boolean runConversions(ConversionStage conversionStage) {
        SystemData systemData = conversionStage.systemData();
        if (!Converter.needsConversion(systemData)) {
            return false;
        }
        for (int i = systemData.converterVersion(); i <= 6; ++i) {
            Conversion conversion = (Conversion)this._conversions.get(i);
            if (conversion == null) continue;
            conversionStage.accept(conversion);
        }
        return true;
    }
}

