/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public class FloatHandler
extends IntHandler {
    private static final Float i_primitive = new Float(0.0f);
    private float i_compareTo;

    public FloatHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toFloat(object);
    }

    public Object defaultValue() {
        return i_primitive;
    }

    protected Class primitiveJavaClass() {
        return Float.TYPE;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._primitive.readFloat(statefulBuffer);
    }

    Object read1(Buffer buffer) {
        return this.primitiveMarshaller().readFloat(buffer);
    }

    public void write(Object object, Buffer buffer) {
        FloatHandler.writeInt(Float.floatToIntBits(((Float)object).floatValue()), buffer);
    }

    private float valu(Object object) {
        return ((Float)object).floatValue();
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.valu(object);
    }

    boolean isEqual1(Object object) {
        return object instanceof Float && this.valu(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        return object instanceof Float && this.valu(object) > this.i_compareTo;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Float && this.valu(object) < this.i_compareTo;
    }

    public Object read(ReadContext readContext) {
        return new Float(Float.intBitsToFloat(readContext.readInt()));
    }

    public void write(WriteContext writeContext, Object object) {
        writeContext.writeInt(Float.floatToIntBits(((Float)object).floatValue()));
    }
}

