/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

public class Slot {
    private final int _address;
    private final int _length;
    public static final Slot ZERO = new Slot(0, 0);
    public static int MARSHALLED_LENGTH = 8;

    public Slot(int n, int n2) {
        this._address = n;
        this._length = n2;
    }

    public int address() {
        return this._address;
    }

    public int length() {
        return this._length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Slot)) {
            return false;
        }
        Slot slot = (Slot)object;
        return this._address == slot._address && this.length() == slot.length();
    }

    public int hashCode() {
        return this._address ^ this.length();
    }

    public Slot subSlot(int n) {
        return new Slot(this._address + n, this.length() - n);
    }

    public String toString() {
        return "[A:" + this._address + ",L:" + this.length() + "]";
    }

    public Slot truncate(int n) {
        return new Slot(this._address, n);
    }

    public int compareByAddress(Slot slot) {
        int n = slot._address - this._address;
        if (n != 0) {
            return n;
        }
        return slot.length() - this.length();
    }

    public int compareByLength(Slot slot) {
        int n = slot.length() - this.length();
        if (n != 0) {
            return n;
        }
        return slot._address - this._address;
    }

    public boolean isDirectlyPreceding(Slot slot) {
        return this._address + this.length() == slot._address;
    }

    public Slot append(Slot slot) {
        return new Slot(this.address(), this._length + slot.length());
    }
}

