/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.Db4oIOException;

public abstract class IoAdapter {
    private static final int COPY_SIZE = 4096;
    private int _blockSize;

    protected final long regularAddress(int n, int n2) {
        if (0 == this._blockSize) {
            throw new IllegalStateException();
        }
        return (long)n * (long)this._blockSize + (long)n2;
    }

    public void blockCopy(int n, int n2, int n3, int n4, int n5) throws Db4oIOException {
        this.copy(this.regularAddress(n, n2), this.regularAddress(n3, n4), n5);
    }

    public void blockSeek(int n) throws Db4oIOException {
        this.blockSeek(n, 0);
    }

    public void blockSeek(int n, int n2) throws Db4oIOException {
        this.seek(this.regularAddress(n, n2));
    }

    public void blockSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this._blockSize = n;
    }

    public abstract void close() throws Db4oIOException;

    public void copy(long l, long l2, int n) throws Db4oIOException {
        if (n > 4096) {
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while (n2 + 4096 < n) {
                this.copy(byArray, l + (long)n2, l2 + (long)n2);
                n2 += 4096;
            }
            l += (long)n2;
            l2 += (long)n2;
            n -= n2;
        }
        this.copy(new byte[n], l, l2);
    }

    private void copy(byte[] byArray, long l, long l2) throws Db4oIOException {
        this.seek(l);
        this.read(byArray);
        this.seek(l2);
        this.write(byArray);
    }

    public abstract void delete(String var1);

    public abstract boolean exists(String var1);

    public abstract long getLength() throws Db4oIOException;

    public abstract IoAdapter open(String var1, boolean var2, long var3, boolean var5) throws Db4oIOException;

    public int read(byte[] byArray) throws Db4oIOException {
        return this.read(byArray, byArray.length);
    }

    public abstract int read(byte[] var1, int var2) throws Db4oIOException;

    public abstract void seek(long var1) throws Db4oIOException;

    public abstract void sync() throws Db4oIOException;

    public void write(byte[] byArray) throws Db4oIOException {
        this.write(byArray, byArray.length);
    }

    public abstract void write(byte[] var1, int var2) throws Db4oIOException;

    public int blockSize() {
        return this._blockSize;
    }

    public IoAdapter delegatedIoAdapter() {
        return this;
    }
}

