/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports;

import java.util.List;
import java.util.Set;
import jgnash.bayes.BayesClassifier;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.imports.ImportTransaction;

public class BayesImportClassifier {
    private BayesImportClassifier() {
    }

    public static void classifyTransactions(List<? extends ImportTransaction> list, Account baseAccount) {
        BayesClassifier<Account> classifier = BayesImportClassifier.generateClassifier(baseAccount);
        for (ImportTransaction importTransaction : list) {
            StringBuilder builder = new StringBuilder();
            if (importTransaction.payee != null) {
                builder.append(importTransaction.payee).append(" ");
            }
            if (importTransaction.memo != null) {
                builder.append(importTransaction.memo);
            }
            importTransaction.account = (Account)classifier.classify(builder.toString());
        }
    }

    public static BayesClassifier<Account> generateClassifier(Account baseAccount) {
        BayesClassifier classifier = new BayesClassifier((Object)baseAccount);
        for (Transaction t : baseAccount.getReadonlyTransactionList()) {
            Set accountSet = t.getAccounts();
            accountSet.remove(baseAccount);
            for (Account account : accountSet) {
                if (!t.getPayee().isEmpty()) {
                    classifier.train(t.getPayee(), (Object)account);
                }
                if (t.getMemo().isEmpty()) continue;
                classifier.train(t.getMemo(), (Object)account);
            }
        }
        return classifier;
    }
}

