/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.imports.ImportTransaction;
import jgnash.imports.ofx.OfxTransaction;
import jgnash.util.DateUtils;

public class GenericImport {
    public static void importTransactions(List<? extends ImportTransaction> transactions, Account baseAccount) {
        assert (transactions != null && baseAccount != null);
        Engine engine = EngineFactory.getEngine((String)"default");
        for (ImportTransaction importTransaction : transactions) {
            Transaction t;
            assert (importTransaction.account != null);
            if (importTransaction.getState() != ImportTransaction.ImportState.NEW && importTransaction.getState() != ImportTransaction.ImportState.NOT_EQUAL || (t = baseAccount.equals((Object)importTransaction.account) ? TransactionFactory.generateSingleEntryTransaction((Account)baseAccount, (BigDecimal)importTransaction.amount, (Date)importTransaction.datePosted, (boolean)false, (String)importTransaction.memo, (String)importTransaction.payee, (String)importTransaction.checkNumber) : (importTransaction.amount.signum() >= 0 ? TransactionFactory.generateDoubleEntryTransaction((Account)baseAccount, (Account)importTransaction.account, (BigDecimal)importTransaction.amount.abs(), (Date)importTransaction.datePosted, (String)importTransaction.memo, (String)importTransaction.payee, (String)importTransaction.checkNumber) : TransactionFactory.generateDoubleEntryTransaction((Account)importTransaction.account, (Account)baseAccount, (BigDecimal)importTransaction.amount.abs(), (Date)importTransaction.datePosted, (String)importTransaction.memo, (String)importTransaction.payee, (String)importTransaction.checkNumber))) == null) continue;
            engine.addTransaction(t);
        }
    }

    public static void matchTransactions(List<? extends ImportTransaction> list, Account baseAccount) {
        block0: for (ImportTransaction importTransaction : list) {
            for (Transaction tran : baseAccount.getReadonlyTransactionList()) {
                String id;
                Date endDate;
                Date startDate;
                if (!tran.getAmount(baseAccount).equals(importTransaction.amount)) continue;
                if (importTransaction.dateUser != null) {
                    startDate = DateUtils.addDays((Date)importTransaction.dateUser, (int)-1);
                    endDate = DateUtils.addDays((Date)importTransaction.dateUser, (int)1);
                } else {
                    startDate = DateUtils.addDays((Date)importTransaction.datePosted, (int)-3);
                    endDate = DateUtils.addDays((Date)importTransaction.datePosted, (int)3);
                }
                if (DateUtils.after((Date)tran.getDate(), (Date)startDate) && DateUtils.before((Date)tran.getDate(), (Date)endDate)) {
                    importTransaction.setState(ImportTransaction.ImportState.EQUAL);
                    continue block0;
                }
                String checkNumber = importTransaction.checkNumber;
                if (checkNumber != null && checkNumber.length() > 0 && tran.getNumber() != null && tran.getNumber().equals(checkNumber)) {
                    importTransaction.setState(ImportTransaction.ImportState.EQUAL);
                    continue block0;
                }
                if (!(importTransaction instanceof OfxTransaction) || (id = ((OfxTransaction)importTransaction).transactionID) == null || id.length() <= 0 || tran.getFitid() == null || !tran.getFitid().equals(id)) continue;
                importTransaction.setState(ImportTransaction.ImportState.EQUAL);
                continue block0;
            }
        }
    }

    private GenericImport() {
    }
}

