/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.ofx;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jgnash.imports.ofx.OfxBank;
import jgnash.imports.ofx.OfxTags;
import jgnash.imports.ofx.OfxTransaction;

public class OfxV2Parser
implements OfxTags {
    private static final Logger logger = Logger.getLogger("OfxV2Parser");
    private static final boolean debug = false;
    public static final String EXTRA_SPACE_REGEX = "\\s+";
    private OfxBank bank;

    public void parse(InputStream stream) {
        this.parse(stream, "UTF-8");
    }

    public void parse(InputStream stream, String encoding) {
        logger.entering(OfxV2Parser.class.getName(), "parse");
        this.bank = new OfxBank();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try (BufferedInputStream input = new BufferedInputStream(stream);){
            XMLStreamReader reader = inputFactory.createXMLStreamReader(input, encoding);
            this.readOfx(reader);
        }
        catch (IOException | XMLStreamException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        logger.exiting(OfxV2Parser.class.getName(), "parse");
    }

    public void parse(File file) throws FileNotFoundException {
        try (FileInputStream stream = new FileInputStream(file);){
            this.parse(stream);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    public void parse(String string, String encoding) {
        this.parse(new ByteArrayInputStream(string.getBytes()), encoding);
    }

    public void parse(String string) {
        this.parse(new ByteArrayInputStream(string.getBytes()));
    }

    private void readOfx(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "readOfx");
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "SIGNONMSGSRSV1": {
                            OfxV2Parser.parseSignonMessageSet(reader);
                            break block0;
                        }
                        case "BANKMSGSRSV1": {
                            this.parseBankMessageSet(reader);
                            break block0;
                        }
                        case "CREDITCARDMSGSRSV1": {
                            this.parseCreditCardMessageSet(reader);
                        }
                    }
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "readOfx");
    }

    private void parseBankMessageSet(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseBankMessageSet");
        QName parsingElement = reader.getName();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "CURDEF": {
                            this.bank.currency = reader.getElementText();
                            break block0;
                        }
                        case "LEDGERBAL": {
                            this.parseLedgerBalance(reader);
                            break block0;
                        }
                        case "AVAILBAL": {
                            this.parseAvailableBalance(reader);
                            break block0;
                        }
                        case "BANKACCTFROM": {
                            this.parseAccountInfo(reader);
                            break block0;
                        }
                        case "BANKTRANLIST": {
                            this.parseBankTransactionList(reader);
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the bank message set aggregate");
                    break;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseBankMessageSet");
    }

    private void parseCreditCardMessageSet(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseCreditCardMessageSet");
        QName parsingElement = reader.getName();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "CURDEF": {
                            this.bank.currency = reader.getElementText();
                            break block0;
                        }
                        case "LEDGERBAL": {
                            this.parseLedgerBalance(reader);
                            break block0;
                        }
                        case "AVAILBAL": {
                            this.parseAvailableBalance(reader);
                            break block0;
                        }
                        case "CCACCTFROM": {
                            this.parseAccountInfo(reader);
                            break block0;
                        }
                        case "BANKTRANLIST": {
                            this.parseBankTransactionList(reader);
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the credit card message set aggregate");
                    break;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseCreditCardMessageSet");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseBankTransactionList(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseBankTransactionList");
        QName parsingElement = reader.getName();
        block14: while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "DTSTART": {
                            this.bank.dateStart = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                        case "DTEND": {
                            this.bank.dateEnd = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                        case "STMTTRN": {
                            this.parseBankTransaction(reader);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the bank transaction list");
                    break block14;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseBankTransactionList");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseBankTransaction(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseBankTransaction");
        QName parsingElement = reader.getName();
        OfxTransaction tran = new OfxTransaction();
        block34: while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "TRNTYPE": {
                            tran.transactionType = reader.getElementText();
                            break block0;
                        }
                        case "DTPOSTED": {
                            tran.datePosted = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                        case "DTUSER": {
                            tran.dateUser = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                        case "TRNAMT": {
                            tran.amount = OfxV2Parser.parseAmount(reader.getElementText());
                            break block0;
                        }
                        case "FITID": {
                            tran.transactionID = reader.getElementText();
                            break block0;
                        }
                        case "CHECKNUM": {
                            tran.checkNumber = reader.getElementText();
                            break block0;
                        }
                        case "NAME": {
                            tran.payee = reader.getElementText().replaceAll(EXTRA_SPACE_REGEX, " ").trim();
                            break block0;
                        }
                        case "MEMO": {
                            tran.memo = reader.getElementText().replaceAll(EXTRA_SPACE_REGEX, " ").trim();
                            break block0;
                        }
                        case "SIC": {
                            tran.sic = reader.getElementText();
                            break block0;
                        }
                        case "REFNUM": {
                            tran.refNum = reader.getElementText();
                            break block0;
                        }
                        case "PAYEEID": {
                            tran.payeeId = reader.getElementText().replaceAll(EXTRA_SPACE_REGEX, " ").trim();
                            break block0;
                        }
                        case "CURRENCY": {
                            tran.currency = reader.getElementText();
                            break block0;
                        }
                        case "ORIGCURRENCY": {
                            tran.currency = reader.getElementText();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the banktransaction");
                    break block34;
                }
            }
        }
        this.bank.addTransaction(tran);
        logger.exiting(OfxV2Parser.class.getName(), "parseBankTransaction");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseAccountInfo(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseAccountInfo");
        QName parsingElement = reader.getName();
        block16: while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "BANKID": {
                            this.bank.bankId = reader.getElementText();
                            break block0;
                        }
                        case "ACCTID": {
                            this.bank.accountId = reader.getElementText();
                            break block0;
                        }
                        case "ACCTTYPE": {
                            this.bank.accountType = reader.getElementText();
                            break block0;
                        }
                        case "BRANCHID": {
                            this.bank.branchId = reader.getElementText();
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the bank and account info aggregate");
                    break block16;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseAccountInfo");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseLedgerBalance(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseLedgerBalance");
        QName parsingElement = reader.getName();
        block12: while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "BALAMT": {
                            this.bank.ledgerBalance = OfxV2Parser.parseAmount(reader.getElementText());
                            break block0;
                        }
                        case "DTASOF": {
                            this.bank.ledgerBalanceDate = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the ledger balance aggregate");
                    break block12;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseLedgerBalance");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseAvailableBalance(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseAvailableBalance");
        QName parsingElement = reader.getName();
        block12: while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "BALAMT": {
                            this.bank.ledgerBalance = OfxV2Parser.parseAmount(reader.getElementText());
                            break block0;
                        }
                        case "DTASOF": {
                            this.bank.ledgerBalanceDate = OfxV2Parser.parseDate(reader.getElementText());
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getName().equals(parsingElement)) break;
                    logger.info("Found the end of the ledger balance aggregate");
                    break block12;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseAvailableBalance");
    }

    private static void parseSignonMessageSet(XMLStreamReader reader) throws XMLStreamException {
        logger.entering(OfxV2Parser.class.getName(), "parseSignonMessageSet");
        QName parsingElement = reader.getName();
        block3: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 2: {
                    if (reader.getName().equals(parsingElement)) {
                        logger.info("Found the end of the sign-on message set aggregate");
                        break block3;
                    }
                }
                default: {
                    continue block3;
                }
            }
        }
        logger.exiting(OfxV2Parser.class.getName(), "parseSignonMessageSet");
    }

    public OfxBank getBank() {
        return this.bank;
    }

    private static Date parseDate(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, 0, 0, 0);
        return calendar.getTime();
    }

    private static BigDecimal parseAmount(String amount) {
        try {
            return new BigDecimal(amount.trim());
        }
        catch (NumberFormatException e) {
            logger.log(Level.INFO, "Parse amount was: {0}", amount);
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return BigDecimal.ZERO;
        }
    }
}

