/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.qif;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

class QifReader
extends LineNumberReader {
    private static boolean debug = false;

    public QifReader(Reader in) {
        super(in, 8192);
    }

    public void mark() throws IOException {
        super.mark(256);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        if (debug) {
            System.out.println("Reset");
        }
    }

    public String peekLine() throws IOException {
        block1: {
            String peek;
            while (true) {
                this.mark();
                peek = this.readLine();
                if (peek == null) break block1;
                peek = peek.trim();
                this.reset();
                if (peek.length() != 0) break;
                this.readLine();
                if (!debug) continue;
                System.out.println("*EMPTY LINE*");
            }
            return peek.trim();
        }
        return null;
    }

    @Override
    public String readLine() throws IOException {
        try {
            while (true) {
                String line = super.readLine().trim();
                if (debug) {
                    System.out.println("Line " + this.getLineNumber() + ": " + line);
                }
                if (line.length() > 0) {
                    return line;
                }
                if (!debug) continue;
                System.out.println("*EMPTY LINE*");
            }
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

