/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.logging.Logger;
import jgnash.engine.CommodityNode;
import jgnash.engine.ExchangeRateDAO;
import jgnash.engine.MathConstants;

public class CurrencyNode
extends CommodityNode {
    private static final long serialVersionUID = 1339921229356331512L;
    private Locale locale = Locale.getDefault();
    private transient ExchangeRateDAO exchangeRateDAO;

    private synchronized ExchangeRateDAO getExchangeRateDAO() {
        return this.exchangeRateDAO;
    }

    synchronized void setExchangeRateDAO(ExchangeRateDAO exchangeRateStore) {
        this.exchangeRateDAO = exchangeRateStore;
    }

    public synchronized BigDecimal getExchangeRate(CurrencyNode exchangeCurrency) {
        if (exchangeCurrency == null) {
            Logger.getLogger(CurrencyNode.class.getName()).severe("exchangeCurrency was null");
            return BigDecimal.ONE;
        }
        if (exchangeCurrency.equals(this)) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = this.getExchangeRateDAO().getExchangeRateNode(this, exchangeCurrency).getRate();
        if (this.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) < 0) {
            rate = BigDecimal.ONE.divide(rate, MathConstants.mathContext);
        }
        return rate;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.locale = Locale.getDefault();
        return this;
    }

    protected Object readResolve() {
        this.locale = Locale.getDefault();
        return this;
    }
}

