/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jgnash.engine.Transaction;
import jgnash.util.SearchUtils;

public class SearchEngine {
    private SearchEngine() {
    }

    public static List<Transaction> matchMemo(String pattern, Collection<Transaction> transactions, boolean caseSensitive) {
        ArrayList<Transaction> match = new ArrayList<Transaction>();
        Pattern p = SearchUtils.createSearchPattern(pattern, caseSensitive);
        for (Transaction t : transactions) {
            Matcher m = p.matcher(t.getMemo());
            if (!m.matches()) continue;
            match.add(t);
        }
        return match;
    }

    public static List<Transaction> matchPayee(String pattern, Collection<Transaction> transactions, boolean caseSensitive) {
        ArrayList<Transaction> match = new ArrayList<Transaction>();
        Pattern p = SearchUtils.createSearchPattern(pattern, caseSensitive);
        for (Transaction t : transactions) {
            Matcher m = p.matcher(t.getPayee());
            if (!m.matches()) continue;
            match.add(t);
        }
        return match;
    }
}

