/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.util.DateUtils;

public final class BudgetPeriodDescriptorFactory {
    private static Map<String, List<BudgetPeriodDescriptor>> cache = new HashMap<String, List<BudgetPeriodDescriptor>>();
    private static ReadWriteLock rwl = new ReentrantReadWriteLock(false);

    private BudgetPeriodDescriptorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BudgetPeriodDescriptor> getDescriptors(int budgetYear, BudgetPeriod budgetPeriod) {
        String cacheKey = budgetYear + budgetPeriod.name();
        List<BudgetPeriodDescriptor> descriptors = null;
        rwl.readLock().lock();
        try {
            descriptors = cache.get(cacheKey);
        }
        finally {
            rwl.readLock().unlock();
        }
        if (descriptors == null) {
            Date[] dates = new Date[]{};
            switch (budgetPeriod) {
                case DAILY: {
                    dates = DateUtils.getAllDays(budgetYear);
                    break;
                }
                case WEEKLY: {
                    dates = DateUtils.getFirstDayWeekly(budgetYear);
                    break;
                }
                case BI_WEEKLY: {
                    dates = DateUtils.getFirstDayBiWeekly(budgetYear);
                    break;
                }
                case MONTHLY: {
                    dates = DateUtils.getFirstDayMonthly(budgetYear);
                    break;
                }
                case QUARTERLY: {
                    dates = DateUtils.getFirstDayQuarterly(budgetYear);
                    break;
                }
                case YEARLY: {
                    Date date = DateUtils.getDateOfTheYear(budgetYear, 1);
                    dates = new Date[]{date};
                }
            }
            descriptors = new ArrayList<BudgetPeriodDescriptor>(dates.length);
            for (Date date : dates) {
                int day = DateUtils.getDayOfTheYear(date) - 1;
                descriptors.add(new BudgetPeriodDescriptor(budgetYear, budgetPeriod, day));
            }
            rwl.writeLock().lock();
            try {
                cache.put(cacheKey, descriptors);
            }
            finally {
                rwl.writeLock().unlock();
            }
        }
        return descriptors;
    }
}

