/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.MathConstants;
import jgnash.engine.Transaction;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.engine.budget.BudgetPeriodResults;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.message.MessageProxy;

public class BudgetResultsModel
implements MessageListener {
    private Set<Account> accounts = new HashSet<Account>();
    private Budget budget;
    private CurrencyNode baseCurrency;
    private List<AccountGroup> accountGroupList;
    private List<BudgetPeriodDescriptor> descriptorList;
    private ReentrantReadWriteLock accountLock = new ReentrantReadWriteLock();
    private ReentrantLock cacheLock = new ReentrantLock();
    private Map<Account, BudgetPeriodResults> accountResultsCache;
    private Map<AccountGroup, BudgetPeriodResults> accountGroupResultsCache;
    private Map<BudgetPeriodDescriptor, Map<Account, BudgetPeriodResults>> descriptorAccountResultsCache;
    private Map<BudgetPeriodDescriptor, Map<AccountGroup, BudgetPeriodResults>> descriptorAccountGroupResultsCache;
    private MessageProxy proxy = new MessageProxy();

    public BudgetResultsModel(Budget budget, int year, CurrencyNode baseCurrency) {
        this.budget = budget;
        this.descriptorList = BudgetPeriodDescriptorFactory.getDescriptors(year, this.budget.getBudgetPeriod());
        this.baseCurrency = baseCurrency;
        this.accountResultsCache = new HashMap<Account, BudgetPeriodResults>();
        this.accountGroupResultsCache = new EnumMap<AccountGroup, BudgetPeriodResults>(AccountGroup.class);
        this.descriptorAccountResultsCache = new HashMap<BudgetPeriodDescriptor, Map<Account, BudgetPeriodResults>>();
        this.descriptorAccountGroupResultsCache = new HashMap<BudgetPeriodDescriptor, Map<AccountGroup, BudgetPeriodResults>>();
        this.loadAccounts();
        this.loadAccountGroups();
        this.registerListeners();
    }

    public Budget getBudget() {
        return this.budget;
    }

    public CurrencyNode getBaseCurrency() {
        return this.baseCurrency;
    }

    public int getDepth(Account account) {
        int depth = 0;
        for (Account parent = account.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.accounts.contains(parent)) continue;
            ++depth;
        }
        return depth;
    }

    public List<BudgetPeriodDescriptor> getDescriptorList() {
        return this.descriptorList;
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.BUDGET, MessageChannel.SYSTEM, MessageChannel.TRANSACTION);
    }

    private void unregisterListeners() {
        MessageBus.getInstance().unregisterListener(this, MessageChannel.ACCOUNT, MessageChannel.BUDGET, MessageChannel.SYSTEM, MessageChannel.TRANSACTION);
    }

    public synchronized void addMessageListener(MessageListener messageListener) {
        this.proxy.addMessageListener(messageListener);
    }

    public synchronized void removeMessageListener(MessageListener messageListener) {
        this.proxy.removeMessageListener(messageListener);
    }

    public boolean includeAccount(Account account) {
        boolean result = false;
        if (account.isVisible() && !account.isExcludedFromBudget()) {
            if (account.memberOf(AccountGroup.INCOME) && this.budget.areIncomeAccountsIncluded()) {
                result = true;
            } else if (account.memberOf(AccountGroup.EXPENSE) && this.budget.areExpenseAccountsIncluded()) {
                result = true;
            } else if (account.memberOf(AccountGroup.ASSET) && this.budget.areAssetAccountsIncluded()) {
                result = true;
            } else if (account.memberOf(AccountGroup.LIABILITY) && this.budget.areLiabilityAccountsIncluded()) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccounts() {
        Engine engine = EngineFactory.getEngine("default");
        HashSet<Account> accountSet = new HashSet<Account>();
        for (Account account : engine.getAccountList()) {
            if (!this.includeAccount(account)) continue;
            accountSet.add(account);
        }
        this.accountLock.writeLock().lock();
        try {
            this.accounts = accountSet;
        }
        finally {
            this.accountLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccountGroups() {
        this.accountLock.writeLock().lock();
        try {
            EnumSet<AccountGroup> accountSet = EnumSet.noneOf(AccountGroup.class);
            for (Account account : this.accounts) {
                accountSet.add(account.getAccountType().getAccountGroup());
            }
            ArrayList<AccountGroup> groups = new ArrayList<AccountGroup>(accountSet);
            Collections.sort(groups);
            this.accountGroupList = groups;
        }
        finally {
            this.accountLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountGroup> getAccountGroupList() {
        this.accountLock.readLock().lock();
        try {
            List<AccountGroup> list = this.accountGroupList;
            return list;
        }
        finally {
            this.accountLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Account> getAccounts() {
        this.accountLock.readLock().lock();
        try {
            HashSet<Account> hashSet = new HashSet<Account>(this.accounts);
            return hashSet;
        }
        finally {
            this.accountLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Account> getAccounts(AccountGroup group) {
        this.accountLock.readLock().lock();
        try {
            HashSet<Account> accountSet = new HashSet<Account>();
            for (Account account : this.accounts) {
                if (!account.memberOf(group)) continue;
                accountSet.add(account);
            }
            HashSet<Account> hashSet = accountSet;
            return hashSet;
        }
        finally {
            this.accountLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults getResults(BudgetPeriodDescriptor descriptor, Account account) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results;
            Map<Account, BudgetPeriodResults> resultsMap = this.descriptorAccountResultsCache.get(descriptor);
            if (resultsMap == null) {
                resultsMap = new HashMap<Account, BudgetPeriodResults>();
                this.descriptorAccountResultsCache.put(descriptor, resultsMap);
            }
            if ((results = resultsMap.get(account)) == null) {
                results = this.buildAccountResults(descriptor, account);
                resultsMap.put(account, results);
            }
            BudgetPeriodResults budgetPeriodResults = results;
            return budgetPeriodResults;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(BudgetPeriodDescriptor descriptor, Account account) {
        this.cacheLock.lock();
        try {
            Map<Account, BudgetPeriodResults> resultsMap = this.descriptorAccountResultsCache.get(descriptor);
            if (resultsMap != null) {
                resultsMap.remove(account);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCached() {
        this.cacheLock.lock();
        try {
            this.accountResultsCache.clear();
            this.accountGroupResultsCache.clear();
            this.descriptorAccountResultsCache.clear();
            this.descriptorAccountGroupResultsCache.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults getResults(BudgetPeriodDescriptor descriptor, AccountGroup group) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results;
            Map<AccountGroup, BudgetPeriodResults> resultsMap = this.descriptorAccountGroupResultsCache.get(descriptor);
            if (resultsMap == null) {
                resultsMap = new EnumMap<AccountGroup, BudgetPeriodResults>(AccountGroup.class);
                this.descriptorAccountGroupResultsCache.put(descriptor, resultsMap);
            }
            if ((results = resultsMap.get((Object)group)) == null) {
                results = this.buildResults(descriptor, group);
                resultsMap.put(group, results);
            }
            BudgetPeriodResults budgetPeriodResults = results;
            return budgetPeriodResults;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(BudgetPeriodDescriptor descriptor, AccountGroup group) {
        this.cacheLock.lock();
        try {
            Map<AccountGroup, BudgetPeriodResults> resultsMap = this.descriptorAccountGroupResultsCache.get(descriptor);
            if (resultsMap != null) {
                resultsMap.remove((Object)group);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults getResults(Account account) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results = this.accountResultsCache.get(account);
            if (results == null) {
                results = this.buildResults(account);
                this.accountResultsCache.put(account, results);
            }
            BudgetPeriodResults budgetPeriodResults = results;
            return budgetPeriodResults;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(Account account) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results = this.accountResultsCache.get(account);
            if (results != null) {
                this.accountResultsCache.remove(account);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults getResults(AccountGroup accountGroup) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results = this.accountGroupResultsCache.get((Object)accountGroup);
            if (results == null) {
                results = this.buildResults(accountGroup);
                this.accountGroupResultsCache.put(accountGroup, results);
            }
            BudgetPeriodResults budgetPeriodResults = results;
            return budgetPeriodResults;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(AccountGroup accountGroup) {
        this.cacheLock.lock();
        try {
            BudgetPeriodResults results = this.accountGroupResultsCache.get((Object)accountGroup);
            if (results != null) {
                this.accountGroupResultsCache.remove((Object)accountGroup);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BudgetPeriodResults buildAccountResults(BudgetPeriodDescriptor descriptor, Account account) {
        BudgetPeriodResults results = new BudgetPeriodResults();
        this.accountLock.readLock().lock();
        try {
            if (this.accounts.contains(account)) {
                BudgetGoal goal = this.budget.getBudgetGoal(account);
                results.setBudgeted(goal.getGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod()));
                results.setChange(account.getBalance(descriptor.getStartDate(), descriptor.getEndDate()).abs());
                BigDecimal remaining = results.getBudgeted().subtract(results.getChange());
                if (account.getAccountType() == AccountType.INCOME) {
                    remaining = remaining.negate();
                }
                results.setRemaining(remaining);
            }
            for (Account child : account.getChildren()) {
                BudgetPeriodResults childResults = this.buildAccountResults(descriptor, child);
                BigDecimal exchangeRate = child.getCurrencyNode().getExchangeRate(account.getCurrencyNode());
                results.setChange(results.getChange().add(childResults.getChange().multiply(exchangeRate)));
                results.setBudgeted(results.getBudgeted().add(childResults.getBudgeted().multiply(exchangeRate)));
                results.setRemaining(results.getRemaining().add(childResults.getRemaining().multiply(exchangeRate)));
            }
        }
        finally {
            this.accountLock.readLock().unlock();
        }
        results.setChange(results.getChange().setScale((int)account.getCurrencyNode().getScale(), MathConstants.roundingMode));
        results.setBudgeted(results.getBudgeted().setScale((int)account.getCurrencyNode().getScale(), MathConstants.roundingMode));
        results.setRemaining(results.getRemaining().setScale((int)account.getCurrencyNode().getScale(), MathConstants.roundingMode));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BudgetPeriodResults buildResults(BudgetPeriodDescriptor descriptor, AccountGroup group) {
        BigDecimal remainingTotal = BigDecimal.ZERO;
        BigDecimal totalChange = BigDecimal.ZERO;
        BigDecimal totalBudgeted = BigDecimal.ZERO;
        this.accountLock.readLock().lock();
        try {
            for (Account account : this.getAccounts(group)) {
                if (this.accounts.contains(account.getParent())) continue;
                BudgetPeriodResults periodResults = this.getResults(descriptor, account);
                BigDecimal remaining = periodResults.getRemaining();
                remainingTotal = remainingTotal.add(remaining.multiply(this.baseCurrency.getExchangeRate(account.getCurrencyNode())));
                BigDecimal change = periodResults.getChange();
                totalChange = totalChange.add(change.multiply(this.baseCurrency.getExchangeRate(account.getCurrencyNode())));
                BigDecimal budgeted = periodResults.getBudgeted();
                totalBudgeted = totalBudgeted.add(budgeted.multiply(this.baseCurrency.getExchangeRate(account.getCurrencyNode())));
            }
        }
        finally {
            this.accountLock.readLock().unlock();
        }
        BudgetPeriodResults results = new BudgetPeriodResults();
        results.setBudgeted(totalBudgeted.setScale((int)this.baseCurrency.getScale(), MathConstants.roundingMode));
        results.setRemaining(remainingTotal.setScale((int)this.baseCurrency.getScale(), MathConstants.roundingMode));
        results.setChange(totalChange.setScale((int)this.baseCurrency.getScale(), MathConstants.roundingMode));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults buildResults(Account account) {
        BigDecimal change = BigDecimal.ZERO;
        BigDecimal budgeted = BigDecimal.ZERO;
        BigDecimal remaining = BigDecimal.ZERO;
        this.accountLock.readLock().lock();
        try {
            for (BudgetPeriodDescriptor descriptor : this.descriptorList) {
                BudgetPeriodResults periodResults = this.getResults(descriptor, account);
                change = change.add(periodResults.getChange());
                budgeted = budgeted.add(periodResults.getBudgeted());
                remaining = remaining.add(periodResults.getRemaining());
            }
        }
        finally {
            this.accountLock.readLock().unlock();
        }
        BudgetPeriodResults results = new BudgetPeriodResults();
        results.setChange(change);
        results.setBudgeted(budgeted);
        results.setRemaining(remaining);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BudgetPeriodResults buildResults(AccountGroup group) {
        BigDecimal totalChange = BigDecimal.ZERO;
        BigDecimal totalBudgeted = BigDecimal.ZERO;
        BigDecimal totalRemaining = BigDecimal.ZERO;
        this.accountLock.readLock().lock();
        try {
            for (BudgetPeriodDescriptor descriptor : this.descriptorList) {
                BudgetPeriodResults periodResults = this.getResults(descriptor, group);
                totalChange = totalChange.add(periodResults.getChange());
                totalBudgeted = totalBudgeted.add(periodResults.getBudgeted());
                totalRemaining = totalRemaining.add(periodResults.getRemaining());
            }
        }
        finally {
            this.accountLock.readLock().unlock();
        }
        BudgetPeriodResults results = new BudgetPeriodResults();
        results.setChange(totalChange);
        results.setBudgeted(totalBudgeted);
        results.setRemaining(totalRemaining);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCached(Account account) {
        this.accountLock.readLock().lock();
        try {
            this.cacheLock.lock();
            try {
                for (Account ancestor : account.getAncestors()) {
                    if (!this.accounts.contains(ancestor)) continue;
                    for (BudgetPeriodDescriptor descriptor : this.descriptorList) {
                        this.clear(ancestor);
                        this.clear(descriptor, ancestor);
                        this.clear(ancestor.getAccountType().getAccountGroup());
                        this.clear(descriptor, ancestor.getAccountType().getAccountGroup());
                    }
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        finally {
            this.accountLock.readLock().unlock();
        }
    }

    private void processAccountEvent(Message message) {
        Account account = (Account)message.getObject(MessageProperty.ACCOUNT);
        switch (message.getEvent()) {
            case ACCOUNT_ADD: {
                this.accounts.add(account);
                this.clearCached(account);
                break;
            }
            case ACCOUNT_REMOVE: {
                this.accounts.remove(account);
                this.clearCached(account);
                break;
            }
            case ACCOUNT_MODIFY: {
                this.loadAccounts();
                this.clearCached();
                break;
            }
        }
        this.loadAccountGroups();
    }

    private void processBudgetEvent(Message message) {
        Budget messageBudget = (Budget)message.getObject(MessageProperty.BUDGET);
        if (this.budget.equals(messageBudget)) {
            switch (message.getEvent()) {
                case BUDGET_UPDATE: {
                    this.clearCached();
                    break;
                }
                case BUDGET_GOAL_UPDATE: {
                    Account account = (Account)message.getObject(MessageProperty.ACCOUNT);
                    this.clearCached(account);
                    break;
                }
                case BUDGET_REMOVE: {
                    this.unregisterListeners();
                    this.clearCached();
                    break;
                }
            }
        }
    }

    private void processTransactionEvent(Message message) {
        Transaction transaction = (Transaction)message.getObject(MessageProperty.TRANSACTION);
        for (BudgetPeriodDescriptor descriptor : this.descriptorList) {
            if (!descriptor.isBetween(transaction.getDate())) continue;
            HashSet<Account> accountSet = new HashSet<Account>();
            for (Account account : transaction.getAccounts()) {
                accountSet.addAll(account.getAncestors());
            }
            for (Account account : accountSet) {
                this.clearCached(account);
            }
        }
    }

    @Override
    public void messagePosted(Message message) {
        switch (message.getEvent()) {
            case ACCOUNT_ADD: 
            case ACCOUNT_MODIFY: 
            case ACCOUNT_MODIFY_FAILED: {
                this.processAccountEvent(message);
                break;
            }
            case BUDGET_UPDATE: 
            case BUDGET_GOAL_UPDATE: 
            case BUDGET_REMOVE: {
                this.processBudgetEvent(message);
                break;
            }
            case TRANSACTION_ADD: 
            case TRANSACTION_REMOVE: {
                this.processTransactionEvent(message);
                break;
            }
            case FILE_CLOSING: {
                this.unregisterListeners();
                this.clearCached();
                break;
            }
        }
        this.proxy.forwardMessage(message);
    }
}

