/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.checks;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.checks.CheckLayout;
import jgnash.engine.checks.CheckObject;
import jgnash.util.OS;

public class CheckLayoutSerializationFactory {
    public static CheckLayout loadLayout(String file) {
        XStream xstream = CheckLayoutSerializationFactory.getStream();
        CheckLayout layout = null;
        try (FileReader in = new FileReader(file);){
            layout = (CheckLayout)xstream.fromXML((Reader)in);
        }
        catch (IOException e) {
            Logger.getLogger(CheckLayoutSerializationFactory.class.getName()).log(Level.SEVERE, null, e);
        }
        return layout;
    }

    public static boolean saveLayout(String file, CheckLayout layout) {
        boolean result = false;
        XStream xstream = CheckLayoutSerializationFactory.getStream();
        try (FileWriter out = new FileWriter(file);){
            xstream.toXML((Object)layout, (Writer)out);
            result = true;
        }
        catch (IOException e) {
            Logger.getLogger(CheckLayoutSerializationFactory.class.getName()).log(Level.SEVERE, null, e);
        }
        return result;
    }

    private static XStream getStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.alias("CheckLayout", CheckLayout.class);
        xstream.alias("CheckObject", CheckObject.class);
        if (OS.isSystemWindows()) {
            try {
                Class<?> media = Class.forName("sun.print.Win32MediaTray");
                xstream.omitField(media, "value");
                xstream.omitField(media, "winID");
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(CheckLayoutSerializationFactory.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return xstream;
    }

    private CheckLayoutSerializationFactory() {
    }
}

