/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.dao.TransactionDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;

class Db4oTransactionDAO
extends AbstractDb4oDAO
implements TransactionDAO {
    private static final Logger logger = Logger.getLogger(Db4oTransactionDAO.class.getName());

    Db4oTransactionDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
        logger.setLevel(Level.ALL);
    }

    @Override
    public synchronized List<Transaction> getTransactions() {
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            ObjectSet list = this.container.query(Transaction.class);
            this.container.ext().releaseSemaphore("Lock");
            ArrayList<Transaction> resultList = new ArrayList<Transaction>(list.size());
            for (Transaction t : list) {
                if (t.isMarkedForRemoval()) continue;
                resultList.add(t);
            }
            return resultList;
        }
        logger.severe("Could not obtain global semaphore");
        return Collections.emptyList();
    }

    @Override
    public synchronized void refreshTransaction(Transaction transaction) {
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            this.container.ext().refresh((Object)transaction, 4);
            this.container.ext().releaseSemaphore("Lock");
        } else {
            logger.severe("Could not obtain global semaphore");
        }
    }

    @Override
    public synchronized boolean addTransaction(Transaction transaction) {
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            List<TransactionEntry> entries = transaction.getTransactionEntries();
            Set<Account> accounts = transaction.getAccounts();
            for (TransactionEntry entry : entries) {
                this.container.set((Object)entry);
            }
            for (Account account : accounts) {
                this.container.set((Object)account);
            }
            this.container.set((Object)transaction);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            return true;
        }
        logger.severe("Could not obtain global semaphore");
        return false;
    }

    @Override
    public synchronized boolean removeTransaction(Transaction transaction) {
        if (this.container.ext().setSemaphore("Lock", SEMAPHORE_WAIT_TIME)) {
            Set<Account> accounts = transaction.getAccounts();
            for (Account account : accounts) {
                this.container.set((Object)account);
            }
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            return true;
        }
        logger.severe("Could not obtain global semaphore");
        return false;
    }
}

