/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.recurring;

import java.util.Calendar;
import java.util.Date;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.ReminderType;
import jgnash.util.DateUtils;

public class WeeklyReminder
extends Reminder {
    private static final long serialVersionUID = -1083131503417503307L;

    @Override
    public ReminderType getReminderType() {
        return ReminderType.WEEKLY;
    }

    @Override
    public RecurringIterator getIterator() {
        return new WeeklyIterator();
    }

    private class WeeklyIterator
    implements RecurringIterator {
        private final Calendar calendar = Calendar.getInstance();

        public WeeklyIterator() {
            if (WeeklyReminder.this.getLastDate() != null) {
                this.calendar.setTime(WeeklyReminder.this.getLastDate());
            } else {
                this.calendar.setTime(WeeklyReminder.this.getStartDate());
                this.calendar.add(4, WeeklyReminder.this.getIncrement() * -1);
            }
        }

        @Override
        public Date next() {
            this.calendar.add(4, WeeklyReminder.this.getIncrement());
            Date date = this.calendar.getTime();
            if (WeeklyReminder.this.getEndDate() == null) {
                return date;
            }
            if (DateUtils.before(date, WeeklyReminder.this.getEndDate())) {
                return date;
            }
            return null;
        }
    }
}

