/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.message.LocalServerListener;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class MessageBusRemoteServer {
    private int port = 0;
    private IoAcceptor acceptor;
    private static final Logger logger = Logger.getLogger(MessageBusRemoteServer.class.getName());
    private Set<IoSession> clientSessions = new HashSet<IoSession>();
    private Set<LocalServerListener> listeners = new HashSet<LocalServerListener>();
    private ReadWriteLock rwl = new ReentrantReadWriteLock(true);

    public MessageBusRemoteServer(int port) {
        this.port = port;
    }

    public void startServer() {
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("UTF-8"))));
        this.acceptor.setHandler((IoHandler)new MessageHandler());
        try {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        logger.info("MessageBusRemoteServer started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.rwl.writeLock().lock();
        try {
            for (IoSession client : this.clientSessions) {
                client.close(true);
            }
            this.acceptor.unbind();
            this.listeners.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalListener(LocalServerListener listener) {
        this.rwl.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalListener(LocalServerListener listener) {
        this.rwl.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    static {
        IoBuffer.setUseDirectBuffer((boolean)false);
        IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
    }

    private class MessageHandler
    extends IoHandlerAdapter {
        private MessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionCaught(IoSession session, Throwable t) throws Exception {
            logger.log(Level.SEVERE, null, t);
            MessageBusRemoteServer.this.rwl.writeLock().lock();
            try {
                session.close(true);
                MessageBusRemoteServer.this.clientSessions.remove(session);
            }
            finally {
                MessageBusRemoteServer.this.rwl.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionIdle(IoSession session, IdleStatus status) {
            logger.info("Disconnecting the idle client.");
            MessageBusRemoteServer.this.rwl.writeLock().lock();
            try {
                session.close(true);
                MessageBusRemoteServer.this.clientSessions.remove(session);
            }
            finally {
                MessageBusRemoteServer.this.rwl.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoSession session, Object message) throws Exception {
            String str = message.toString();
            MessageBusRemoteServer.this.rwl.readLock().lock();
            try {
                for (IoSession client : MessageBusRemoteServer.this.clientSessions) {
                    if (!client.isConnected()) continue;
                    client.write((Object)str);
                }
                for (LocalServerListener listener : MessageBusRemoteServer.this.listeners) {
                    listener.messagePosted(str);
                }
            }
            finally {
                MessageBusRemoteServer.this.rwl.readLock().unlock();
            }
            logger.log(Level.INFO, "Broadcast: {0}", str);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionCreated(IoSession session) throws Exception {
            MessageBusRemoteServer.this.rwl.writeLock().lock();
            try {
                MessageBusRemoteServer.this.clientSessions.add(session);
            }
            finally {
                MessageBusRemoteServer.this.rwl.writeLock().unlock();
            }
        }
    }
}

