/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jgnash.engine.SecurityNode;
import jgnash.net.ConnectionFactory;
import jgnash.net.security.SecurityParser;

public abstract class AbstractYahooParser
implements SecurityParser {
    private static final Logger logger = Logger.getLogger(AbstractYahooParser.class.getName());
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile(",");
    private long volume;
    private BigDecimal price;
    private BigDecimal high;
    private BigDecimal low;

    @Override
    public synchronized long getVolume() {
        return this.volume;
    }

    private synchronized void setVolume(long volume) {
        this.volume = volume;
    }

    @Override
    public synchronized BigDecimal getPrice() {
        return this.price;
    }

    private synchronized void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Override
    public synchronized BigDecimal getHigh() {
        return this.high;
    }

    private synchronized void setHigh(BigDecimal high) {
        this.high = high;
    }

    @Override
    public synchronized BigDecimal getLow() {
        return this.low;
    }

    private synchronized void setLow(BigDecimal low) {
        this.low = low;
    }

    protected abstract String getBaseURL();

    protected abstract boolean useISIN();

    @Override
    public synchronized boolean parse(SecurityNode node) throws IOException {
        boolean result = false;
        String base = this.getBaseURL();
        String symbol = this.useISIN() ? node.getISIN() : node.getSymbol();
        String u = base + symbol + "&f=sl1d1t1c1ohgv&e=.csv";
        String line = null;
        URLConnection connection = ConnectionFactory.getConnection(u);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            line = in.readLine();
            if (line != null) {
                line = line.trim();
                String[] fields = COMMA_DELIMITER_PATTERN.split(line);
                in.close();
                if (fields.length >= 7) {
                    if (!fields[1].contains("%")) {
                        this.setPrice(new BigDecimal(fields[1]));
                    }
                    if (fields[6].equals("N/A")) {
                        this.setHigh(BigDecimal.ZERO);
                    } else {
                        this.setHigh(new BigDecimal(fields[6]));
                    }
                    if (fields[7].equals("N/A")) {
                        this.setLow(BigDecimal.ZERO);
                    } else {
                        this.setLow(new BigDecimal(fields[7]));
                    }
                    if (fields[8].equals("N/A")) {
                        this.setVolume(0L);
                    } else {
                        this.setVolume(Long.parseLong(fields[8]));
                    }
                    result = true;
                }
            }
        }
        catch (SocketTimeoutException e) {
            this.price = null;
            logger.warning("Network timeout");
        }
        catch (UnknownHostException e) {
            this.price = null;
            logger.warning("Unknown host");
        }
        catch (NumberFormatException e) {
            logger.log(Level.SEVERE, line, e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
        return result;
    }
}

