/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jgnash.util.SearchUtils;

public final class FileUtils {
    private static final String FILEEXTREGEX = "(?<=\\.).*$";
    private static final Pattern FILE_EXTENSION_SPLIT_PATTERN = Pattern.compile("\\.");

    private FileUtils() {
    }

    public static boolean isFileLocked(String fileName) throws FileNotFoundException {
        boolean result = true;
        try (RandomAccessFile raf = new RandomAccessFile(new File(fileName), "rw");
             FileChannel channel = raf.getChannel();
             FileLock lock = channel.tryLock();){
            if (lock != null) {
                result = false;
            }
        }
        catch (IOException e) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, e.toString(), e);
        }
        return result;
    }

    public static String stripFileExtension(String fileName) {
        return FILE_EXTENSION_SPLIT_PATTERN.split(fileName)[0];
    }

    public static boolean fileHasExtension(String fileName) {
        return !FileUtils.stripFileExtension(fileName).equals(fileName);
    }

    public static String getFileExtension(String fileName) {
        String result = "";
        Pattern pattern = Pattern.compile(FILEEXTREGEX);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            result = matcher.group();
        }
        return result;
    }

    public static boolean copyFile(File src, File dst) {
        boolean result = false;
        if (src != null && dst != null && !src.equals(dst)) {
            try {
                Files.copy(src.toPath(), dst.toPath().getFileName(), StandardCopyOption.REPLACE_EXISTING);
                result = true;
            }
            catch (IOException e) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return result;
    }

    public static void compressFile(File source, File destination) {
        block64: {
            try (FileOutputStream fos = new FileOutputStream(destination);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);
                 FileLock fosLock = fos.getChannel().tryLock();){
                if (fosLock == null) break block64;
                try (FileInputStream in = new FileInputStream(source);
                     FileLock fisLock = in.getChannel().tryLock(0L, Long.MAX_VALUE, true);){
                    if (fisLock != null) {
                        int length;
                        zipOut.setLevel(9);
                        zipOut.putNextEntry(new ZipEntry(source.getName()));
                        byte[] ioBuffer = new byte[8192];
                        while ((length = in.read(ioBuffer)) > 0) {
                            zipOut.write(ioBuffer, 0, length);
                        }
                        zipOut.finish();
                        fosLock.release();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
    }

    public static List<File> getDirectoryListing(File directory, String pattern) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (directory != null && directory.isDirectory()) {
            final Pattern p = SearchUtils.createSearchPattern(pattern, false);
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return p.matcher(name).matches();
                }
            });
            fileList.addAll(Arrays.asList(files));
            Collections.sort(fileList);
        }
        return fileList;
    }
}

