/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.awt.Image;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import jgnash.util.EncodeDecode;
import jgnash.util.OS;

public class Resource {
    private ResourceBundle resourceBundle;
    private static final String LOCALE = "locale";
    private static final String DEFAULT_BUNDLE = "jgnash/resource/resource";
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    private static final Resource resource;

    private Resource() {
        this.loadBundle();
    }

    private void loadBundle() {
        try {
            this.resourceBundle = ResourceBundle.getBundle(DEFAULT_BUNDLE);
        }
        catch (MissingResourceException e) {
            this.resourceBundle = ResourceBundle.getBundle(DEFAULT_BUNDLE, Locale.ENGLISH);
            logger.warning("Could not find correct resource bundle");
        }
    }

    public static Resource get() {
        return resource;
    }

    public String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    public char getMnemonic(String key) {
        String value = this.getString(key);
        if (value == null || value.length() != 1) {
            logger.log(Level.WARNING, "The value ''{0}'' for key ''{1}'' is not valid.", new Object[]{value, key});
            return "".charAt(0);
        }
        return value.charAt(0);
    }

    public KeyStroke getKeyStroke(String key) {
        KeyStroke keyStroke;
        String value = this.getString(key);
        if (value != null && value.contains("control") && OS.isSystemOSX()) {
            value = value.replace("control", "meta");
        }
        if ((keyStroke = KeyStroke.getKeyStroke(value)) == null && value != null && value.length() != 0) {
            logger.log(Level.WARNING, "The value ''{0}'' for key ''{1}'' is not valid.", new Object[]{value, key});
        }
        return keyStroke;
    }

    public static ImageIcon getIcon(String icon) {
        return new ImageIcon(resource.getClass().getResource(icon));
    }

    public static Image getImage(String icon) {
        return Resource.getIcon(icon).getImage();
    }

    public static void setLocale(Locale l) {
        Locale.setDefault(l);
        Preferences p = Preferences.userNodeForPackage(Resource.class);
        p.put(LOCALE, EncodeDecode.encodeLocale(l));
        resource.loadBundle();
    }

    public static String getAppVersion() {
        ResourceBundle rb = ResourceBundle.getBundle("jgnash/resource/constants");
        return rb.getString("version");
    }

    public static String getAppName() {
        ResourceBundle rb = ResourceBundle.getBundle("jgnash/resource/constants");
        return rb.getString("name");
    }

    static {
        Preferences p = Preferences.userNodeForPackage(Resource.class);
        Locale.setDefault(EncodeDecode.decodeLocale(p.get(LOCALE, "")));
        resource = new Resource();
    }
}

