/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net.security;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingWorker;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.QuoteSource;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.net.security.SecurityParser;
import jgnash.ui.UIApplication;
import jgnash.util.Resource;

public class SecurityUpdateFactory {
    private static final int ABORT_COUNT = 2;
    private static final String UPDATE_ON_STARTUP = "updateOnStartup";
    private static final Logger logger = Logger.getLogger(SecurityUpdateFactory.class.getName());

    private SecurityUpdateFactory() {
    }

    public static void setUpdateOnStartup(boolean update) {
        Preferences pref = Preferences.userNodeForPackage(SecurityUpdateFactory.class);
        pref.putBoolean(UPDATE_ON_STARTUP, update);
    }

    public static boolean getUpdateOnStartup() {
        Preferences pref = Preferences.userNodeForPackage(SecurityUpdateFactory.class);
        return pref.getBoolean(UPDATE_ON_STARTUP, false);
    }

    public static boolean updateOne(SecurityNode node) {
        Resource rb = Resource.get();
        if (node.getQuoteSource() == QuoteSource.NONE) {
            return false;
        }
        SecurityParser parser = node.getQuoteSource().getParser();
        try {
            if (parser.parse(node)) {
                SecurityHistoryNode history = new SecurityHistoryNode();
                history.setPrice(parser.getPrice());
                history.setVolume(parser.getVolume());
                history.setHigh(parser.getHigh());
                history.setLow(parser.getLow());
                Engine e = EngineFactory.getEngine("default");
                if (e != null) {
                    e.addSecurityHistory(node, history);
                }
                String message = MessageFormat.format(rb.getString("Message.UpdatedPrice"), node.getSymbol());
                logger.info(message);
                return true;
            }
        }
        catch (IOException e) {
            logger.severe(e.toString());
            return false;
        }
        return false;
    }

    public static SecurityUpdateWorker getUpdateWorker() {
        return new SecurityUpdateWorker();
    }

    public static class SecurityUpdateWorker
    extends SwingWorker<Void, Void>
    implements MessageListener {
        public SecurityUpdateWorker() {
            this.registerListeners();
        }

        private void registerListeners() {
            MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
        }

        @Override
        protected Void doInBackground() throws Exception {
            UIApplication.getFrame().setNetworkBusy(true);
            List<SecurityNode> list = EngineFactory.getEngine("default").getSecurities();
            int errorCount = 0;
            int size = list.size();
            for (int i = 0; i < list.size(); ++i) {
                if (this.isCancelled()) continue;
                if (list.get(i).getQuoteSource() != QuoteSource.NONE && !SecurityUpdateFactory.updateOne(list.get(i)) && ++errorCount >= 2) {
                    this.setProgress(100);
                    break;
                }
                this.setProgress((int)(((float)i + 1.0f) / (float)size * 100.0f));
            }
            return null;
        }

        @Override
        public void messagePosted(Message event) {
            if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
                this.cancel(true);
            }
        }

        @Override
        protected void done() {
            UIApplication.getFrame().setNetworkBusy(false);
            MessageBus.getInstance().unregisterListener(this, MessageChannel.SYSTEM);
        }
    }
}

