/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;
import jgnash.Main;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.net.currency.CurrencyUpdateFactory;
import jgnash.net.security.AbstractYahooParser;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.plugin.Plugin;
import jgnash.plugin.PluginFactory;
import jgnash.ui.BusyLayerUI;
import jgnash.ui.MainViewPanel;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.ThemeManager;
import jgnash.ui.UIApplication;
import jgnash.ui.account.ExpandingAccountTablePanel;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.actions.OpenAction;
import jgnash.ui.budget.BudgetPanel;
import jgnash.ui.components.MemoryMonitor;
import jgnash.ui.components.SubstanceFontSlider;
import jgnash.ui.components.WaitMessagePanel;
import jgnash.ui.debug.EDTCheckingRepaintManager;
import jgnash.ui.recurring.RecurringPanel;
import jgnash.ui.register.MainRegisterPanel;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.builder.ActionParser;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXStatusBar;

public class MainFrame
extends JFrame
implements MessageListener,
ActionListener {
    private static final String REGISTER_KEY = "register";
    private static final String REGISTER_FOLLOWS_LIST = "RegisterFollowsList";
    private JMenuBar menuBar;
    private JMenu windowMenu;
    private JMenu viewMenu;
    private JMenu reportMenu;
    private MainViewPanel mainView;
    private final transient Resource rb = Resource.get();
    private WaitMessagePanel waitPanel;
    private static boolean registerFollowsTree;
    private MainRegisterPanel registerTreePanel;
    private transient Action editAction;
    private ExpandingAccountTablePanel expandingAccountPanel;
    private JTextField statusField;
    private static final Logger log;
    private final transient PausableThreadPoolExecutor backgroundUpdateExecutor = new PausableThreadPoolExecutor();
    private static final int SCHEDULED_DELAY = 10;
    private JXBusyLabel backgroundOperationLabel;
    private final transient LogHandler logHandler = new LogHandler();
    private Color infoColor = null;
    private BusyLayerUI layerUI;

    public MainFrame() {
        ThemeManager themeManager = new ThemeManager(this);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.buildUI();
        this.setDefaultCloseOperation(1);
        if (Main.checkEDT()) {
            log.info("Installing Event Dispatch Thread Checker into RepaintManager");
            RepaintManager.setCurrentManager(new EDTCheckingRepaintManager());
        }
        this.viewMenu.insertSeparator(this.viewMenu.getComponentCount() + 1);
        this.viewMenu.add(themeManager.buildLookAndFeelMenu());
        this.viewMenu.add(themeManager.buildThemeMenu());
        this.addWindowListener(new ShutdownAdapter());
        RegisterFrame.addRegisterListener(new RegisterListener(){

            @Override
            public void registerEvent(RegisterEvent e) {
                if (e.getAction() == RegisterEvent.Action.OPEN) {
                    MainFrame.this.addWindowItem(e);
                } else if (e.getAction() == RegisterEvent.Action.CLOSE) {
                    MainFrame.this.removeWindowItem(e);
                }
            }
        });
        this.registerListeners();
        this.registerLogHandler(Engine.class);
        this.registerLogHandler(EngineFactory.class);
        this.registerLogHandler(AbstractYahooParser.class);
        this.registerLogHandler(UIApplication.class);
        SecurityUpdateFactory.getUpdateOnStartup();
        this.registerLogHandler(SecurityUpdateFactory.class);
        this.loadPlugins();
        this.setBounds();
        log.fine("UI Construction is complete");
        if (EngineFactory.getEngine("default") != null) {
            this.setOpenState(true);
            this.addViews();
            this.updateTitle();
        }
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.SYSTEM);
    }

    private void setBounds() {
        this.setMinimumSize(new Dimension(500, 300));
        this.pack();
        DialogUtils.addBoundsListener(this);
    }

    private void loadPlugins() {
        PluginFactory.get().loadPlugins();
        PluginFactory.startPlugins();
        for (Plugin plugin : PluginFactory.getPlugins()) {
            JMenuItem[] menuItems = plugin.getMenuItems();
            if (menuItems == null) continue;
            for (JMenuItem menuItem : menuItems) {
                Object precedingIdref = menuItem.getClientProperty("PrecedingMenuIdref");
                if (precedingIdref == null || !(precedingIdref instanceof String)) continue;
                this.addMenuItem((String)precedingIdref, menuItem);
            }
        }
    }

    public static boolean doesRegisterFollowTree() {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        return pref.getBoolean(REGISTER_FOLLOWS_LIST, true);
    }

    public static void setRegisterFollowsTree(boolean follow) {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        registerFollowsTree = follow;
        pref.putBoolean(REGISTER_FOLLOWS_LIST, follow);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.mainView) {
            this.mainViewAction();
        }
    }

    private void addViews() {
        this.registerTreePanel = new MainRegisterPanel();
        this.expandingAccountPanel = new ExpandingAccountTablePanel();
        this.mainView.addView(this.expandingAccountPanel, this.rb.getString("Button.Accounts"), this.rb.getString("ToolTip.AccountList"));
        this.mainView.addView(this.registerTreePanel, this.rb.getString("Button.Register"), this.rb.getString("ToolTip.AccountRegister"));
        this.mainView.addView(new RecurringPanel(), this.rb.getString("Button.Reminders"), this.rb.getString("ToolTip.Reminders"));
        this.mainView.addView(new BudgetPanel(), this.rb.getString("Button.Budgeting"), this.rb.getString("ToolTip.Budgeting"));
    }

    private void addWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                JMenuItem mi = new JMenuItem(new WindowAction(d));
                int size = MainFrame.this.windowMenu.getMenuComponentCount();
                MainFrame.this.windowMenu.insert(mi, size - 2);
                MainFrame.this.windowMenu.setEnabled(true);
            }
        });
    }

    private void addMenuItem(String precedingMenuIdref, JMenuItem newMenuItem) {
        for (Component component : this.menuBar.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            this.addJMenuItem((JMenu)component, precedingMenuIdref, newMenuItem);
        }
    }

    private void addJMenuItem(JMenu menu, String precedingMenuIdref, JMenuItem newMenuItem) {
        Component[] components = menu.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem item;
            if (components[i] instanceof JMenu) {
                this.addJMenuItem((JMenu)components[i], precedingMenuIdref, newMenuItem);
                continue;
            }
            if (!(components[i] instanceof JMenuItem) || !precedingMenuIdref.equals((item = (JMenuItem)components[i]).getClientProperty("idref"))) continue;
            menu.add((Component)newMenuItem, i + 1);
            return;
        }
    }

    private MainViewPanel buildMainView() {
        MainViewPanel panel = new MainViewPanel();
        panel.setBorder(new EmptyBorder(new Insets(2, 6, 0, 2)));
        panel.addActionListener(this);
        return panel;
    }

    private void buildUI() {
        ActionParser actionParser = new ActionParser(this, Resource.get());
        actionParser.preLoadActions("jgnash.ui.actions");
        actionParser.preLoadAction("copy-command", new DefaultEditorKit.CopyAction());
        actionParser.preLoadAction("cut-command", new DefaultEditorKit.CutAction());
        actionParser.preLoadAction("paste-command", new DefaultEditorKit.PasteAction());
        actionParser.preLoadAction("exit-command", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.shutDown();
            }
        });
        actionParser.preLoadAction("open-command", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAction.openAction();
                MainFrame.this.startBackgroundUpdates();
            }
        });
        actionParser.preLoadAction("account-filter-command", new AbstractEnabledAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.expandingAccountPanel.showAccountFilterDialog();
            }
        });
        actionParser.preLoadAction("register-filter-command", new AbstractEnabledAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.registerTreePanel.showAccountFilterDialog();
            }
        });
        actionParser.preLoadAction("currency-background-update-command", new AbstractEnabledAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.backgroundUpdateExecutor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
            }
        });
        actionParser.preLoadAction("security-background-update-command", new AbstractEnabledAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.backgroundUpdateExecutor.schedule(SecurityUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
            }
        });
        actionParser.loadFile("/jgnash/resource/main-frame-actions.xml");
        this.menuBar = actionParser.createMenuBar("main-menu");
        JToolBar toolBar = actionParser.createToolBar("main-toolbar");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.viewMenu = (JMenu)actionParser.getJMenuItem("view-menu-command");
        this.reportMenu = (JMenu)actionParser.getJMenuItem("report-menu-command");
        this.windowMenu = (JMenu)actionParser.getJMenuItem("window-menu-command");
        this.windowMenu.setEnabled(false);
        this.editAction = actionParser.getAction("edit-menu-command");
        if (EngineFactory.getEngine("default") == null) {
            this.setOpenState(false);
        }
        this.setTitle(Main.VERSION);
        this.mainView = this.buildMainView();
        this.backgroundOperationLabel = new JXBusyLabel(new Dimension(18, 18));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.statusField.setFont(this.statusField.getFont().deriveFont(this.statusField.getFont().getSize2D() - 1.0f));
        this.infoColor = this.statusField.getForeground();
        JXStatusBar statusBar = new JXStatusBar();
        statusBar.setResizeHandleEnabled(true);
        statusBar.add((Component)this.statusField, (Object)new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL));
        if (ThemeManager.isLookAndFeelSubstance()) {
            statusBar.add((Component)new SubstanceFontSlider());
        }
        statusBar.add((Component)this.backgroundOperationLabel);
        statusBar.add((Component)new MemoryMonitor(), (Object)new JXStatusBar.Constraint(120));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)toolBar, "North");
        contentPanel.add((Component)this.mainView, "Center");
        contentPanel.add((Component)statusBar, "South");
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)this.menuBar, "North");
        rootPanel.add((Component)contentPanel, "Center");
        this.waitPanel = new WaitMessagePanel();
        this.layerUI = new BusyLayerUI();
        JLayer<JPanel> rootLayer = new JLayer<JPanel>(rootPanel, this.layerUI);
        this.getContentPane().add(rootLayer, "Center");
        this.setGlassPane((Component)((Object)this.waitPanel));
    }

    public void closeAllWindows() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction)) continue;
                    RegisterFrame d = (RegisterFrame)m.getAction().getValue(MainFrame.REGISTER_KEY);
                    d.dispatchEvent(new WindowEvent(d, 201));
                }
            }
        });
    }

    final void displayStatus(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(MainFrame.this.infoColor);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    public void displayWaitMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.layerUI.start();
                MainFrame.this.waitPanel.setMessage(message);
                MainFrame.this.waitPanel.setWaiting(true);
            }
        });
    }

    private void displayWarning(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(Color.RED);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    void dispose(boolean shutDown) {
        PluginFactory.stopPlugins();
        if (!shutDown) {
            for (WindowListener listener : this.getWindowListeners()) {
                if (!(listener instanceof ShutdownAdapter)) continue;
                this.removeWindowListener(listener);
            }
        }
        super.dispose();
    }

    void loadFile(File file) {
        OpenAction.openAction(file);
        this.startBackgroundUpdates();
    }

    void loadLast() {
        OpenAction.openLastAction();
        this.startBackgroundUpdates();
    }

    private void mainViewAction() {
        if (this.mainView.getVisibleComponent() == this.registerTreePanel && registerFollowsTree) {
            this.registerTreePanel.setAccount(this.expandingAccountPanel.getSelectedAccount());
        }
        if (this.mainView.getVisibleComponent() == this.expandingAccountPanel) {
            this.expandingAccountPanel.requestTableFocus();
        }
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        MainFrame.this.setOpenState(false);
                        MainFrame.this.updateTitle();
                        MainFrame.this.removeViews();
                        break;
                    }
                    case FILE_NOT_FOUND: {
                        break;
                    }
                    case FILE_IO_ERROR: {
                        break;
                    }
                    case FILE_LOAD_FAILED: {
                        break;
                    }
                    case ACCOUNT_REMOVE_FAILED: {
                        StaticUIMethods.displayError(MainFrame.this.rb.getString("Message.ErrorAccountRemove"));
                        break;
                    }
                    case FILE_LOAD_SUCCESS: 
                    case FILE_NEW_SUCCESS: {
                        MainFrame.this.setOpenState(true);
                        MainFrame.this.addViews();
                        MainFrame.this.updateTitle();
                        break;
                    }
                }
            }
        });
    }

    void openRemote(String host, int port, String user, String password) {
        OpenAction.openRemote(host, port, user, password);
        this.startBackgroundUpdates();
    }

    private void registerLogHandler(Class<?> clazz) {
        Logger.getLogger(clazz.getName()).addHandler(this.logHandler);
    }

    private void removeViews() {
        this.mainView.removeAll();
        this.expandingAccountPanel = null;
        this.registerTreePanel = null;
    }

    private void removeWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction) || d != m.getAction().getValue(MainFrame.REGISTER_KEY)) continue;
                    MainFrame.this.windowMenu.remove(c);
                    if (MainFrame.this.windowMenu.getItemCount() < 3) {
                        MainFrame.this.windowMenu.setEnabled(false);
                    }
                    return;
                }
            }
        });
    }

    public void setNetworkBusy(boolean busy) {
        this.backgroundOperationLabel.setBusy(busy);
    }

    private void setOpenState(boolean state) {
        this.editAction.setEnabled(state);
        this.reportMenu.setEnabled(state);
    }

    private void shutDown() {
        this.closeAllWindows();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.dispatchEvent(new WindowEvent(MainFrame.this, 201));
            }
        });
    }

    private void startBackgroundUpdates() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SecurityUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.backgroundUpdateExecutor.schedule(SecurityUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
                if (CurrencyUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.backgroundUpdateExecutor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
            }
        });
    }

    public void pauseBackgroundUpdates() {
        this.backgroundUpdateExecutor.pause();
    }

    public void resumeBackgroundUpdates() {
        this.backgroundUpdateExecutor.resume();
    }

    public void stopWaitMessage() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.waitPanel.setWaiting(false);
                MainFrame.this.layerUI.stop();
            }
        });
    }

    private void updateTitle() {
        new UpdateTitleWorker().execute();
    }

    static {
        log = Logger.getLogger(MainFrame.class.getName());
        registerFollowsTree = MainFrame.doesRegisterFollowTree();
    }

    final class UpdateTitleWorker
    extends SwingWorker<Engine, Void> {
        UpdateTitleWorker() {
        }

        @Override
        protected Engine doInBackground() throws Exception {
            return EngineFactory.getEngine("default");
        }

        @Override
        protected void done() {
            try {
                Engine engine = (Engine)this.get();
                if (engine != null) {
                    MainFrame.this.setTitle(Main.VERSION + "  [" + EngineFactory.getActiveDatabase() + ']');
                } else {
                    MainFrame.this.setTitle(Main.VERSION);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                MainFrame.this.setTitle(Main.VERSION);
                log.log(Level.INFO, exception.getMessage(), exception);
            }
        }
    }

    static class PausableThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private boolean isPaused;
        private final ReentrantLock pauseLock = new ReentrantLock();
        private final Condition pausedCondition = this.pauseLock.newCondition();

        public PausableThreadPoolExecutor() {
            super(1, new DefaultDaemonThreadFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.pauseLock.lock();
            try {
                while (this.isPaused) {
                    this.pausedCondition.await();
                }
            }
            catch (InterruptedException ie) {
                t.interrupt();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            this.pauseLock.lock();
            try {
                this.isPaused = true;
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.pauseLock.lock();
            try {
                this.isPaused = false;
                this.pausedCondition.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }
    }

    private static class WindowAction
    extends AbstractAction {
        private static final long serialVersionUID = -598477156303870342L;

        WindowAction(RegisterFrame d) {
            super(d.toString());
            this.putValue(MainFrame.REGISTER_KEY, d);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final RegisterFrame d = (RegisterFrame)this.getValue(MainFrame.REGISTER_KEY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (d.getExtendedState() == 1) {
                        d.setExtendedState(0);
                    }
                    d.toFront();
                }
            });
        }
    }

    private class ShutdownAdapter
    extends WindowAdapter {
        private ShutdownAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.closeAllWindows();
                    MainFrame.this.removeViews();
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            EngineFactory.closeEngine("default");
                            System.exit(0);
                        }
                    };
                    thread.start();
                }
            });
        }
    }

    private class LogHandler
    extends Handler {
        private LogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public synchronized void publish(final LogRecord record) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
                        MainFrame.this.displayWarning(record.getMessage());
                    } else if (record.getLevel() == Level.INFO) {
                        MainFrame.this.displayStatus(record.getMessage());
                    }
                }
            });
        }
    }
}

