/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JDialog;
import jgnash.Main;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.ui.MainFrame;
import jgnash.ui.components.ExceptionDialog;
import jgnash.ui.debug.EventDispatchThreadHangMonitor;
import jgnash.ui.splash.AboutDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class UIApplication
implements Thread.UncaughtExceptionHandler {
    private static final String helpHS = "default/jhelpset.hs";
    private static final String ACCEPT_LICENSE = "licenseaccepted";
    public static final String NEWACCOUNT_ID = "NewAccount";
    public static final String INTRODUCTION_ID = "Introduction";
    public static final String REPORTS_ID = "Reports";
    private final Preferences pref = Preferences.userNodeForPackage(UIApplication.class);
    private static MainFrame mainFrame;
    private static volatile HelpBroker helpBroker;
    private static final Logger logger;
    private static JDialog helpDialog;
    private static JHelp jHelp;

    public UIApplication(final File file) {
        if (this.initFrame()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (file != null) {
                        mainFrame.loadFile(file);
                    } else if (EngineFactory.openLastOnStartup()) {
                        mainFrame.loadLast();
                    }
                }
            });
        }
    }

    public UIApplication(final String host, final int port, final String user, final String password) {
        if (this.initFrame()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.openRemote(host, port, user, password);
                }
            });
        }
    }

    private static void fixWM() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit.getClass().getName().equals("sun.awt.X11.XToolkit")) {
            try {
                Field awtAppClassNameField = toolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(toolkit, Resource.getAppName());
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            if ("gnome-shell".equals(System.getenv("DESKTOP_SESSION")) || "cinnamon".equals(System.getenv("DESKTOP_SESSION")) || "gnome".equals(System.getenv("DESKTOP_SESSION")) || System.getenv("XDG_CURRENT_DESKTOP") != null && System.getenv("XDG_CURRENT_DESKTOP").contains("GNOME")) {
                try {
                    Class<?> x11_wm = Class.forName("sun.awt.X11.XWM");
                    Field awt_wMgr = x11_wm.getDeclaredField("awt_wmgr");
                    awt_wMgr.setAccessible(true);
                    Field other_wm = x11_wm.getDeclaredField("OTHER_WM");
                    other_wm.setAccessible(true);
                    if (awt_wMgr.get(null).equals(other_wm.get(null))) {
                        Field metaCity_Wm = x11_wm.getDeclaredField("METACITY_WM");
                        metaCity_Wm.setAccessible(true);
                        awt_wMgr.set(null, metaCity_Wm.get(null));
                        logger.info("Installed window manager workaround");
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
    }

    private boolean initFrame() {
        boolean result = false;
        UIApplication.fixWM();
        Thread.setDefaultUncaughtExceptionHandler(this);
        if (!this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            if (AboutDialog.showAcceptLicenseDialog()) {
                this.pref.putBoolean(ACCEPT_LICENSE, true);
            } else {
                System.err.println(Resource.get().getString("Message.ErrorLicense"));
            }
        }
        if (this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            result = true;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        mainFrame = new MainFrame();
                        mainFrame.setVisible(true);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (result && Main.enableHangDetection()) {
            Logger.getLogger(UIApplication.class.getName()).info("Installing Event Dispatch Thread Hang Monitor");
            EventDispatchThreadHangMonitor.initMonitoring();
        }
        return result;
    }

    public static MainFrame getFrame() {
        return mainFrame;
    }

    public static synchronized HelpBroker getHelpBroker() {
        if (helpBroker == null) {
            ClassLoader cl = UIApplication.class.getClassLoader();
            try {
                URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
                HelpSet hs = new HelpSet(null, hsURL);
                helpBroker = hs.createHelpBroker();
            }
            catch (Exception ee) {
                System.err.println("HelpSet " + ee.getMessage());
                System.err.println("HelpSet default/jhelpset.hs not found");
            }
        }
        return helpBroker;
    }

    public static void enableHelpOnButton(JButton button, final String id) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIApplication.showHelp(id);
            }
        });
    }

    public static synchronized void showHelp(String id) {
        HelpBroker broker = UIApplication.getHelpBroker();
        if (broker != null) {
            if (jHelp == null) {
                jHelp = new JHelp(broker.getHelpSet());
            }
            try {
                if (id != null) {
                    jHelp.setCurrentID(id);
                }
            }
            catch (BadIDException e) {
                logger.log(Level.INFO, "Invalid help ID: {0}", id);
            }
            if (helpDialog == null) {
                helpDialog = new JDialog((Frame)null, Resource.get().getString("Title.Help"), false);
                helpDialog.setDefaultCloseOperation(2);
                helpDialog.getContentPane().add((Component)jHelp, 0);
                helpDialog.setMinimumSize(new Dimension(500, 400));
                helpDialog.setSize(new Dimension(500, 640));
                helpDialog.setLocationRelativeTo(UIApplication.getFrame());
                helpDialog.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
                DialogUtils.addBoundsListener(helpDialog);
                helpDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        helpDialog = null;
                        jHelp = null;
                    }
                });
            }
            helpDialog.setVisible(true);
        }
    }

    public static void repaint() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainFrame.repaint();
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        if (e.getStackTrace()[0].getClassName().contains("help.plaf")) {
            return;
        }
        logger.log(Level.SEVERE, e.getMessage(), e);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExceptionDialog((Frame)UIApplication.getFrame(), e).setVisible(true);
            }
        });
    }

    public static void restartUI() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Message message;
                MessageBus messageBus;
                if (EngineFactory.getEngine("default") != null) {
                    messageBus = MessageBus.getInstance(EngineFactory.getEngine("default").getName());
                    message = new Message(MessageChannel.SYSTEM, ChannelEvent.UI_RESTARTING, EngineFactory.getEngine("default"));
                    messageBus.fireEvent(message);
                }
                helpBroker = null;
                mainFrame.setVisible(false);
                mainFrame.dispose(false);
                mainFrame = new MainFrame();
                mainFrame.dispose(false);
                mainFrame = new MainFrame();
                mainFrame.setVisible(true);
                if (EngineFactory.getEngine("default") != null) {
                    messageBus = MessageBus.getInstance(EngineFactory.getEngine("default").getName());
                    message = new Message(MessageChannel.SYSTEM, ChannelEvent.UI_RESTARTED, EngineFactory.getEngine("default"));
                    messageBus.fireEvent(message);
                }
            }
        });
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        logger = Logger.getLogger(UIApplication.class.getName());
    }
}

