/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import jgnash.engine.Account;
import jgnash.ui.UIApplication;
import jgnash.ui.account.AccountListTreePane;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class AccountListDialog
extends JDialog
implements ActionListener {
    private transient Resource rb = Resource.get();
    private JButton okButton;
    private JButton cancelButton;
    private AccountListTreePane list;
    private Account account;
    private boolean returnStatus = false;

    public AccountListDialog() {
        this((Account)null, false);
    }

    AccountListDialog(Account a) {
        this(a, false);
    }

    AccountListDialog(Account a, boolean disablePlaceHolders) {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.SelAccount"));
        this.setDefaultCloseOperation(2);
        this.list = new AccountListTreePane("list", true);
        this.list.setExpenseVisible(true);
        this.list.setIncomeVisible(true);
        this.list.setAccountVisible(true);
        if (disablePlaceHolders) {
            this.list.disablePlaceHolders();
        }
        if (a != null) {
            this.list.setSelectedAccount(a);
        }
        this.layoutMainPanel();
    }

    public void disableAccount(Account a) {
        this.list.disableAccount(a);
    }

    public void disablePlaceHolders() {
        this.list.disablePlaceHolders();
    }

    private void initComponents() {
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("max(200dlu;p):g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendRow("f:100dlu:g");
        builder.append((Component)this.list);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public Account getAccount() {
        return this.account;
    }

    private void cancelAction() {
        this.returnStatus = false;
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okAction() {
        this.account = this.list.getSelectedAccount();
        this.returnStatus = true;
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okAction();
        } else if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        }
    }
}

