/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.ui.account.AccountSecuritiesPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class AccountSecuritiesDialog
extends JDialog
implements ActionListener {
    private transient Resource rb = Resource.get();
    private boolean retValue = false;
    private AccountSecuritiesPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private Account account;

    AccountSecuritiesDialog(Account account, Set<SecurityNode> list, Component parent) {
        super(SwingUtilities.getWindowAncestor(parent), Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(this.rb.getString("Title.AccountSecurities"));
        this.setDefaultCloseOperation(2);
        this.account = account;
        this.layoutMainPanel();
        this.setSecuritiesList(list);
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    public static void showDialog(Account account, Component parent) {
        AccountSecuritiesDialog dlg = new AccountSecuritiesDialog(account, account.getSecurities(), parent);
        dlg.setVisible(true);
        if (dlg.getReturnValue()) {
            EngineFactory.getEngine("default").updateAccountSecurities(account, dlg.getSecuritiesList());
        }
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g", "f:p:g(1.0)");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.panel);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
    }

    private void initComponents() {
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.panel = new AccountSecuritiesPanel(this.account);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
    }

    private void setSecuritiesList(Set<SecurityNode> list) {
        this.panel.setSecuritiesList(list);
    }

    public Set<SecurityNode> getSecuritiesList() {
        return this.panel.getSecuritiesList();
    }

    public boolean getReturnValue() {
        return this.retValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.retValue = true;
        } else if (e.getSource() == this.cancelButton) {
            this.retValue = false;
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

