/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.util.Set;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.ui.account.AccountDialog;
import jgnash.util.Resource;

class AccountTools {
    private AccountTools() {
    }

    static void createAccount(Account account) {
        Account parentAccount = account;
        Resource rb = Resource.get();
        Engine engine = EngineFactory.getEngine("default");
        if (parentAccount == null && (parentAccount = engine.getRootAccount()) == null) {
            return;
        }
        AccountDialog dlg = new AccountDialog();
        dlg.setParentAccount(parentAccount);
        dlg.setAccountType(parentAccount.getAccountType());
        dlg.setTitle(rb.getString("Title.NewAccount"));
        dlg.setVisible(true);
        if (dlg.returnStatus()) {
            CurrencyNode currency = dlg.getCurrency();
            AccountType accType = dlg.getAccountType();
            if (currency == null) {
                currency = engine.getRootAccount().getCurrencyNode();
                Logger.getLogger(AccountTools.class.getName()).warning("Forcing use of the default currency");
            }
            Account newAccount = new Account(accType, currency);
            if (accType.getAccountGroup() == AccountGroup.INVEST) {
                Set<SecurityNode> collection = dlg.getAccountSecurities();
                for (SecurityNode node : collection) {
                    newAccount.addSecurity(node);
                }
            }
            newAccount.setName(dlg.getAccountName());
            newAccount.setAccountNumber(dlg.getAccountCode());
            newAccount.setBankId(dlg.getBankId());
            newAccount.setDescription(dlg.getAccountDescription());
            newAccount.setNotes(dlg.getAccountNotes());
            newAccount.setLocked(dlg.isAccountLocked());
            newAccount.setPlaceHolder(dlg.isAccountPlaceholder());
            newAccount.setVisible(dlg.isAccountVisible());
            newAccount.setExcludedFromBudget(dlg.isExcludedFromBudget());
            engine.addAccount(dlg.getParentAccount(), newAccount);
        }
    }

    static void modifyAccount(Account account) {
        if (account == null) {
            return;
        }
        Engine engine = EngineFactory.getEngine("default");
        Resource rb = Resource.get();
        Account parentAccount = account.getParent();
        if (parentAccount == null) {
            if (engine.getRootAccount() == null) {
                return;
            }
            account.setParent(engine.getRootAccount());
        }
        AccountDialog dlg = new AccountDialog();
        dlg.setTitle(rb.getString("Title.ModifyAccount"));
        dlg.setParentAccount(account.getParent());
        dlg.setAccountName(account.getName());
        dlg.setAccountDescription(account.getDescription());
        dlg.setAccountCode(account.getAccountNumber());
        dlg.setBankId(account.getBankId());
        dlg.setCurrency(account.getCurrencyNode());
        dlg.setAccountNotes(account.getNotes());
        dlg.setAccountLocked(account.isLocked());
        dlg.setAccountVisible(account.isVisible());
        dlg.setExcludedFromBudget(account.isExcludedFromBudget());
        if (account.getAccountType().getAccountGroup() == AccountGroup.INVEST) {
            dlg.setAccountSecurities(account.getSecurities());
        }
        dlg.setAccountType(account.getAccountType());
        dlg.disableAccountType(account.getAccountType());
        if (account.getTransactionCount() > 0) {
            dlg.disableAccountCurrency();
        }
        if (account.getTransactionCount() > 0) {
            dlg.setPlaceholderEnabled(false);
        } else {
            dlg.setAccountPlaceholder(account.isPlaceHolder());
        }
        dlg.setVisible(true);
        if (dlg.returnStatus()) {
            Account tAccount = new Account(dlg.getAccountType(), dlg.getCurrency());
            tAccount.setAccountNumber(dlg.getAccountCode());
            tAccount.setBankId(dlg.getBankId());
            tAccount.setName(dlg.getAccountName());
            tAccount.setDescription(dlg.getAccountDescription());
            tAccount.setNotes(dlg.getAccountNotes());
            tAccount.setLocked(dlg.isAccountLocked());
            tAccount.setPlaceHolder(dlg.isAccountPlaceholder());
            if (dlg.getParentAccount() == account) {
                tAccount.setParent(account.getParent());
                Logger.getLogger(AccountTools.class.getName()).warning("Prevented an attempt to assign accounts parent to itself");
            } else {
                tAccount.setParent(dlg.getParentAccount());
            }
            tAccount.setVisible(dlg.isAccountVisible());
            tAccount.setExcludedFromBudget(dlg.isExcludedFromBudget());
            engine.modifyAccount(tAccount, account);
            if (account.getAccountType().getAccountGroup() == AccountGroup.INVEST) {
                engine.updateAccountSecurities(account, dlg.getAccountSecurities());
            }
        }
    }
}

