/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JFileChooser;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.util.builder.Action;

@Action(value="javascript-command")
public class RunJavaScriptAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = 0L;
    private static final String JAVASCRIPT_DIR = "javascriptdir";

    @Override
    public void actionPerformed(ActionEvent e) {
        Preferences pref = Preferences.userNodeForPackage(RunJavaScriptAction.class);
        JFileChooser chooser = new JFileChooser(pref.get(JAVASCRIPT_DIR, null));
        if (chooser.showOpenDialog(UIApplication.getFrame()) == 0) {
            pref.put(JAVASCRIPT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final String file = chooser.getSelectedFile().getAbsolutePath();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try (FileReader reader = new FileReader(file);){
                        new ScriptEngineManager().getEngineByName("JavaScript").eval(reader);
                    }
                    catch (IOException | ScriptException e) {
                        Logger.getLogger(RunJavaScriptAction.class.getName()).log(Level.SEVERE, e.toString(), e);
                    }
                }
            });
        }
    }
}

