/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.ui.components.FormattedJTable;

public abstract class AbstractResultsTable
extends FormattedJTable {
    AbstractResultsTable(TableModel model) {
        super(model);
    }

    protected abstract NumberFormat getNumberFormat(int var1);

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (column == 2) {
            BigDecimal amount = (BigDecimal)this.getModel().getValueAt(row, column);
            if (!this.isRowSelected(row) && amount.signum() < 0) {
                c.setForeground(Color.RED);
            }
        }
        ((JLabel)c).setText(this.getNumberFormat(row).format(this.getModel().getValueAt(row, column)));
        return c;
    }
}

