/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jgnash.ui.budget.AccountRowHeaderPanel;

final class AccountRowHeaderResizeHandler
extends MouseInputAdapter {
    private JScrollPane scrollPane;
    private JViewport rowHeaderViewport;
    private AccountRowHeaderPanel rowHeader;
    private Component corner;
    private volatile boolean resizing;
    private int startX;
    private int startWidth;
    private int minimumWidth;
    private int maximumWidth;
    private static final int DRAG_MARGIN = 5;
    private static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private Cursor oldCursor;
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(AccountRowHeaderResizeHandler.class);
    private static final String HEADER_WIDTH = "headerWidth";
    private int borderWidth;
    private ModelListener listener = new ModelListener();

    public AccountRowHeaderResizeHandler(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public void attachListeners() {
        this.attach();
        this.addMouseListeners();
        this.restoreWidth();
    }

    public void detachListeners() {
        if (this.rowHeader != null) {
            this.rowHeader.getTable().getModel().removeTableModelListener(this.listener);
            if (this.corner != null) {
                this.corner.removeMouseListener(this);
                this.corner.removeMouseMotionListener(this);
                this.corner = null;
            }
            this.rowHeaderViewport = null;
            this.rowHeader = null;
        }
    }

    private void addMouseListeners() {
        if (this.corner == null) {
            throw new IllegalArgumentException("JScrollPane does not have a corner component");
        }
        this.corner.addMouseListener(this);
        this.corner.addMouseMotionListener(this);
    }

    private void attach() {
        this.rowHeaderViewport = this.scrollPane.getRowHeader();
        if (this.rowHeaderViewport == null) {
            throw new IllegalArgumentException("JScrollPane does not have a row header");
        }
        this.rowHeader = (AccountRowHeaderPanel)this.rowHeaderViewport.getView();
        this.minimumWidth = this.rowHeader.getMinimumSize().width;
        this.maximumWidth = this.rowHeader.getMaximumSize().width;
        this.corner = this.scrollPane.getCorner("UPPER_LEFT_CORNER");
        if (this.corner instanceof JComponent) {
            Border border = ((JComponent)this.corner).getBorder();
            Insets insets = border.getBorderInsets(this.corner);
            this.borderWidth = insets.left + insets.right;
        } else {
            this.borderWidth = 0;
        }
        this.rowHeader.getTable().getModel().addTableModelListener(this.listener);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.resizing) {
            return;
        }
        Dimension size = this.rowHeaderViewport.getPreferredSize();
        size.width = this.startWidth + e.getX() - this.startX;
        if (size.width < this.minimumWidth) {
            size.width = this.minimumWidth;
        } else if (size.width > this.maximumWidth) {
            size.width = this.maximumWidth;
        }
        this.setSize(size);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.oldCursor != null) {
            this.corner.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.corner.getWidth() - e.getX() <= 5) {
            if (this.oldCursor == null) {
                this.oldCursor = this.corner.getCursor();
                this.corner.setCursor(RESIZE_CURSOR);
            }
        } else if (this.oldCursor != null) {
            this.corner.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = e.getX();
        this.startWidth = this.rowHeaderViewport.getWidth();
        if (this.startWidth - this.startX > 5) {
            return;
        }
        this.resizing = true;
        if (this.oldCursor == null) {
            this.oldCursor = this.corner.getCursor();
            this.corner.setCursor(RESIZE_CURSOR);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
        this.saveWidth();
    }

    private void restoreWidth() {
        int width;
        if (this.rowHeaderViewport != null && (width = PREFERENCES.getInt(HEADER_WIDTH, 0)) > 0) {
            Dimension size = this.rowHeaderViewport.getPreferredSize();
            size.width = width;
            this.setSize(size);
        }
    }

    private void saveWidth() {
        PREFERENCES.putInt(HEADER_WIDTH, this.rowHeaderViewport.getSize().width);
    }

    private void setSize(Dimension size) {
        Dimension d = (Dimension)size.clone();
        d.width += this.borderWidth;
        this.rowHeaderViewport.setPreferredSize(d);
        this.rowHeader.setPreferredSize(size);
        this.scrollPane.revalidate();
        this.rowHeader.setSize(size);
    }

    private class ModelListener
    implements TableModelListener {
        private ModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (AccountRowHeaderResizeHandler.this.resizing) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountRowHeaderResizeHandler.this.restoreWidth();
                }
            });
        }
    }
}

