/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.Main;
import jgnash.engine.AccountGroup;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.StoredObject;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.engine.budget.BudgetResultsExport;
import jgnash.engine.budget.BudgetResultsModel;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.UIApplication;
import jgnash.ui.budget.AccountRowFooterPanel;
import jgnash.ui.budget.AccountRowHeaderPanel;
import jgnash.ui.budget.AccountRowHeaderResizeHandler;
import jgnash.ui.budget.BudgetColumnFooter;
import jgnash.ui.budget.BudgetColumnHeader;
import jgnash.ui.budget.BudgetComboBox;
import jgnash.ui.budget.BudgetManagerDialog;
import jgnash.ui.budget.BudgetOverviewPanel;
import jgnash.ui.budget.BudgetPeriodModel;
import jgnash.ui.budget.BudgetPeriodPanel;
import jgnash.ui.budget.BudgetPropertiesDialog;
import jgnash.ui.budget.BudgetSparkline;
import jgnash.ui.budget.ExpandingBudgetTableModel;
import jgnash.ui.components.RollOverButton;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public final class BudgetPanel
extends JPanel
implements ActionListener,
MessageListener {
    private static final String COL_VISIBLE = "colVisible";
    private static final String CURRENT_DIR = "cwd";
    private static final String LAST_BUDGET = "lastBudget";
    private static final String ROW_VISIBLE = "rowVisible";
    private Preferences preferences = Preferences.userNodeForPackage(BudgetPanel.class);
    private static final long serialVersionUID = 1L;
    private static final int COMBO_BOX_WIDTH = 180;
    private Budget activeBudget;
    private BudgetOverviewPanel overviewPanel;
    private int budgetYear;
    private BudgetComboBox budgetCombo;
    private List<BudgetPeriodPanel> panels = new ArrayList<BudgetPeriodPanel>();
    private JButton budgetManagerButton;
    private JButton budgetPropertiesButton;
    private JButton budgetExportButton;
    private Engine engine = EngineFactory.getEngine("default");
    private ExpandingBudgetTableModel tableModel;
    private JideScrollPane scrollPane;
    private transient AccountRowHeaderResizeHandler rowHeaderResizeHandler;
    private final ExecutorService pool = Executors.newSingleThreadExecutor();
    private static final Logger logger = Logger.getLogger(BudgetPanel.class.getName());
    private JCheckBox summaryRowVisibleCheckBox;
    private JCheckBox summaryColVisibleCheckBox;
    private BudgetResultsModel resultsModel;

    public BudgetPanel() {
        if (Main.enableVerboseLogging()) {
            logger.setLevel(Level.ALL);
        } else {
            logger.setLevel(Level.OFF);
        }
        this.budgetYear = DateUtils.getCurrentYear();
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.initBudgetCombo();
        Resource rb = Resource.get();
        this.budgetExportButton = new RollOverButton(rb.getString("Button.ExportSpreadsheet"), Resource.getIcon("/jgnash/resource/x-office-spreadsheet.png"));
        this.budgetExportButton.addActionListener(this);
        this.budgetManagerButton = new RollOverButton(rb.getString("Button.BudgetMgr"), Resource.getIcon("/jgnash/resource/document-new.png"));
        this.budgetManagerButton.setToolTipText(rb.getString("ToolTip.BudgetMgr"));
        this.budgetManagerButton.addActionListener(this);
        this.budgetPropertiesButton = new RollOverButton(rb.getString("Button.Properties"), Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.budgetPropertiesButton.addActionListener(this);
        this.summaryRowVisibleCheckBox = new JCheckBox(rb.getString("Button.SumRowVis"));
        this.summaryRowVisibleCheckBox.setSelected(this.preferences.getBoolean(ROW_VISIBLE, true));
        this.summaryRowVisibleCheckBox.setFocusPainted(false);
        this.summaryColVisibleCheckBox = new JCheckBox(rb.getString("Button.SumColVis"));
        this.summaryColVisibleCheckBox.setSelected(this.preferences.getBoolean(COL_VISIBLE, true));
        this.summaryColVisibleCheckBox.setFocusPainted(false);
        this.summaryColVisibleCheckBox.addActionListener(this);
        this.summaryRowVisibleCheckBox.addActionListener(this);
        this.updateControlsState();
    }

    void setBudgetYear(int year) {
        this.budgetYear = year;
        if (this.activeBudget != null) {
            this.activeBudget.setWorkingYear(this.budgetYear);
        }
        this.refreshDisplay();
    }

    private static JPanel getBudgetPanel(List<BudgetPeriodPanel> periodPanels) {
        FormLayout layout = new FormLayout("d", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.add((Component)periodPanels.get(0), CC.xy((int)1, (int)1));
        for (int i = 1; i < periodPanels.size(); ++i) {
            builder.appendColumn("d");
            builder.add((Component)periodPanels.get(i), CC.xy((int)(i + 1), (int)1));
        }
        return builder.getPanel();
    }

    private void initBudgetCombo() {
        this.budgetCombo = new BudgetComboBox();
        SwingWorker<StoredObject, Void> worker = new SwingWorker<StoredObject, Void>(){

            @Override
            protected StoredObject doInBackground() throws Exception {
                Preferences preferences = Preferences.userNodeForPackage(BudgetPanel.class);
                String lastBudgetUUID = preferences.get(BudgetPanel.LAST_BUDGET, null);
                StoredObject o = null;
                if (lastBudgetUUID != null) {
                    o = BudgetPanel.this.engine.getStoredObjectByUuid(lastBudgetUUID);
                }
                return o;
            }

            @Override
            protected void done() {
                try {
                    List<Budget> budgets;
                    StoredObject o = (StoredObject)this.get();
                    if (o != null && o instanceof Budget) {
                        BudgetPanel.this.budgetCombo.setSelectedBudget((Budget)o);
                        BudgetPanel.this.activeBudget = (Budget)o;
                    }
                    if (BudgetPanel.this.activeBudget == null && (budgets = BudgetPanel.this.engine.getBudgetList()).size() > 0) {
                        BudgetPanel.this.budgetCombo.setSelectedBudget(budgets.get(0));
                        BudgetPanel.this.activeBudget = budgets.get(0);
                    }
                    BudgetPanel.this.budgetCombo.setMaximumSize(new Dimension(180, ((BudgetPanel)BudgetPanel.this).budgetCombo.getPreferredSize().height * 3));
                    BudgetPanel.this.budgetCombo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (BudgetPanel.this.activeBudget != BudgetPanel.this.budgetCombo.getSelectedBudget()) {
                                BudgetPanel.this.refreshDisplay();
                            }
                        }
                    });
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        worker.execute();
    }

    void refreshDisplay() {
        logger.entering(BudgetPanel.class.getName(), "refreshDisplay");
        SwingWorker<Integer, Void> worker = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                return BudgetPanel.this.engine.getBudgetList().size();
            }

            @Override
            protected void done() {
                try {
                    int size = (Integer)this.get();
                    BudgetPanel.this.removeBudgetPane();
                    if (size > 0) {
                        BudgetPanel.this.showBudgetPane();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        this.submit(worker);
    }

    private void updateControlsState() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final int budgetCount = BudgetPanel.this.engine.getBudgetList().size();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (budgetCount > 0) {
                            BudgetPanel.this.budgetPropertiesButton.setEnabled(true);
                            BudgetPanel.this.budgetExportButton.setEnabled(BudgetPanel.this.activeBudget.getBudgetPeriod() != BudgetPeriod.DAILY);
                        } else {
                            BudgetPanel.this.budgetPropertiesButton.setEnabled(false);
                            BudgetPanel.this.budgetExportButton.setEnabled(false);
                        }
                    }
                });
            }
        };
        this.submit(r);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("fill:p:g, 5dlu", "d, $rg, d, f:p:g, 5dlu");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this.budgetCombo);
        toolBar.add(this.budgetPropertiesButton);
        toolBar.addSeparator();
        toolBar.add(this.budgetManagerButton);
        toolBar.addSeparator();
        toolBar.add(this.summaryRowVisibleCheckBox);
        toolBar.add(this.summaryColVisibleCheckBox);
        toolBar.addSeparator();
        toolBar.add(this.budgetExportButton);
        builder.add((Component)toolBar, cc.xyw(1, 1, 2));
        this.scrollPane = new JideScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(1, 1));
        this.scrollPane.setColumnHeadersHeightUnified(true);
        this.rowHeaderResizeHandler = new AccountRowHeaderResizeHandler((JScrollPane)this.scrollPane);
        this.overviewPanel = new BudgetOverviewPanel(this);
        this.add((Component)this.overviewPanel, cc.xyw(1, 3, 2));
        this.add((Component)this.scrollPane, cc.xy(1, 4));
        MessageBus.getInstance().registerListener(this, MessageChannel.BUDGET);
        if (this.budgetCombo.getSelectedBudget() != null) {
            this.showBudgetPane();
        }
    }

    private void showBudgetPane() {
        logger.entering(BudgetPanel.class.getName(), "showBudgetPane");
        if (this.tableModel != null) {
            this.tableModel.removeMessageListener(this);
        }
        this.activeBudget = this.budgetCombo.getSelectedBudget();
        if (this.activeBudget != null) {
            CurrencyNode baseCurrency = EngineFactory.getEngine("default").getDefaultCurrency();
            this.resultsModel = new BudgetResultsModel(this.activeBudget, this.budgetYear, baseCurrency);
            this.tableModel = new ExpandingBudgetTableModel(this.resultsModel);
            this.tableModel.addMessageListener(this);
            this.activeBudget.setWorkingYear(this.budgetYear);
            this.preferences.put(LAST_BUDGET, this.activeBudget.getUuid());
            List<BudgetPeriodPanel> newPanels = this.buildPeriodPanels();
            JPanel budgetPanel = BudgetPanel.getBudgetPanel(newPanels);
            AccountRowHeaderPanel accountPanel = new AccountRowHeaderPanel(this.activeBudget, this.tableModel);
            BudgetColumnHeader header = new BudgetColumnHeader(newPanels);
            this.panels = newPanels;
            for (BudgetPeriodPanel periodPanel : this.panels) {
                periodPanel.setRowHeight(accountPanel.getRowHeight());
            }
            this.scrollPane.setViewportView((Component)budgetPanel);
            this.scrollPane.setRowHeaderView((Component)accountPanel);
            this.scrollPane.setColumnHeaderView((Component)header);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", (Component)accountPanel.getTableHeader());
            if (this.summaryRowVisibleCheckBox.isSelected()) {
                this.addSummaryRows();
            }
            if (this.activeBudget.getBudgetPeriod() != BudgetPeriod.YEARLY && this.summaryColVisibleCheckBox.isSelected()) {
                this.addSummaryColumn();
                if (this.summaryRowVisibleCheckBox.isSelected()) {
                    this.addSummaryCorner();
                }
            }
            this.rowHeaderResizeHandler.attachListeners();
            this.showCurrentPeriod();
            this.overviewPanel.updateSparkLines();
        }
        logger.exiting(BudgetPanel.class.getName(), "showBudgetPane");
    }

    private void removeBudgetPane() {
        logger.entering(BudgetPanel.class.getName(), "removeBudgetPane");
        this.rowHeaderResizeHandler.detachListeners();
        this.scrollPane.setRowHeaderView(null);
        this.scrollPane.setViewportView(null);
        this.scrollPane.setColumnHeaderView(null);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", null);
        this.removeSummaryColumn();
        this.removeSummaryRows();
        logger.exiting(BudgetPanel.class.getName(), "removeBudgetPane");
    }

    private void addSummaryColumn() {
        int rowHeight = ((AccountRowHeaderPanel)this.scrollPane.getRowHeader().getView()).getRowHeight();
        AccountRowFooterPanel rowFooter = new AccountRowFooterPanel(this.tableModel);
        rowFooter.setRowHeight(rowHeight);
        this.scrollPane.setRowFooterView((Component)rowFooter);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)rowFooter.getTableHeader());
    }

    private void removeSummaryColumn() {
        if (this.scrollPane.getRowFooter() != null) {
            if (this.scrollPane.getRowFooter().getView() != null) {
                ((AccountRowFooterPanel)this.scrollPane.getRowFooter().getView()).unregisterListeners();
            }
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
            this.scrollPane.setCorner("LOWER_RIGHT_CORNER", null);
            this.scrollPane.setRowFooterView(null);
        }
    }

    private void addSummaryRows() {
        BudgetColumnFooter footer = new BudgetColumnFooter(this.panels);
        this.scrollPane.setColumnFooterView((Component)footer);
        JComponent corner = ((AccountRowHeaderPanel)this.scrollPane.getRowHeader().getView()).getFooter();
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", (Component)corner);
    }

    private void removeSummaryRows() {
        this.scrollPane.setColumnFooterView(null);
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", null);
    }

    private void addSummaryCorner() {
        JComponent footer = ((AccountRowFooterPanel)this.scrollPane.getRowFooter().getView()).getFooter();
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", (Component)footer);
    }

    private void removeSummaryCorner() {
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", null);
    }

    private void updateSummaryColumnVisibility() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BudgetPanel.this.preferences.putBoolean(BudgetPanel.COL_VISIBLE, BudgetPanel.this.summaryColVisibleCheckBox.isSelected());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BudgetPanel.this.summaryColVisibleCheckBox.isSelected()) {
                            if (BudgetPanel.this.activeBudget.getBudgetPeriod() != BudgetPeriod.YEARLY) {
                                BudgetPanel.this.addSummaryColumn();
                                if (BudgetPanel.this.summaryRowVisibleCheckBox.isSelected()) {
                                    BudgetPanel.this.addSummaryCorner();
                                }
                            }
                        } else {
                            BudgetPanel.this.removeSummaryColumn();
                            BudgetPanel.this.removeSummaryCorner();
                        }
                    }
                });
            }
        };
        this.submit(runnable);
    }

    private void updateSummaryRowVisibility() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BudgetPanel.this.preferences.putBoolean(BudgetPanel.ROW_VISIBLE, BudgetPanel.this.summaryRowVisibleCheckBox.isSelected());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BudgetPanel.this.summaryRowVisibleCheckBox.isSelected()) {
                            BudgetPanel.this.addSummaryRows();
                            if (BudgetPanel.this.summaryColVisibleCheckBox.isSelected() && BudgetPanel.this.activeBudget.getBudgetPeriod() != BudgetPeriod.YEARLY) {
                                BudgetPanel.this.addSummaryCorner();
                            }
                        } else {
                            BudgetPanel.this.removeSummaryRows();
                            BudgetPanel.this.removeSummaryCorner();
                        }
                    }
                });
            }
        };
        this.submit(runnable);
    }

    private List<BudgetPeriodPanel> buildPeriodPanels() {
        List<BudgetPeriodDescriptor> descriptors = BudgetPeriodDescriptorFactory.getDescriptors(this.budgetYear, this.activeBudget.getBudgetPeriod());
        ArrayList<BudgetPeriodPanel> newPanels = new ArrayList<BudgetPeriodPanel>();
        for (BudgetPeriodDescriptor descriptor : descriptors) {
            BudgetPeriodPanel panel = new BudgetPeriodPanel(new BudgetPeriodModel(descriptor, this.tableModel));
            newPanels.add(panel);
        }
        return newPanels;
    }

    private void showCurrentPeriod() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Date today = new Date();
                for (int i = 0; i < BudgetPanel.this.panels.size(); ++i) {
                    if (!((BudgetPeriodPanel)BudgetPanel.this.panels.get(i)).isBetween(today)) continue;
                    final BudgetPeriodPanel panel = i > 2 ? (BudgetPeriodPanel)BudgetPanel.this.panels.get(i - 2) : (i > 1 ? (BudgetPeriodPanel)BudgetPanel.this.panels.get(i - 1) : (BudgetPeriodPanel)BudgetPanel.this.panels.get(i));
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            panel.scrollRectToVisible(panel.getBounds());
                        }
                    });
                }
            }
        };
        this.submit(r);
    }

    void submit(Runnable r) {
        this.pool.submit(r);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.budgetManagerButton) {
            this.showManagerDialog();
        } else if (e.getSource() == this.budgetPropertiesButton) {
            this.showPropertiesDialog();
        } else if (e.getSource() == this.summaryColVisibleCheckBox) {
            this.updateSummaryColumnVisibility();
        } else if (e.getSource() == this.summaryRowVisibleCheckBox) {
            this.updateSummaryRowVisibility();
        } else if (e.getSource() == this.budgetExportButton) {
            this.exportBudgetAction();
        }
    }

    private void showManagerDialog() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BudgetManagerDialog.showDialog();
            }
        };
        this.submit(r);
    }

    private void showPropertiesDialog() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BudgetPropertiesDialog d = new BudgetPropertiesDialog(BudgetPanel.this.activeBudget);
                        d.setVisible(true);
                    }
                });
            }
        };
        this.submit(r);
    }

    @Override
    public void messagePosted(final Message event) {
        switch (event.getEvent()) {
            case TRANSACTION_ADD: 
            case TRANSACTION_REMOVE: {
                this.overviewPanel.updateSparkLines();
                break;
            }
            case BUDGET_ADD: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int budgetCount = BudgetPanel.this.engine.getBudgetList().size();
                        if (budgetCount == 1) {
                            BudgetPanel.this.showBudgetPane();
                        }
                        BudgetPanel.this.updateControlsState();
                    }
                });
                break;
            }
            case BUDGET_REMOVE: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BudgetPanel.this.engine.getBudgetList().isEmpty()) {
                            BudgetPanel.this.removeBudgetPane();
                            BudgetPanel.this.overviewPanel.updateSparkLines();
                        }
                        if (BudgetPanel.this.activeBudget.equals(event.getObject(MessageProperty.BUDGET))) {
                            BudgetPanel.this.refreshDisplay();
                        }
                        BudgetPanel.this.updateControlsState();
                    }
                });
                break;
            }
            case BUDGET_UPDATE: {
                if (!this.activeBudget.equals(event.getObject(MessageProperty.BUDGET))) break;
                this.refreshDisplay();
                this.updateControlsState();
                break;
            }
            case ACCOUNT_ADD: 
            case ACCOUNT_REMOVE: 
            case ACCOUNT_MODIFY: 
            case BUDGET_GOAL_UPDATE: {
                this.overviewPanel.updateSparkLines();
                break;
            }
        }
    }

    List<AccountGroup> getAccountGroups() {
        return this.tableModel.getAccountGroups();
    }

    Icon getSparkLineIcon(AccountGroup group) {
        ArrayList<BigDecimal> remaining = new ArrayList<BigDecimal>();
        for (BudgetPeriodDescriptor descriptor : this.resultsModel.getDescriptorList()) {
            remaining.add(this.resultsModel.getResults(descriptor, group).getRemaining());
        }
        return BudgetSparkline.getSparklineImage(remaining);
    }

    private void exportBudgetAction() {
        Preferences pref = Preferences.userNodeForPackage(BudgetPanel.class);
        final Resource rb = Resource.get();
        JFileChooser chooser = new JFileChooser(pref.get(CURRENT_DIR, null));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(rb.getString("Label.SpreadsheetFiles") + " (*.xls, *.xlsx)", "xls", "xlsx"));
        if (chooser.showSaveDialog(UIApplication.getFrame()) == 0) {
            pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final File file = new File(chooser.getSelectedFile().getAbsolutePath());
            final class Export
            extends SwingWorker<Void, Void> {
                Export() {
                }

                @Override
                protected Void doInBackground() throws Exception {
                    UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
                    BudgetResultsExport.exportBudgetResultsModel(file, BudgetPanel.this.resultsModel);
                    return null;
                }

                @Override
                protected void done() {
                    UIApplication.getFrame().stopWaitMessage();
                }
            }
            new Export().execute();
        }
    }
}

